/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.Identifier;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class LabeledStatement
extends Statement {
    public LabeledStatement(int offset) {
        super(offset);
    }

    public LabeledStatement(int offset, String name) {
        super(offset);
        this.setLabel(name);
    }

    public LabeledStatement(String name, Statement statement) {
        this(statement.getOffset());
        this.setLabel(name);
        this.setStatement(statement);
    }

    public final String getLabel() {
        return this.getChildByRole(Roles.LABEL).getName();
    }

    public final void setLabel(String value) {
        this.setChildByRole(Roles.LABEL, Identifier.create(value));
    }

    public final Identifier getLabelToken() {
        return this.getChildByRole(Roles.LABEL);
    }

    public final void setLabelToken(Identifier value) {
        this.setChildByRole(Roles.LABEL, value);
    }

    public final JavaTokenNode getColonToken() {
        return this.getChildByRole(Roles.COLON);
    }

    public final Statement getStatement() {
        return this.getChildByRole(Roles.EMBEDDED_STATEMENT);
    }

    public final void setStatement(Statement value) {
        this.setChildByRole(Roles.EMBEDDED_STATEMENT, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitLabeledStatement(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof LabeledStatement) {
            LabeledStatement otherStatement = (LabeledStatement)other;
            return LabeledStatement.matchString(this.getLabel(), otherStatement.getLabel()) && this.getStatement().matches(otherStatement.getStatement(), match);
        }
        return false;
    }
}

