/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.SAXException;

public class ResourceManagerConfiguration_impl
extends MetaDataObject_impl
implements ResourceManagerConfiguration {
    private static final long serialVersionUID = -8326190554827990517L;
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports = Import.EMPTY_IMPORTS;
    private ExternalResourceBinding[] mBindings = ExternalResourceBinding.EMPTY_RESOURCE_BINDINGS;
    private ExternalResourceDescription[] mExternalResources = ExternalResourceDescription.EMPTY_EXTERNAL_RESORUCE_DESCRIPTIONS;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("resourceManagerConfiguration", new PropertyXmlInfo[]{new PropertyXmlInfo("import", null), new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("import", true), new PropertyXmlInfo("externalResources"), new PropertyXmlInfo("externalResourceBindings")});

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void setName(String aName) {
        this.mName = aName;
    }

    @Override
    public String getVersion() {
        return this.mVersion;
    }

    @Override
    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    @Override
    public String getVendor() {
        return this.mVendor;
    }

    @Override
    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    @Override
    public Import[] getImports() {
        return this.mImports;
    }

    @Override
    public void setImports(Import[] aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    @Override
    public ExternalResourceDescription[] getExternalResources() {
        return this.mExternalResources;
    }

    @Override
    public void setExternalResources(ExternalResourceDescription[] aDescriptions) {
        this.mExternalResources = aDescriptions != null ? aDescriptions : ExternalResourceDescription.EMPTY_EXTERNAL_RESORUCE_DESCRIPTIONS;
    }

    @Override
    public ExternalResourceBinding[] getExternalResourceBindings() {
        return this.mBindings;
    }

    @Override
    public void setExternalResourceBindings(ExternalResourceBinding[] aBindings) {
        this.mBindings = aBindings != null ? aBindings : ExternalResourceBinding.EMPTY_RESOURCE_BINDINGS;
    }

    @Override
    public void addExternalResource(ExternalResourceDescription aExternalResourceDescription) {
        ExternalResourceDescription[] current = this.getExternalResources();
        ExternalResourceDescription[] newArr = new ExternalResourceDescription[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aExternalResourceDescription;
        this.setExternalResources(newArr);
    }

    @Override
    public void addExternalResourceBinding(ExternalResourceBinding aExternalResourceBinding) {
        ExternalResourceBinding[] current = this.getExternalResourceBindings();
        ExternalResourceBinding[] newArr = new ExternalResourceBinding[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aExternalResourceBinding;
        this.setExternalResourceBindings(newArr);
    }

    @Override
    public void removeExternalResource(ExternalResourceDescription aExternalResourceDescription) {
        ExternalResourceDescription[] current = this.getExternalResources();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aExternalResourceDescription) continue;
            ExternalResourceDescription[] newArr = new ExternalResourceDescription[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setExternalResources(newArr);
            break;
        }
    }

    @Override
    public void removeExternalResourceBinding(ExternalResourceBinding aExternalResourceBinding) {
        ExternalResourceBinding[] current = this.getExternalResourceBindings();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aExternalResourceBinding) continue;
            ExternalResourceBinding[] newArr = new ExternalResourceBinding[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setExternalResourceBindings(newArr);
            break;
        }
    }

    @Override
    @Deprecated
    public Import getImport() {
        if (this.mImports.length > 0) {
            return this.mImports[0];
        }
        return null;
    }

    @Override
    @Deprecated
    public void setImport(Import aImport) {
        this.mImports = new Import[]{aImport};
    }

    @Override
    public synchronized void resolveImports() throws InvalidXMLException {
        if (this.getImports().length == 0) {
            this.resolveImports(null, null);
        } else {
            this.resolveImports(new TreeSet<String>(), UIMAFramework.newDefaultResourceManager());
        }
    }

    @Override
    public synchronized void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(this.getImports().length == 0 ? null : new TreeSet<String>(), aResourceManager);
    }

    @Override
    public synchronized void resolveImports(Collection<String> aAlreadyImportedURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        ExternalResourceBinding[] existingBindings;
        ExternalResourceDescription[] existingResources;
        ArrayList<ExternalResourceDescription> importedResources = null;
        ArrayList<ExternalResourceBinding> importedBindings = null;
        if (this.getImports().length != 0) {
            if (this.getSourceUrl() != null) {
                aAlreadyImportedURLs.add(this.getSourceUrl().toString());
            }
            importedResources = new ArrayList<ExternalResourceDescription>();
            importedBindings = new ArrayList<ExternalResourceBinding>();
            Import[] imports = this.getImports();
            for (int i = 0; i < imports.length; ++i) {
                URL url;
                if (imports[i] instanceof Import_impl) {
                    ((Import_impl)imports[i]).setSourceUrlIfNull(this.getSourceUrl());
                }
                if (aAlreadyImportedURLs.contains((url = imports[i].findAbsoluteUrl(aResourceManager)).toString())) continue;
                aAlreadyImportedURLs.add(url.toString());
                try {
                    this.resolveImport(url, aAlreadyImportedURLs, importedResources, importedBindings, aResourceManager);
                    continue;
                }
                catch (IOException e) {
                    throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, imports[i].getSourceUrlString()}, e);
                }
            }
        }
        if ((existingResources = this.getExternalResources()) == null) {
            existingResources = ExternalResourceDescription.EMPTY_EXTERNAL_RESORUCE_DESCRIPTIONS;
            this.setExternalResources(ExternalResourceDescription.EMPTY_EXTERNAL_RESORUCE_DESCRIPTIONS);
        }
        if (importedResources != null) {
            ExternalResourceDescription[] newResources = new ExternalResourceDescription[existingResources.length + importedResources.size()];
            System.arraycopy(existingResources, 0, newResources, 0, existingResources.length);
            for (int i = 0; i < importedResources.size(); ++i) {
                newResources[existingResources.length + i] = (ExternalResourceDescription)importedResources.get(i);
            }
            this.setExternalResources(newResources);
        }
        if ((existingBindings = this.getExternalResourceBindings()) == null) {
            existingBindings = ExternalResourceBinding.EMPTY_RESOURCE_BINDINGS;
            this.setExternalResourceBindings(ExternalResourceBinding.EMPTY_RESOURCE_BINDINGS);
        }
        if (null != importedBindings) {
            ExternalResourceBinding[] newBindings = new ExternalResourceBinding[existingBindings.length + importedBindings.size()];
            System.arraycopy(existingBindings, 0, newBindings, 0, existingBindings.length);
            for (int i = 0; i < importedBindings.size(); ++i) {
                newBindings[existingBindings.length + i] = (ExternalResourceBinding)importedBindings.get(i);
            }
            this.setExternalResourceBindings(newBindings);
        }
        this.setImports(Import.EMPTY_IMPORTS);
    }

    private void resolveImport(URL aURL, Collection<String> aAlreadyImportedURLs, Collection<ExternalResourceDescription> aResultResources, Collection<ExternalResourceBinding> aResultBindings, ResourceManager aResourceManager) throws InvalidXMLException, IOException {
        XMLInputSource input = new XMLInputSource(aURL);
        ResourceManagerConfiguration desc = UIMAFramework.getXMLParser().parseResourceManagerConfiguration(input);
        desc.resolveImports(aAlreadyImportedURLs, aResourceManager);
        aResultResources.addAll(Arrays.asList(desc.getExternalResources()));
        aResultBindings.addAll(Arrays.asList(desc.getExternalResourceBindings()));
    }

    @Override
    protected void writePropertyAsElement(PropertyXmlInfo aPropInfo, String aNamespace) throws SAXException {
        if (!"import".equals(aPropInfo.propertyName)) {
            super.writePropertyAsElement(aPropInfo, aNamespace);
        }
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

