/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public class QNameValue
extends QualifiedNameValue {
    public QNameValue(NamePool namePool, int n) {
        this.prefix = namePool.getPrefix(n);
        this.uri = namePool.getURI(n);
        if (this.uri.length() == 0) {
            this.uri = null;
        }
        this.localPart = namePool.getLocalName(n);
        this.typeLabel = BuiltInAtomicType.QNAME;
    }

    public QNameValue(String string, String string2, String string3) {
        this(string, string2, string3, BuiltInAtomicType.QNAME);
    }

    public QNameValue(String string, String string2, String string3, AtomicType atomicType) {
        this.prefix = string == null ? "" : string;
        this.uri = "".equals(string2) ? null : string2;
        this.localPart = string3;
        this.typeLabel = atomicType;
    }

    public QNameValue(String string, String string2, String string3, AtomicType atomicType, NameChecker nameChecker) throws XPathException {
        if (nameChecker != null && !nameChecker.isValidNCName(string3)) {
            DynamicError dynamicError = new DynamicError("Malformed local name in QName: '" + string3 + '\'');
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.prefix = string == null ? "" : string;
        String string4 = this.uri = "".equals(string2) ? null : string2;
        if (nameChecker != null && this.uri == null && this.prefix.length() != 0) {
            DynamicError dynamicError = new DynamicError("QName has null namespace but non-empty prefix");
            dynamicError.setErrorCode("FOCA0002");
            throw dynamicError;
        }
        this.localPart = string3;
        this.typeLabel = atomicType;
    }

    public AtomicValue copy(AtomicType atomicType) {
        QNameValue qNameValue = new QNameValue(this.prefix, this.uri, this.localPart);
        qNameValue.typeLabel = atomicType;
        return qNameValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.QNAME;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 530: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert QName to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public AtomicValue getComponent(int n) {
        if (n == 8) {
            return StringValue.makeRestrictedString(this.localPart, BuiltInAtomicType.NCNAME, null);
        }
        if (n == 9) {
            return new AnyURIValue(this.uri);
        }
        if (n == 10) {
            if (this.prefix.length() == 0) {
                return null;
            }
            return StringValue.makeRestrictedString(this.prefix, BuiltInAtomicType.NCNAME, null);
        }
        throw new UnsupportedOperationException("Component of QName must be URI, Local Name, or Prefix");
    }

    public boolean equals(Object object) {
        QNameValue qNameValue = (QNameValue)object;
        return this.localPart.equals(qNameValue.localPart) && (this.uri == qNameValue.uri || this.uri != null && this.uri.equals(qNameValue.uri));
    }
}

