/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;

public final class XSLValueOf
extends XSLStringConstructor {
    private boolean disable = false;
    private Expression separator;

    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        String string2 = null;
        String string3 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string4 = this.getNamePool().getClarkName(n);
            if (string4 == "disable-output-escaping") {
                string2 = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string4 == "select") {
                string = attributeCollection.getValue(i);
                continue;
            }
            if (string4 == "separator") {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        if (string3 != null) {
            this.separator = this.makeAttributeValueTemplate(string3);
        }
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.disable = true;
            } else if (string2.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either 'yes' or 'no'", "XTSE0020");
            }
        }
    }

    public void validate() throws XPathException {
        super.validate();
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
    }

    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0870";
    }

    public Expression compile(Executable executable) throws XPathException {
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        if (this.separator == null && this.select != null && this.backwardsCompatibleModeIsEnabled()) {
            if (!this.select.getItemType(typeHierarchy).isAtomicType()) {
                this.select = new Atomizer(this.select, this.getStaticContext().getConfiguration());
            }
            if (Cardinality.allowsMany(this.select.getCardinality())) {
                this.select = new FirstItemExpression(this.select);
            }
            if (!typeHierarchy.isSubType(this.select.getItemType(typeHierarchy), BuiltInAtomicType.STRING)) {
                this.select = new AtomicSequenceConverter(this.select, BuiltInAtomicType.STRING);
            }
        } else if (this.separator == null) {
            this.separator = this.select == null ? new StringLiteral(StringValue.EMPTY_STRING) : new StringLiteral(StringValue.SINGLE_SPACE);
        }
        ValueOf valueOf = new ValueOf(this.select, this.disable, false);
        this.compileContent(executable, valueOf, this.separator);
        ExpressionTool.makeParentReferences(valueOf);
        return valueOf;
    }
}

