/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(BeanSerializer.class);
    private static HashMap beanCache = new HashMap();
    private static Class[] _serializableClasses = new Class[0];
    private static Class[] _JSONClasses = new Class[0];

    public static BeanData analyzeBean(Class clazz) throws IntrospectionException {
        log.info("analyzing " + clazz.getName());
        BeanData bd = new BeanData();
        bd.beanInfo = Introspector.getBeanInfo(clazz, Object.class);
        PropertyDescriptor[] props = bd.beanInfo.getPropertyDescriptors();
        bd.readableProps = new HashMap();
        bd.writableProps = new HashMap();
        for (int i = 0; i < props.length; ++i) {
            if (props[i].getName().equals("declaringClass")) continue;
            if (props[i].getWriteMethod() != null) {
                bd.writableProps.put(props[i].getName(), props[i].getWriteMethod());
            }
            if (props[i].getReadMethod() == null) continue;
            bd.readableProps.put(props[i].getName(), props[i].getReadMethod());
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanData getBeanData(Class clazz) throws IntrospectionException {
        BeanData bd;
        HashMap hashMap = beanCache;
        synchronized (hashMap) {
            bd = (BeanData)beanCache.get(clazz);
            if (bd == null) {
                bd = BeanSerializer.analyzeBean(clazz);
                beanCache.put(clazz, bd);
            }
        }
        return bd;
    }

    @Override
    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return !clazz.isArray() && !clazz.isPrimitive() && !clazz.isInterface() && (jsonClazz == null || jsonClazz == JSONObject.class);
    }

    @Override
    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    @Override
    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    @Override
    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        BeanData bd;
        try {
            bd = BeanSerializer.getBeanData(o.getClass());
        }
        catch (IntrospectionException e) {
            throw new MarshallException(o.getClass().getName() + " is not a bean", e);
        }
        JSONObject val = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                val.put("javaClass", (Object)o.getClass().getName());
            }
            catch (JSONException e) {
                throw new MarshallException("JSONException: " + e.getMessage(), e);
            }
        }
        Iterator i = bd.readableProps.entrySet().iterator();
        Object[] args = new Object[]{};
        while (i.hasNext()) {
            Object result;
            Map.Entry ent = i.next();
            String prop = (String)ent.getKey();
            Method getMethod = (Method)ent.getValue();
            if (log.isDebugEnabled()) {
                log.debug("invoking " + getMethod.getName() + "()");
            }
            try {
                result = getMethod.invoke(o, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new MarshallException("bean " + o.getClass().getName() + " can't invoke " + getMethod.getName() + ": " + e.getMessage(), e);
            }
            try {
                if (result == null && !this.ser.getMarshallNullAttributes()) continue;
                try {
                    Object json = this.ser.marshall(state, o, result, prop);
                    if (JSONSerializer.CIRC_REF_OR_DUPLICATE == json) continue;
                    val.put(prop, json);
                }
                catch (JSONException e) {
                    throw new MarshallException("JSONException: " + e.getMessage(), e);
                }
            }
            catch (MarshallException e) {
                throw new MarshallException("bean " + o.getClass().getName() + " " + e.getMessage(), e);
            }
        }
        return val;
    }

    @Override
    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        BeanData bd;
        JSONObject jso = (JSONObject)o;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean", e);
        }
        int match = 0;
        int mismatch = 0;
        for (Map.Entry ent : bd.writableProps.entrySet()) {
            String prop = (String)ent.getKey();
            if (jso.has(prop)) {
                ++match;
                continue;
            }
            ++mismatch;
        }
        if (match == 0) {
            throw new UnmarshallException("bean has no matches");
        }
        ObjectMatch returnValue = new ObjectMatch(-1);
        state.setSerialized(o, returnValue);
        ObjectMatch m = null;
        Iterator i = jso.keys();
        while (i.hasNext()) {
            String field = (String)i.next();
            Method setMethod = (Method)bd.writableProps.get(field);
            if (setMethod != null) {
                try {
                    Class<?>[] param = setMethod.getParameterTypes();
                    if (param.length != 1) {
                        throw new UnmarshallException("bean " + clazz.getName() + " method " + setMethod.getName() + " does not have one arg");
                    }
                    ObjectMatch tmp = this.ser.tryUnmarshall(state, param[0], jso.get(field));
                    if (tmp == null) continue;
                    if (m == null) {
                        m = tmp;
                        continue;
                    }
                    m = m.max(tmp);
                    continue;
                }
                catch (UnmarshallException e) {
                    throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage(), e);
                }
                catch (JSONException e) {
                    throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage(), e);
                }
            }
            ++mismatch;
        }
        if (m != null) {
            returnValue.setMismatch(m.max(new ObjectMatch(mismatch)).getMismatch());
        } else {
            returnValue.setMismatch(mismatch);
        }
        return returnValue;
    }

    @Override
    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        Object instance;
        BeanData bd;
        JSONObject jso = (JSONObject)o;
        try {
            bd = BeanSerializer.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("instantiating " + clazz.getName());
        }
        try {
            instance = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new UnmarshallException("could not instantiate bean of type " + clazz.getName() + ", make sure it has a no argument constructor and that it is not an interface or abstract class", e);
        }
        catch (IllegalAccessException e) {
            throw new UnmarshallException("could not instantiate bean of type " + clazz.getName(), e);
        }
        catch (RuntimeException e) {
            throw new UnmarshallException("could not instantiate bean of type " + clazz.getName(), e);
        }
        state.setSerialized(o, instance);
        Object[] invokeArgs = new Object[1];
        Iterator i = jso.keys();
        while (i.hasNext()) {
            Object fieldVal;
            String field = (String)i.next();
            Method setMethod = (Method)bd.writableProps.get(field);
            if (setMethod == null) continue;
            try {
                Class<?>[] param = setMethod.getParameterTypes();
                fieldVal = this.ser.unmarshall(state, param[0], jso.get(field));
            }
            catch (UnmarshallException e) {
                throw new UnmarshallException("could not unmarshall field \"" + field + "\" of bean " + clazz.getName(), e);
            }
            catch (JSONException e) {
                throw new UnmarshallException("could not unmarshall field \"" + field + "\" of bean " + clazz.getName(), e);
            }
            if (log.isDebugEnabled()) {
                log.debug("invoking " + setMethod.getName() + "(" + String.valueOf(fieldVal) + ")");
            }
            invokeArgs[0] = fieldVal;
            try {
                setMethod.invoke(instance, invokeArgs);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new UnmarshallException("bean " + clazz.getName() + "can't invoke " + setMethod.getName() + ": " + e.getMessage(), e);
            }
        }
        return instance;
    }

    protected static class BeanData {
        public BeanInfo beanInfo;
        public Map readableProps;
        public Map writableProps;

        protected BeanData() {
        }
    }
}

