/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.client;

import java.net.URI;
import java.util.HashMap;
import org.jabsorb.client.ClientError;
import org.jabsorb.client.Session;
import org.jabsorb.client.URLConnectionSession;

public class TransportRegistry {
    private static TransportRegistry singleton;
    private RegistryMap registry = new RegistryMap();

    public static synchronized TransportRegistry i() {
        if (singleton == null) {
            singleton = new TransportRegistry();
        }
        return singleton;
    }

    public void registerTransport(String scheme, SessionFactory factory) {
        this.registry.put(scheme, factory);
    }

    public Session createSession(String uriString) {
        try {
            URI uri = new URI(uriString);
            SessionFactory found = this.registry.get(uri.getScheme());
            if (found != null) {
                return found.newSession(uri);
            }
            return new URLConnectionSession(uri.toURL());
        }
        catch (Exception e) {
            throw new ClientError(e);
        }
    }

    static class RegistryMap {
        HashMap<String, SessionFactory> rep = new HashMap();

        public SessionFactory get(String key) {
            return this.rep.get(key);
        }

        public SessionFactory put(String key, SessionFactory value) {
            return this.rep.put(key, value);
        }
    }

    public static interface SessionFactory {
        public Session newSession(URI var1);
    }
}

