/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.yaafi.framework.configuration.ComponentConfigurationPropertiesResolver;
import org.apache.fulcrum.yaafi.framework.util.InputStreamLocator;

public abstract class ComponentConfigurationPropertiesResolverBaseImpl
implements ComponentConfigurationPropertiesResolver,
LogEnabled,
Contextualizable,
Configurable {
    private Logger logger;
    private Context context;
    private Configuration configuration;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Context getContext() {
        return this.context;
    }

    protected File getApplicationRootDir() {
        try {
            return (File)this.getContext().get((Object)"urn:avalon:home");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected String getLocation() {
        return this.configuration.getChild("location").getValue("/componentConfiguration.properties");
    }

    protected InputStream createInputStream(String location) throws IOException {
        InputStreamLocator locator = new InputStreamLocator(this.getApplicationRootDir(), this.getLogger());
        return locator.locate(location);
    }

    protected void addAvalonContext(Properties properties) throws ContextException {
        properties.put("urn:avalon:name", this.getContext().get((Object)"urn:avalon:name"));
        properties.put("urn:avalon:partition", this.getContext().get((Object)"urn:avalon:partition"));
        properties.put("urn:avalon:home", this.getContext().get((Object)"urn:avalon:home"));
        properties.put("urn:avalon:temp", this.getContext().get((Object)"urn:avalon:temp"));
    }

    protected Properties loadProperties(String fileLocation) throws Exception {
        Properties result = new Properties();
        InputStream is = this.createInputStream(fileLocation);
        try {
            if (is != null) {
                result.load(is);
                is.close();
                is = null;
            } else {
                this.getLogger().debug("Unable to load the following optional file :" + fileLocation);
            }
            return result;
        }
        catch (Exception e) {
            String msg = "Unable to parse the following file : " + fileLocation;
            this.getLogger().error(msg, (Throwable)e);
            throw e;
        }
    }
}

