/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.Valve;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DetermineRedirectRequestedValve
implements Valve {
    private static final Logger log = LogManager.getLogger(DetermineRedirectRequestedValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        this.redirectRequested(pipelineData);
        context.invokeNext(pipelineData);
    }

    protected void redirectRequested(PipelineData pipelineData) throws IOException {
        RunData data = pipelineData.getRunData();
        boolean requestRedirected = StringUtils.isNotEmpty((CharSequence)data.getRedirectURI());
        if (requestRedirected) {
            if (data.getResponse().isCommitted()) {
                log.warn("redirect requested, response already committed: {}", (Object)data.getRedirectURI());
            } else {
                data.getResponse().sendRedirect(data.getRedirectURI());
            }
        }
    }
}

