/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.layouts;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.fulcrum.xslt.XSLTService;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.modules.layouts.VelocityOnlyLayout;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityXslLayout
extends VelocityOnlyLayout {
    @TurbineService
    private XSLTService xsltService;
    @TurbineLoader(value=Screen.class)
    private ScreenLoader screenLoader;

    @Override
    public void doBuild(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        Context context = this.velocityService.getContext(pipelineData);
        data.getResponse().setContentType("text/html");
        this.populateContext(pipelineData, context);
        String templateName = data.getTemplateInfo().getLayoutTemplate();
        this.log.debug("Now trying to render layout {}", (Object)templateName);
        String temp = this.velocityService.handleRequest(context, "layouts/" + templateName);
        this.xsltService.transform(data.getTemplateInfo().getScreenTemplate(), (Reader)new StringReader(temp), (Writer)data.getResponse().getWriter());
    }
}

