/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;

public class ComboKey
extends ObjectKey<SimpleKey<?>[]> {
    private static final long serialVersionUID = -264927663211141894L;
    public static final char SEPARATOR = ':';
    public static final String SEPARATOR_STRING = ":";

    public ComboKey() {
    }

    public ComboKey(String key) {
        this.setValue(key);
    }

    public ComboKey(SimpleKey<?>[] key) {
        this.setValue(key);
    }

    public ComboKey(ComboKey key) {
        this.setValue(key);
    }

    @Override
    public void setValue(String keys) {
        int startPtr = 0;
        int indexOfSep = keys.indexOf(58);
        ArrayList<NumberKey> tmpKeys = new ArrayList<NumberKey>();
        while (indexOfSep != -1) {
            if (indexOfSep == startPtr) {
                tmpKeys.add(null);
            } else {
                char keyType = keys.charAt(startPtr);
                String keyString = keys.substring(startPtr + 1, indexOfSep);
                SimpleKey newKey = null;
                switch (keyType) {
                    case 'N': {
                        newKey = new NumberKey(keyString);
                        break;
                    }
                    case 'S': {
                        newKey = new StringKey(keyString);
                        break;
                    }
                    case 'D': {
                        try {
                            newKey = new DateKey(keyString);
                        }
                        catch (NumberFormatException nfe) {
                            newKey = new DateKey();
                        }
                        break;
                    }
                }
                tmpKeys.add((NumberKey)newKey);
            }
            startPtr = indexOfSep + 1;
            indexOfSep = keys.indexOf(58, startPtr);
        }
        SimpleKey[] key = new SimpleKey[tmpKeys.size()];
        for (int i = 0; i < key.length; ++i) {
            key[i] = (SimpleKey)tmpKeys.get(i);
        }
        this.setValue(key);
    }

    @Override
    public int getJdbcType() {
        return 2003;
    }

    @Override
    public boolean equals(Object keyObj) {
        boolean isEqual = false;
        SimpleKey[] key = (SimpleKey[])this.getValue();
        if (key != null) {
            isEqual = true;
            for (int i = 0; i < key.length && isEqual; isEqual &= key[i] != null && key[i].getValue() != null, ++i) {
            }
            isEqual &= this.looseEquals(keyObj);
        }
        return isEqual;
    }

    public boolean looseEquals(Object keyObj) {
        boolean isEqual;
        block2: {
            SimpleKey[] key;
            block4: {
                block3: {
                    isEqual = false;
                    key = (SimpleKey[])this.getValue();
                    if (key == null) break block2;
                    if (!(keyObj instanceof String)) break block3;
                    isEqual = this.toString().equals(keyObj);
                    break block2;
                }
                if (!(keyObj instanceof ComboKey)) break block4;
                SimpleKey[] obj = (SimpleKey[])((ComboKey)keyObj).getValue();
                SimpleKey[] keys2 = obj;
                isEqual = key.length == keys2.length;
                for (int i = 0; i < key.length && isEqual; isEqual &= Objects.equals(key[i], keys2[i]), ++i) {
                }
                break block2;
            }
            if (!(keyObj instanceof SimpleKey[])) break block2;
            SimpleKey[] keys2 = (SimpleKey[])keyObj;
            isEqual = key.length == keys2.length;
            for (int i = 0; i < key.length && isEqual; isEqual &= Objects.equals(key[i], keys2[i]), ++i) {
            }
        }
        return isEqual;
    }

    @Override
    public void appendTo(StringBuilder sb) {
        SimpleKey[] key = (SimpleKey[])this.getValue();
        if (key != null) {
            for (int i = 0; i < key.length; ++i) {
                if (key[i] != null) {
                    if (key[i] instanceof StringKey) {
                        sb.append("S");
                    } else if (key[i] instanceof NumberKey) {
                        sb.append("N");
                    } else if (key[i] instanceof DateKey) {
                        sb.append("D");
                    } else {
                        sb.append("U");
                    }
                    key[i].appendTo(sb);
                }
                sb.append(':');
            }
        }
    }

    @Override
    public int hashCode() {
        SimpleKey[] key = (SimpleKey[])this.getValue();
        if (key == null) {
            return super.hashCode();
        }
        SimpleKey sk = key[0];
        if (sk == null) {
            return super.hashCode();
        }
        return sk.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        this.appendTo(sbuf);
        return sbuf.toString();
    }
}

