/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.parse;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;

public final class EvilManualUseragentStringHacks {
    private static final Pattern MISSING_PRODUCT_AT_START = Pattern.compile("^\\(( |;|null|compatible|windows|android|linux).*", 2);
    private static final Pattern MISSING_SPACE = Pattern.compile("(/[0-9]+\\.[0-9]+)([A-Z][a-z][a-z][a-z]+ )");
    private static final Pattern MULTIPLE_SPACES = Pattern.compile("(?: {2,})");

    private EvilManualUseragentStringHacks() {
    }

    public static String fixIt(String useragent) {
        if (useragent == null || useragent.isEmpty()) {
            return useragent;
        }
        String result = useragent;
        if ((result = MULTIPLE_SPACES.matcher(result).replaceAll(" ")).charAt(0) == ' ') {
            result = result.trim();
        }
        result = EvilManualUseragentStringHacks.replaceString(result, "SSL/TLS", "SSL TLS");
        result = MISSING_SPACE.matcher(result).replaceAll("$1 $2");
        result = EvilManualUseragentStringHacks.replaceString(result, " (Macintosh); ", " (Macintosh; ");
        result = EvilManualUseragentStringHacks.replaceString(result, "Microsoft Windows NT 6.2.9200.0);", "Microsoft Windows NT 6.2.9200.0;");
        result = EvilManualUseragentStringHacks.replaceString(result, "You Build/VM", "You Build/VM)");
        result = EvilManualUseragentStringHacks.replaceString(result, "(/", "(Unknown/");
        if (MISSING_PRODUCT_AT_START.matcher(result = EvilManualUseragentStringHacks.replaceString(result, "; /", "; Unknown/")).matches()) {
            result = "Mozilla/5.0 " + result;
        } else if (result.charAt(0) == '/') {
            result = "Mozilla" + result;
        }
        result = EvilManualUseragentStringHacks.replaceString(result, ",gzip(gfe)", "");
        result = EvilManualUseragentStringHacks.replaceString(result, "__", " ");
        if (result.contains("%20")) {
            try {
                result = URLDecoder.decode(result, "UTF-8");
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String replaceString(String input, String searchFor, String replaceWith) {
        int startIdx = 0;
        int idxSearchFor = input.indexOf(searchFor, startIdx);
        if (idxSearchFor < 0) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length() + 32);
        while (idxSearchFor >= 0) {
            result.append(input, startIdx, idxSearchFor);
            result.append(replaceWith);
            startIdx = idxSearchFor + searchFor.length();
            idxSearchFor = input.indexOf(searchFor, startIdx);
        }
        result.append(input.substring(startIdx));
        return result.toString();
    }
}

