/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.block;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCache;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.jcs.engine.behavior.ICache;

public class BlockDiskCacheManager
implements AuxiliaryCacheManager {
    private static final long serialVersionUID = -4153287154512274626L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager = BlockDiskCacheManager.class$("org.apache.jcs.auxiliary.disk.block.BlockDiskCacheManager")) : class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager));
    private static int clients;
    private static BlockDiskCacheManager instance;
    private Hashtable caches = new Hashtable();
    private BlockDiskCacheAttributes defaultCacheAttributes;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager;

    private BlockDiskCacheManager(BlockDiskCacheAttributes defaultCacheAttributes) {
        this.defaultCacheAttributes = defaultCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockDiskCacheManager getInstance(BlockDiskCacheAttributes defaultCacheAttributes) {
        Class clazz = class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager = BlockDiskCacheManager.class$("org.apache.jcs.auxiliary.disk.block.BlockDiskCacheManager")) : class$org$apache$jcs$auxiliary$disk$block$BlockDiskCacheManager;
        synchronized (clazz) {
            if (instance == null) {
                instance = new BlockDiskCacheManager(defaultCacheAttributes);
            }
        }
        ++clients;
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        BlockDiskCacheAttributes cacheAttributes = (BlockDiskCacheAttributes)this.defaultCacheAttributes.copy();
        cacheAttributes.setCacheName(cacheName);
        return this.getCache(cacheAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(BlockDiskCacheAttributes cacheAttributes) {
        AuxiliaryCache cache = null;
        String cacheName = cacheAttributes.getCacheName();
        log.debug((Object)("Getting cache named: " + cacheName));
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            cache = (AuxiliaryCache)this.caches.get(cacheName);
            if (cache == null) {
                cache = new BlockDiskCache(cacheAttributes);
                this.caches.put(cacheName, cache);
            }
        }
        return cache;
    }

    public void freeCache(String cacheName) {
        ICache cache = (ICache)this.caches.get(cacheName);
        if (cache != null) {
            try {
                cache.dispose();
            }
            catch (Exception e) {
                log.error((Object)("Failure disposing cache: " + cacheName), (Throwable)e);
            }
        }
    }

    public int getCacheType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        --clients;
        if (--clients != 0) {
            return;
        }
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            Enumeration allCaches = this.caches.elements();
            while (allCaches.hasMoreElements()) {
                ICache cache = (ICache)allCaches.nextElement();
                if (cache == null) continue;
                try {
                    cache.dispose();
                }
                catch (Exception e) {
                    log.error((Object)("Failure disposing cache: " + cache.getCacheName()), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

