/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.template.mapper;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.template.TemplateEngineService;
import org.apache.turbine.services.template.TurbineTemplate;

public abstract class BaseMapper {
    private boolean useCache = false;
    private int cacheSize = 5;
    private Map templateCache = null;
    protected String defaultProperty;
    protected char separator;

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public String getDefaultProperty() {
        return this.defaultProperty;
    }

    public void setDefaultProperty(String defaultProperty) {
        this.defaultProperty = defaultProperty;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void init() {
        if (this.useCache) {
            this.templateCache = new HashMap(this.cacheSize);
        }
    }

    public String getDefaultName(String template) {
        TemplateEngineService tes = TurbineTemplate.getTemplateEngineService(template);
        if (StringUtils.isEmpty((String)template) || tes == null) {
            return TurbineTemplate.getDefaultTemplate();
        }
        String defaultName = (String)tes.getTemplateEngineServiceConfiguration().get(this.defaultProperty);
        return StringUtils.isEmpty((String)defaultName) ? TurbineTemplate.getDefaultTemplate() : defaultName;
    }

    public String getMappedName(String template) {
        if (StringUtils.isEmpty((String)template)) {
            return null;
        }
        if (this.useCache && this.templateCache.containsKey(template)) {
            return (String)this.templateCache.get(template);
        }
        String res = this.doMapping(template);
        if (this.useCache && StringUtils.isNotEmpty((String)res)) {
            this.templateCache.put(template, res);
        }
        return res;
    }

    public abstract String doMapping(String var1);
}

