/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.generator.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.metadata.Endpoint;

public abstract class AbstractEndpointConverter<T extends Endpoint>
implements BiFunction<String, List<String>, T> {
    @Nonnull
    private static Map<String, Pair<String, String>> bindingMap = new HashMap<String, Pair<String, String>>();
    @Nonnull
    private final SAMLObjectBuilder<T> builder;

    public AbstractEndpointConverter(@Nonnull SAMLObjectBuilder<T> theBuilder) {
        this.builder = (SAMLObjectBuilder)Constraint.isNotNull(theBuilder, (String)"Builder cannot be null");
    }

    @Nonnull
    protected T getProcessedEndpoint(@Nullable @Live List<String> protocols, @Nullable String input) {
        if (input == null) {
            throw new IllegalArgumentException("Argument was null");
        }
        Pair<String, String> pair = this.getProtocolAndBinding(input);
        String loc = this.getLocation(input);
        Endpoint endpoint = (Endpoint)this.builder.buildObject();
        if (loc.startsWith("https://") || loc.startsWith("http://")) {
            endpoint.setLocation(loc);
        } else {
            endpoint.setLocation("https://" + loc);
        }
        endpoint.setBinding((String)pair.getSecond());
        if (protocols != null) {
            protocols.add((String)pair.getFirst());
        }
        return (T)endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Pair<String, String> getProtocolAndBinding(@Nonnull String input) {
        Pair<String, String> binding;
        int sep = input.indexOf(47);
        if (sep == -1) {
            throw new IllegalArgumentException("No separator found in string.");
        }
        Map<String, Pair<String, String>> map = bindingMap;
        synchronized (map) {
            binding = bindingMap.get(input.substring(0, sep));
        }
        if (binding == null) {
            throw new IllegalArgumentException("Binding " + input.substring(0, sep) + " did not match a known value.");
        }
        return binding;
    }

    @Nonnull
    protected String getLocation(@Nonnull String input) {
        int sep = input.indexOf(47);
        if (sep == -1 || input.length() == sep + 1) {
            throw new IllegalArgumentException("No separator found in string.");
        }
        return input.substring(sep + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBinding(@Nonnull String token, @Nonnull String protocol, @Nonnull String binding) {
        Map<String, Pair<String, String>> map = bindingMap;
        synchronized (map) {
            bindingMap.put(token, (Pair<String, String>)new Pair((Object)protocol, (Object)binding));
        }
    }

    static {
        bindingMap.put("Redirect", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:2.0:protocol", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"));
        bindingMap.put("POST", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:2.0:protocol", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"));
        bindingMap.put("SimpleSign", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:2.0:protocol", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST-SimpleSign"));
        bindingMap.put("Artifact", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:2.0:protocol", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact"));
        bindingMap.put("SOAP", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:2.0:protocol", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:SOAP"));
        bindingMap.put("PAOS", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:2.0:protocol", (Object)"urn:oasis:names:tc:SAML:2.0:bindings:PAOS"));
        bindingMap.put("POST1", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:1.1:protocol", (Object)"urn:oasis:names:tc:SAML:1.0:profiles:browser-post"));
        bindingMap.put("Artifact1", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:1.1:protocol", (Object)"urn:oasis:names:tc:SAML:1.0:profiles:artifact-01"));
        bindingMap.put("SOAP1", (Pair<String, String>)new Pair((Object)"urn:oasis:names:tc:SAML:1.1:protocol", (Object)"urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding"));
    }
}

