/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.security.SecurityRequirementIO;
import io.smallrye.openapi.runtime.io.security.SecurityRequirementsSetIO;
import io.smallrye.openapi.runtime.io.security.SecuritySchemeIO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class SecurityIO<V, A extends V, O extends V, AB, OB> {
    private final SecurityRequirementIO<V, A, O, AB, OB> securityRequirementIO;
    private final SecurityRequirementsSetIO<V, A, O, AB, OB> securityRequirementsSetIO;
    private final SecuritySchemeIO<V, A, O, AB, OB> securitySchemeIO;

    public SecurityIO(IOContext<V, A, O, AB, OB> context, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        this.securityRequirementIO = new SecurityRequirementIO<V, A, O, AB, OB>(context);
        this.securityRequirementsSetIO = new SecurityRequirementsSetIO<V, A, O, AB, OB>(context);
        this.securitySchemeIO = new SecuritySchemeIO<V, A, O, AB, OB>(context, extensionIO);
    }

    public List<SecurityRequirement> readRequirements(AnnotationTarget target) {
        return Stream.of(this.securityRequirementIO.readList(target), this.securityRequirementsSetIO.readList(target)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<SecurityRequirement> readRequirements(AnnotationValue annotations, AnnotationValue setAnnotations) {
        List requirements = Stream.of(this.securityRequirementIO.readList(annotations), this.securityRequirementsSetIO.readList(setAnnotations)).filter(Objects::nonNull).collect(Collectors.toList());
        if (requirements.isEmpty()) {
            return null;
        }
        return requirements.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, SecurityScheme> readSchemes(AnnotationTarget target) {
        return this.securitySchemeIO.readMap(target);
    }

    public List<SecurityRequirement> readRequirements(V node) {
        return this.securityRequirementIO.readList(node);
    }

    public Optional<A> write(List<SecurityRequirement> models) {
        return this.securityRequirementIO.write(models);
    }
}

