/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport.deploy.method;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public final class ResponseCodeEnforcingResponseHandler
implements HttpClientResponseHandler<Integer> {
    private final List<Integer> allowedCodes;
    private final String expectedContentType;
    private final Predicate<String> responseStringPredicate;

    public ResponseCodeEnforcingResponseHandler(Integer ... allowedCodes) {
        this((String)null, allowedCodes);
    }

    public ResponseCodeEnforcingResponseHandler(String expectedContentType, Integer ... allowedCodes) {
        this(expectedContentType, (Predicate<String>)null, allowedCodes);
    }

    public ResponseCodeEnforcingResponseHandler(String expectedContentType, Predicate<String> responseStringPredicate, Integer ... allowedCodes) {
        this.expectedContentType = expectedContentType;
        this.responseStringPredicate = responseStringPredicate;
        this.allowedCodes = Arrays.asList(allowedCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        try {
            String responseContent;
            if (this.responseStringPredicate != null && !this.responseStringPredicate.test(responseContent = EntityUtils.toString((HttpEntity)entity))) {
                throw new ClientProtocolException("Unexpected response content returned: " + responseContent);
            }
            if (!this.allowedCodes.contains(response.getCode())) {
                throw new HttpResponseException(response.getCode(), "Unexpected response code " + response.getCode() + ": " + response.getReasonPhrase());
            }
            String actualContentType = Optional.ofNullable(response.getHeader("Content-Type")).map(NameValuePair::getValue).orElse(null);
            if (this.expectedContentType != null && this.expectedContentType.equals(actualContentType)) {
                throw new ClientProtocolException("Unexpected content type returned, expected " + this.expectedContentType + " but was " + actualContentType);
            }
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
        return response.getCode();
    }
}

