/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.tooling.support.source.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.sling.tooling.support.source.impl.FelixJettySourceReferenceFinder;
import org.apache.sling.tooling.support.source.impl.SourceReference;
import org.apache.sling.tooling.support.source.impl.SourceReferenceException;
import org.apache.sling.tooling.support.source.impl.SourceReferenceFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class})
@HttpWhiteboardServletPattern(value={"/system/sling/tooling/sourceReferences.json"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=org.osgi.service.http)")
public class SourceReferencesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(SourceReferencesServlet.class);
    private static final String KEY_TYPE = "__type__";
    private static final String KEY_GROUP_ID = "groupId";
    private static final String KEY_ARTIFACT_ID = "artifactId";
    private static final String KEY_VERSION = "version";
    static final String VALUE_TYPE_MAVEN = "maven";
    private static final String FELIX_FW_GROUP_ID = "org.apache.felix";
    private static final String FELIX_FW_ARTIFACT_ID = "org.apache.felix.framework";
    private final BundleContext ctx;
    private final List<SourceReferenceFinder> finders;

    @Activate
    public SourceReferencesServlet(BundleContext ctx) {
        this.ctx = ctx;
        this.finders = new ArrayList<SourceReferenceFinder>();
        this.finders.add(new FelixJettySourceReferenceFinder());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("application/json");
            this.writeBundleSourceJson(response.getWriter(), this.ctx.getBundles());
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    void writeBundleSourceJson(Writer writer, Bundle ... bundles) throws IOException {
        JSONWriter w = new JSONWriter(writer);
        w.array();
        for (Bundle bundle : bundles) {
            if ((((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0) {
                log.debug("Skip bundle '{}' because it is a fragment", (Object)bundle);
                continue;
            }
            String bundleVersion = bundle.getVersion().toString();
            w.object();
            w.key("Bundle-SymbolicName");
            w.value(bundle.getSymbolicName());
            w.key("Bundle-Version");
            w.value(bundleVersion);
            w.key("sourceReferences");
            w.array();
            if (bundle.getBundleId() == 0L && FELIX_FW_ARTIFACT_ID.equals(bundle.getSymbolicName())) {
                SourceReferencesServlet.writeMavenGav(w, FELIX_FW_GROUP_ID, FELIX_FW_ARTIFACT_ID, bundleVersion);
            }
            SourceReferencesServlet.collectMavenSourceReferences(w, bundle);
            for (String jar : SourceReferencesServlet.getEmbeddedJars(bundle)) {
                URL entry = bundle.getEntry(jar);
                if (entry == null) continue;
                SourceReferencesServlet.collectMavenSourceReferences(w, entry);
            }
            for (SourceReferenceFinder finder : this.finders) {
                try {
                    for (SourceReference reference : finder.findSourceReferences(bundle)) {
                        log.debug("{} found reference {}:{}:{} in {}", new Object[]{finder, reference.getGroupId(), reference.getArtifactId(), reference.getVersion(), bundle});
                        SourceReferencesServlet.writeMavenGav(w, reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
                    }
                }
                catch (SourceReferenceException e) {
                    log.warn(finder + " execution did not complete normally for " + bundle, (Throwable)e);
                }
            }
            w.endArray();
            w.endObject();
        }
        w.endArray();
    }

    private static void collectMavenSourceReferences(JSONWriter w, Bundle bundle) throws IOException {
        Enumeration entries = bundle.findEntries("/META-INF/maven", "pom.properties", true);
        while (entries != null && entries.hasMoreElements()) {
            URL entry = (URL)entries.nextElement();
            InputStream in = entry.openStream();
            try {
                SourceReferencesServlet.writeMavenGav(w, in);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    private static void writeMavenGav(JSONWriter w, String groupId, String artifactId, String version) throws IOException {
        w.object();
        w.key(KEY_TYPE).value(VALUE_TYPE_MAVEN);
        w.key(KEY_GROUP_ID).value(groupId);
        w.key(KEY_ARTIFACT_ID).value(artifactId);
        w.key(KEY_VERSION).value(version);
        w.endObject();
    }

    private static void writeMavenGav(JSONWriter w, InputStream in) throws IOException {
        Properties p = new Properties();
        p.load(in);
        w.object();
        w.key(KEY_TYPE).value(VALUE_TYPE_MAVEN);
        for (String prop : new String[]{KEY_GROUP_ID, KEY_ARTIFACT_ID, KEY_VERSION}) {
            w.key(prop).value(p.getProperty(prop));
        }
        w.endObject();
    }

    private static List<String> getEmbeddedJars(Bundle bundle) {
        String[] classPathEntryNames;
        String classPath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (classPath == null) {
            return Collections.emptyList();
        }
        ArrayList<String> embeddedJars = new ArrayList<String>();
        for (String classPathEntry : classPathEntryNames = classPath.split("\\,")) {
            if (!classPathEntry.endsWith(".jar")) continue;
            embeddedJars.add(classPathEntry);
        }
        return embeddedJars;
    }

    private static void collectMavenSourceReferences(JSONWriter w, URL entry) throws IOException {
        try (InputStream wrappedIn = entry.openStream();
             JarInputStream jarIs = new JarInputStream(wrappedIn);){
            JarEntry jarEntry;
            while ((jarEntry = jarIs.getNextJarEntry()) != null) {
                String entryName = jarEntry.getName();
                if (!entryName.startsWith("META-INF/maven/") || !entryName.endsWith("/pom.properties")) continue;
                SourceReferencesServlet.writeMavenGav(w, jarIs);
            }
        }
    }
}

