/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.resourceresolver;

import java.util.Iterator;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.testing.resourceresolver.MockResourceResolver;
import org.jetbrains.annotations.NotNull;

class MockQueryLanguageProvider
implements QueryLanguageProvider<Void> {
    private final MockResourceResolver mockResourceResolver;
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"xpath", "sql", "JCR-SQL2", "JCR-JQOM"};

    MockQueryLanguageProvider(MockResourceResolver mockResourceResolver) {
        this.mockResourceResolver = mockResourceResolver;
    }

    public String[] getSupportedLanguages(@NotNull ResolveContext<Void> ctx) {
        return SUPPORTED_LANGUAGES;
    }

    public Iterator<Resource> findResources(@NotNull ResolveContext<Void> ctx, String query, String language) {
        return MockQueryLanguageProvider.unlockResourceMetadata(this.mockResourceResolver.findResources(query, language));
    }

    public Iterator<ValueMap> queryResources(@NotNull ResolveContext<Void> ctx, String query, String language) {
        Iterator<Map<String, Object>> result = this.mockResourceResolver.queryResources(query, language);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(result, 16), false).map(MockQueryLanguageProvider::toValueMap).iterator();
    }

    private static ValueMap toValueMap(Map<String, Object> item) {
        if (item instanceof ValueMap) {
            return (ValueMap)item;
        }
        return new ValueMapDecorator(item);
    }

    private static Iterator<Resource> unlockResourceMetadata(Iterator<Resource> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(MockQueryLanguageProvider::unlockResourceMetadata).iterator();
    }

    private static Resource unlockResourceMetadata(Resource resource) {
        final ResourceMetadata rm = new ResourceMetadata();
        rm.putAll((Map)resource.getResourceMetadata());
        return new ResourceWrapper(resource){

            public ResourceMetadata getResourceMetadata() {
                return rm;
            }
        };
    }
}

