/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.config;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.sling.testing.mock.osgi.config.AbstractConfigTypeReflectionProvider;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigType;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.jetbrains.annotations.NotNull;

public final class AnnotationTypedConfig<T>
implements TypedConfig<T> {
    private final Class<T> type;
    private final T config;

    private AnnotationTypedConfig(@NotNull Class<T> type, @NotNull T config) {
        this.type = type;
        this.config = config;
    }

    @Override
    @NotNull
    public Class<T> getType() {
        return this.type;
    }

    @Override
    @NotNull
    public T getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public Map<String, Object> getConfigMap() {
        return AbstractConfigTypeReflectionProvider.getInstance(this.getType()).getPropertyMap(this.getConfig());
    }

    public static <T> AnnotationTypedConfig<T> newInstance(@NotNull Class<T> type, @NotNull Object config, @NotNull Annotation annotation) {
        if (!type.isInstance(config)) {
            throw new IllegalArgumentException("config " + config + " must be instance of type " + type + " from annotation " + annotation);
        }
        if (annotation instanceof ConfigType) {
            if (!((ConfigType)annotation).type().isAssignableFrom(type)) {
                throw new IllegalArgumentException("type " + type + " must match config type from annotation " + annotation);
            }
        } else if (!annotation.annotationType().isAssignableFrom(type)) {
            throw new IllegalArgumentException("type " + type + " must match annotation type " + annotation);
        }
        return new AnnotationTypedConfig<T>(type, type.cast(config));
    }
}

