/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.NodeVisitor;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.ArrayLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BooleanConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.Identifier;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NullLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.NumericConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.PropertyAccess;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.TernaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.UnaryOperation;
import org.apache.sling.scripting.sightly.java.compiler.JavaImportsAnalyzer;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.TypeInfo;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableAnalyzer;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.BinaryOpGen;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.Operators;
import org.apache.sling.scripting.sightly.java.compiler.impl.operator.UnaryOpGen;

public final class TypeInference
implements NodeVisitor<Type> {
    private final VariableAnalyzer analyzer;
    private final Map<ExpressionNode, Type> inferMap = new IdentityHashMap<ExpressionNode, Type>();
    private final Set<String> imports;
    private final JavaImportsAnalyzer importsAnalyzer;
    private static final Pattern FQCN_PATTERN = Pattern.compile("([[\\p{L}&&[^\\p{Lu}]]_$][\\p{L}\\p{N}_$]*\\.)+[\\p{Lu}_$][\\p{L}\\p{N}_$]*");

    public static TypeInfo inferTypes(ExpressionNode node, VariableAnalyzer analyzer, Set<String> imports, JavaImportsAnalyzer importsAnalyzer) {
        TypeInference typeInference = new TypeInference(analyzer, imports, importsAnalyzer);
        typeInference.infer(node);
        return new TypeInfo(typeInference.inferMap);
    }

    private TypeInference(VariableAnalyzer analyzer, Set<String> imports, JavaImportsAnalyzer importsAnalyzer) {
        this.analyzer = analyzer;
        this.imports = imports;
        this.importsAnalyzer = importsAnalyzer;
    }

    private Type infer(ExpressionNode node) {
        Type type = (Type)node.accept((NodeVisitor)this);
        this.inferMap.put(node, type);
        return type;
    }

    public Type evaluate(PropertyAccess propertyAccess) {
        this.infer(propertyAccess.getTarget());
        this.infer(propertyAccess.getProperty());
        return Type.UNKNOWN;
    }

    public Type evaluate(Identifier identifier) {
        return this.analyzer.descriptor(identifier.getName()).getType();
    }

    public Type evaluate(StringConstant text) {
        return Type.STRING;
    }

    public Type evaluate(BinaryOperation binaryOperation) {
        Type leftType = this.infer(binaryOperation.getLeftOperand());
        Type rightType = this.infer(binaryOperation.getRightOperand());
        BinaryOpGen opGen = Operators.generatorFor(binaryOperation.getOperator());
        return opGen.returnType(leftType, rightType);
    }

    public Type evaluate(BooleanConstant booleanConstant) {
        return Type.BOOLEAN;
    }

    public Type evaluate(NumericConstant numericConstant) {
        Number number = numericConstant.getValue();
        if (number instanceof Integer || number instanceof Long) {
            return Type.LONG;
        }
        if (number instanceof Float || number instanceof Double) {
            return Type.DOUBLE;
        }
        return Type.UNKNOWN;
    }

    public Type evaluate(UnaryOperation unaryOperation) {
        this.infer(unaryOperation.getTarget());
        UnaryOpGen opGen = Operators.generatorFor(unaryOperation.getOperator());
        return opGen.returnType(this.infer(unaryOperation.getTarget()));
    }

    public Type evaluate(TernaryOperator ternaryOperator) {
        this.infer(ternaryOperator.getCondition());
        Type thenType = this.infer(ternaryOperator.getThenBranch());
        Type elseType = this.infer(ternaryOperator.getElseBranch());
        if (thenType.equals(elseType)) {
            return thenType;
        }
        return Type.UNKNOWN;
    }

    public Type evaluate(RuntimeCall runtimeCall) {
        String objectType;
        ExpressionNode identifier;
        this.inferAll(runtimeCall.getArguments());
        if (runtimeCall.getFunctionName().equals("use") && (identifier = (ExpressionNode)runtimeCall.getArguments().get(0)) instanceof StringConstant && FQCN_PATTERN.matcher(objectType = ((StringConstant)identifier).getText()).matches() && this.importsAnalyzer != null && this.importsAnalyzer.allowImport(objectType)) {
            this.imports.add(objectType);
            return Type.dynamic(objectType);
        }
        return Type.UNKNOWN;
    }

    public Type evaluate(MapLiteral mapLiteral) {
        this.inferAll(mapLiteral.getMap().values());
        return Type.MAP;
    }

    public Type evaluate(ArrayLiteral arrayLiteral) {
        this.inferAll(arrayLiteral.getItems());
        return Type.UNKNOWN;
    }

    public Type evaluate(NullLiteral nullLiteral) {
        return Type.UNKNOWN;
    }

    private void inferAll(Iterable<ExpressionNode> nodes) {
        for (ExpressionNode node : nodes) {
            this.infer(node);
        }
    }
}

