/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.optimization;

import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandHandler;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.optimization.StreamTransformer;

public final class CoalescingWrites
implements CommandHandler {
    public static final StreamTransformer TRANSFORMER = new StreamTransformer(){

        @Override
        public CommandStream transform(CommandStream inStream) {
            PushStream outputStream = new PushStream();
            CoalescingWrites instance = new CoalescingWrites(outputStream);
            inStream.addHandler(instance);
            return outputStream;
        }
    };
    private StringBuilder builder = new StringBuilder();
    private final PushStream outStream;

    private CoalescingWrites(PushStream stream) {
        this.outStream = stream;
    }

    @Override
    public void onEmit(Command command) {
        String text = this.detectText(command);
        if (text != null) {
            this.builder.append(text);
        } else {
            this.flushText();
            this.outStream.write(command);
        }
    }

    @Override
    public void onError(String errorMessage) {
        this.flushText();
        this.outStream.signalError(errorMessage);
    }

    @Override
    public void onDone() {
        this.flushText();
        this.outStream.close();
    }

    private String detectText(Command command) {
        if (command instanceof OutText) {
            return ((OutText)command).getText();
        }
        return null;
    }

    private void flushText() {
        if (this.builder.length() > 0) {
            this.outStream.write(new OutText(this.builder.toString()));
            this.builder = new StringBuilder();
        }
    }
}

