/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.debug;

import java.util.Stack;
import org.apache.sling.scripting.sightly.compiler.SightlyCompilerException;
import org.apache.sling.scripting.sightly.compiler.commands.AbstractCommandVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.Command;
import org.apache.sling.scripting.sightly.compiler.commands.CommandHandler;
import org.apache.sling.scripting.sightly.compiler.commands.CommandStream;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;

public final class SanityChecker
extends AbstractCommandVisitor
implements CommandHandler {
    private final Stack<NestedType> stack = new Stack();
    private boolean inProcedure;

    private SanityChecker() {
    }

    public static void attachChecker(CommandStream commandStream) {
        commandStream.addHandler(new SanityChecker());
    }

    @Override
    public void onEmit(Command command) {
        command.accept(this);
    }

    @Override
    public void onError(String errorMessage) {
        throw new SightlyCompilerException(errorMessage);
    }

    @Override
    public void onDone() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Unclosed commands left");
        }
    }

    @Override
    public void visit(Conditional.Start conditionalStart) {
        this.stack.push(NestedType.CONDITIONAL);
    }

    @Override
    public void visit(Conditional.End conditionalEnd) {
        this.popCheck(NestedType.CONDITIONAL);
    }

    @Override
    public void visit(VariableBinding.Start variableBindingStart) {
        this.stack.push(NestedType.VARIABLE_BIND);
    }

    @Override
    public void visit(VariableBinding.End variableBindingEnd) {
        this.popCheck(NestedType.VARIABLE_BIND);
    }

    @Override
    public void visit(Loop.Start loopStart) {
        this.stack.push(NestedType.LOOP);
    }

    @Override
    public void visit(Loop.End loopEnd) {
        this.popCheck(NestedType.LOOP);
    }

    @Override
    public void visit(Procedure.Start startProcedure) {
        if (this.inProcedure) {
            throw new IllegalStateException("Cannot have nested procedures: " + startProcedure.getName());
        }
        this.inProcedure = true;
    }

    @Override
    public void visit(Procedure.End endProcedure) {
        if (!this.inProcedure) {
            throw new IllegalStateException("Procedure closing is unmatched");
        }
        this.inProcedure = false;
    }

    private void popCheck(NestedType nestedType) {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Unbalanced command: " + (Object)((Object)nestedType));
        }
        NestedType top = this.stack.pop();
        if (top != nestedType) {
            throw new IllegalStateException("Command closing is unmatched. Expected " + (Object)((Object)top) + ", actual: " + (Object)((Object)nestedType));
        }
    }

    private static enum NestedType {
        CONDITIONAL,
        VARIABLE_BIND,
        LOOP;

    }
}

