/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.rewriter.ProcessorManager;
import org.apache.sling.rewriter.impl.RewriterResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Filter.class}, property={"service.vendor=The Apache Software Foundation", "sling.filter.scope=request", "sling.filter.scope=error", "service.ranking:Integer=2500"})
public class RewriterFilter
implements Filter {
    @Reference
    private ProcessorManager pipelineManager;

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof SlingHttpServletRequest)) {
            throw new ServletException("Request is not a Apache Sling HTTP request.");
        }
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        RewriterResponse rewriterResponse = new RewriterResponse(slingRequest, slingResponse, this.pipelineManager);
        boolean errorOccured = true;
        try {
            chain.doFilter(request, (ServletResponse)rewriterResponse);
            errorOccured = false;
        }
        finally {
            rewriterResponse.finished(errorOccured);
        }
    }
}

