/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interpolator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Interpolator.class);
    public static final char END = ']';
    public static final String START = "$[";
    public static final char NAME_SEPARATOR = ':';
    public static final char DIRECTIVES_SEPARATOR = ';';
    public static final char DIRECTIVES_VALUE_SEPARATOR = '=';
    public static final char ESCAPE = '\\';

    public static Object replace(String value, Provider provider) {
        String result = value;
        int start = -1;
        while (start < result.length()) {
            Map<String, String> directives;
            String name;
            int index;
            if ((start = result.indexOf(START, start)) == -1) {
                LOGGER.trace("No Start ({}) found in: '{}'", (Object)START, (Object)result);
                start = result.length();
                continue;
            }
            boolean replace = true;
            if (start > 0 && result.charAt(start - 1) == '\\' && (start == 1 || result.charAt(start - 2) != '\\')) {
                LOGGER.trace("Escape ({}) found in: '{}'", (Object)Character.valueOf('\\'), (Object)result);
                replace = false;
            }
            if (!replace) {
                result = result.substring(0, start - 1).concat(result.substring(start));
                start += START.length();
                continue;
            }
            int count = 1;
            for (index = start + START.length(); index < result.length() && count > 0; ++index) {
                if (result.charAt(index) == START.charAt(1) && result.charAt(index - 1) == START.charAt(0)) {
                    ++count;
                    continue;
                }
                if (result.charAt(index) != ']') continue;
                --count;
            }
            if (count > 0) {
                LOGGER.trace("No End ({}) found in: '{}' (count: '{}')", new Object[]{Character.valueOf(']'), result, count});
                start = result.length();
                continue;
            }
            String key = result.substring(start + START.length(), index - 1);
            int sep = key.indexOf(58);
            if (sep == -1) {
                start = index;
                continue;
            }
            String type = key.substring(0, sep);
            String postfix = key.substring(sep + 1);
            LOGGER.trace("Type: '{}', postfix: '{}'", (Object)type, (Object)postfix);
            int dirPos = postfix.indexOf(59);
            if (dirPos == -1) {
                name = postfix;
                directives = Collections.emptyMap();
                LOGGER.trace("No Directives");
            } else {
                name = postfix.substring(0, dirPos);
                directives = new HashMap();
                for (String dir : postfix.substring(dirPos + 1).split(";")) {
                    String[] kv = dir.split("=");
                    if (kv.length != 2) continue;
                    directives.put(kv[0], kv[1]);
                }
                LOGGER.trace("Defaults: '{}'", directives);
            }
            Object newName = Interpolator.replace(name, provider);
            Object replacement = provider.provide(type, newName.toString(), directives);
            if (replacement == null) {
                LOGGER.trace("No Replacements found for: '{}'", newName);
                start = index;
                continue;
            }
            if (!(replacement instanceof String) && start == 0 && index == result.length()) {
                return replacement;
            }
            result = result.substring(0, start).concat(replacement.toString()).concat(result.substring(index));
            LOGGER.trace("Replacements found for: '{}': '{}'", newName, (Object)result);
        }
        return result;
    }

    @FunctionalInterface
    public static interface Provider {
        public Object provide(String var1, String var2, Map<String, String> var3);
    }
}

