/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.PipeBindings;
import org.apache.sling.pipes.Plumber;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemovePipe
extends BasePipe {
    private static Logger logger = LoggerFactory.getLogger(RemovePipe.class);
    public static final String RESOURCE_TYPE = "slingPipes/rm";
    Resource filter = this.getConfiguration();

    public RemovePipe(Plumber plumber, Resource resource, PipeBindings upperBindings) {
        super(plumber, resource, upperBindings);
    }

    @Override
    public boolean modifiesContent() {
        return true;
    }

    @Override
    protected Iterator<Resource> computeOutput() {
        Resource resource = this.getInput();
        String parentPath = null;
        try {
            if (resource.adaptTo(Node.class) != null) {
                parentPath = this.removeTree(resource, this.filter);
            } else {
                Node parent;
                Property property = (Property)resource.adaptTo(Property.class);
                if (property != null && (parent = property.getParent()) != null) {
                    parentPath = parent.getPath();
                    logger.info("removing property {}", (Object)property.getPath());
                    if (!this.isDryRun()) {
                        property.remove();
                    }
                }
            }
            if (parentPath != null) {
                return Collections.singleton(this.resolver.getResource(parentPath)).iterator();
            }
        }
        catch (RepositoryException e) {
            logger.error("unable to remove given resource", (Throwable)e);
        }
        return Collections.emptyIterator();
    }

    private boolean removeProperty(@NotNull Node node, String key) throws RepositoryException {
        if (!IGNORED_PROPERTIES.contains(key) && node.hasProperty(key)) {
            logger.info("removing property {}", (Object)node.getProperty(key).getPath());
            if (!this.isDryRun()) {
                node.getProperty(key).remove();
                return true;
            }
        }
        return false;
    }

    private int removeProperties(Resource resource, Resource configuration) throws RepositoryException {
        Node node;
        int count = 0;
        if (configuration != null && (node = (Node)resource.adaptTo(Node.class)) != null) {
            ValueMap configuredProperties = configuration.getValueMap();
            for (String key : configuredProperties.keySet()) {
                if (!this.removeProperty(node, key)) continue;
                ++count;
            }
        }
        return count;
    }

    private String removeNode(Resource resource) throws RepositoryException {
        logger.info("removing node {}", (Object)resource.getPath());
        Resource parent = resource.getParent();
        if (parent != null && !this.isDryRun()) {
            Node node = (Node)resource.adaptTo(Node.class);
            if (node != null) {
                node.remove();
            }
            return parent.getPath();
        }
        return resource.getPath();
    }

    private String removeTree(Resource resource, Resource configuration) throws RepositoryException {
        NodeIterator childConf;
        logger.debug("removing tree {}", (Object)resource.getPath());
        String remainingPath = resource.getPath();
        int configuredProperties = this.removeProperties(resource, configuration);
        Node configuredNode = configuration != null ? (Node)configuration.adaptTo(Node.class) : null;
        NodeIterator nodeIterator = childConf = configuredNode != null ? configuredNode.getNodes() : null;
        if (childConf == null || !childConf.hasNext() && configuredProperties == 0) {
            remainingPath = this.removeNode(resource);
        } else {
            while (childConf.hasNext()) {
                Node childToRemove = childConf.nextNode();
                Resource child = resource.getChild(childToRemove.getName());
                if (child == null) continue;
                this.removeTree(child, configuration.getChild(childToRemove.getName()));
            }
        }
        return remainingPath;
    }
}

