/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.JexlNode;

public class Script
implements JexlScript,
JexlExpression {
    protected final Engine jexl;
    protected final String source;
    protected final ASTJexlScript script;
    protected int version;

    protected Script(Engine engine, String expr, ASTJexlScript ref) {
        this.jexl = engine;
        this.source = expr;
        this.script = ref;
        this.version = this.jexl.getUberspect().getVersion();
    }

    protected void checkCacheVersion() {
        int uberVersion = this.jexl.getUberspect().getVersion();
        if (this.version != uberVersion) {
            this.script.clearCache();
            this.version = uberVersion;
        }
    }

    protected Scope.Frame createFrame(Object[] args) {
        return this.script.createFrame(args);
    }

    protected Interpreter createInterpreter(JexlContext context, Scope.Frame frame) {
        return this.jexl.createInterpreter(context, frame);
    }

    public JexlEngine getEngine() {
        return this.jexl;
    }

    @Override
    public String getSourceText() {
        return this.source;
    }

    @Override
    public String getParsedText() {
        return this.getParsedText(2);
    }

    @Override
    public String getParsedText(int indent) {
        Debugger debug = new Debugger();
        debug.setIndentation(indent);
        debug.debug(this.script);
        return debug.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.jexl != null ? this.jexl.hashCode() : 0);
        hash = 31 * hash + (this.source != null ? this.source.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Script other = (Script)obj;
        if (this.jexl != other.jexl) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    public String toString() {
        String src = this.source;
        if (src == null) {
            Debugger debug = new Debugger();
            debug.debug(this.script);
            src = debug.toString();
        }
        return src == null ? "/*no source*/" : src.toString();
    }

    @Override
    public Object evaluate(JexlContext context) {
        if (this.script.jjtGetNumChildren() < 1) {
            return null;
        }
        this.checkCacheVersion();
        Scope.Frame frame = this.createFrame(null);
        Interpreter interpreter = this.createInterpreter(context, frame);
        return interpreter.interpret(this.script.jjtGetChild(0));
    }

    @Override
    public Object execute(JexlContext context) {
        this.checkCacheVersion();
        Scope.Frame frame = this.createFrame(null);
        Interpreter interpreter = this.createInterpreter(context, frame);
        return interpreter.interpret(this.script);
    }

    @Override
    public Object execute(JexlContext context, Object ... args) {
        this.checkCacheVersion();
        Scope.Frame frame = this.createFrame(args != null && args.length > 0 ? args : null);
        Interpreter interpreter = this.createInterpreter(context, frame);
        return interpreter.interpret(this.script);
    }

    @Override
    public JexlScript curry(Object ... args) {
        String[] parms = this.script.getParameters();
        if (parms == null || parms.length == 0) {
            return this;
        }
        return new Curried(this, args);
    }

    @Override
    public String[] getParameters() {
        return this.script.getParameters();
    }

    @Override
    public String[] getLocalVariables() {
        return this.script.getLocalVariables();
    }

    @Override
    public Set<List<String>> getVariables() {
        return this.jexl.getVariables(this.script);
    }

    @Override
    public Map<String, Object> getPragmas() {
        return this.script.getPragmas();
    }

    @Override
    public Callable<Object> callable(JexlContext context) {
        return this.callable(context, null);
    }

    @Override
    public Callable<Object> callable(JexlContext context, Object ... args) {
        final Interpreter interpreter = this.jexl.createInterpreter(context, this.script.createFrame(args));
        return new Callable<Object>(){
            private Object result;
            {
                this.result = interpreter;
            }

            @Override
            public Object call() throws Exception {
                if (this.result == interpreter) {
                    Script.this.checkCacheVersion();
                    this.result = interpreter.interpret(Script.this.script);
                }
                return this.result;
            }
        };
    }

    public static class Curried
    extends Script {
        private final Scope.Frame frame;

        protected Curried(Script base, Object[] args) {
            super(base.jexl, base.source, base.script);
            Scope.Frame sf = base instanceof Curried ? ((Curried)base).frame : null;
            this.frame = sf != null ? sf.assign(args) : this.script.createFrame(args);
        }

        @Override
        protected Scope.Frame createFrame(Object[] args) {
            return this.frame != null ? this.frame.assign(args) : super.createFrame(args);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public Object execute(JexlContext context) {
            return this.execute(context, null);
        }

        @Override
        public Object execute(JexlContext context, Object ... args) {
            Scope.Frame callFrame = null;
            if (this.frame != null) {
                callFrame = this.frame.assign(args);
            }
            Interpreter interpreter = this.jexl.createInterpreter(context, callFrame);
            JexlNode block = this.script.jjtGetChild(this.script.jjtGetNumChildren() - 1);
            return interpreter.interpret(block);
        }
    }
}

