/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.core.Buffered;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.io.BoundedOutputStreamWriter;

public class Snippet {
    private final int max;
    private final JsonGeneratorFactory generatorFactory;

    public Snippet(int max, JsonGeneratorFactory generatorFactory) {
        this.max = max;
        this.generatorFactory = generatorFactory;
    }

    public String of(JsonValue value) {
        Buffer buffer;
        try (Buffer b = buffer = new Buffer();){
            b.write(value);
        }
        return buffer.get();
    }

    public static Snippet of(int max) {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("org.apache.johnzon.default-char-buffer-generator", max);
        properties.put("org.apache.johnzon.boundedoutputstreamwriter", max);
        return new Snippet(max, Json.createGeneratorFactory(properties));
    }

    public static String of(int max, JsonValue value) {
        return Snippet.of(max).of(value);
    }

    private class Buffer
    implements Closeable {
        private final JsonGenerator generator;
        private final SnippetWriter snippet;

        private Buffer() {
            this.snippet = new SnippetWriter(Snippet.this.max);
            this.generator = Snippet.this.generatorFactory.createGenerator((Writer)this.snippet);
        }

        private void write(JsonValue value) {
            if (this.terminate()) {
                return;
            }
            switch (value.getValueType()) {
                case ARRAY: {
                    this.write(value.asJsonArray());
                    break;
                }
                case OBJECT: {
                    this.write(value.asJsonObject());
                    break;
                }
                default: {
                    this.generator.write(value);
                }
            }
        }

        private void write(JsonArray array) {
            if (array.isEmpty()) {
                this.generator.write((JsonValue)array);
                return;
            }
            this.generator.writeStartArray();
            for (JsonValue jsonValue : array) {
                if (this.terminate()) break;
                this.write(jsonValue);
            }
            this.generator.writeEnd();
        }

        private void write(JsonObject object) {
            if (object.isEmpty()) {
                this.generator.write((JsonValue)object);
                return;
            }
            this.generator.writeStartObject();
            for (Map.Entry entry : object.entrySet()) {
                if (this.terminate()) break;
                this.write((String)entry.getKey(), (JsonValue)entry.getValue());
            }
            this.generator.writeEnd();
        }

        private void write(String name, JsonValue value) {
            switch (value.getValueType()) {
                case ARRAY: {
                    this.generator.writeStartArray(name);
                    JsonArray array = value.asJsonArray();
                    for (JsonValue jsonValue : array) {
                        if (this.terminate()) break;
                        this.write(jsonValue);
                    }
                    this.generator.writeEnd();
                    break;
                }
                case OBJECT: {
                    this.generator.writeStartObject(name);
                    JsonObject object = value.asJsonObject();
                    for (Map.Entry keyval : object.entrySet()) {
                        if (this.terminate()) break;
                        this.write((String)keyval.getKey(), (JsonValue)keyval.getValue());
                    }
                    this.generator.writeEnd();
                    break;
                }
                default: {
                    this.generator.write(name, value);
                }
            }
        }

        private boolean terminate() {
            return this.snippet.terminate();
        }

        private String get() {
            return this.snippet.get() + (this.snippet.isTruncated() ? "..." : "");
        }

        @Override
        public void close() {
            this.generator.close();
        }

        class SnippetWriter
        extends PassthroughWriter
        implements Buffered {
            private final ByteArrayOutputStream buffer;
            private final int max;
            private PassthroughWriter mode;

            public SnippetWriter(int max) {
                this.max = max;
                this.buffer = new ByteArrayOutputStream(max);
                this.mode = new Writing(max, new BoundedOutputStreamWriter(this.buffer, JsonGeneratorFactoryImpl.class.isInstance(Snippet.this.generatorFactory) ? ((JsonGeneratorFactoryImpl)JsonGeneratorFactoryImpl.class.cast(Snippet.this.generatorFactory)).getDefaultEncoding() : StandardCharsets.UTF_8, max));
            }

            public String get() {
                return this.buffer.toString();
            }

            @Override
            public int bufferSize() {
                return this.max;
            }

            public boolean terminate() {
                if (this.mode instanceof Truncated) {
                    return true;
                }
                if (this.mode instanceof Completed) {
                    this.mode = new Truncated();
                    return true;
                }
                return false;
            }

            public boolean isTruncated() {
                return this.mode instanceof Truncated;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.mode.write(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.mode.flush();
            }

            @Override
            public void close() throws IOException {
                this.mode.close();
            }

            class Truncated
            extends PassthroughWriter {
                Truncated() {
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                }
            }

            class Completed
            extends PassthroughWriter {
                Completed() {
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    if (len > 0) {
                        SnippetWriter.this.mode = new Truncated();
                    }
                }
            }

            class Writing
            extends PassthroughWriter {
                private final int max;
                private int count;
                private final Writer writer;

                public Writing(int max, Writer writer) {
                    this.max = max;
                    this.writer = writer;
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    int remaining = this.max - this.count;
                    if (remaining <= 0) {
                        this.maxReached(new Truncated());
                    } else if (len == remaining) {
                        this.count += len;
                        this.writer.write(cbuf, off, remaining);
                        this.maxReached(new Completed());
                    } else if (len > remaining) {
                        this.count += len;
                        this.writer.write(cbuf, off, remaining);
                        this.maxReached(new Truncated());
                    } else {
                        this.count += len;
                        this.writer.write(cbuf, off, len);
                    }
                }

                @Override
                public void flush() throws IOException {
                    this.writer.flush();
                }

                @Override
                public void close() throws IOException {
                    this.writer.close();
                }

                private void maxReached(PassthroughWriter mode) throws IOException {
                    SnippetWriter.this.mode = mode;
                    this.writer.flush();
                    this.writer.close();
                }
            }
        }
    }

    private static abstract class PassthroughWriter
    extends Writer {
        private PassthroughWriter() {
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        @Override
        public void write(String str) throws IOException {
            this.write(str.toCharArray(), 0, str.length());
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), 0, len);
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.write(csq.toString().toCharArray(), 0, csq.length());
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.write(csq.toString().toCharArray(), start, end);
            return this;
        }

        @Override
        public Writer append(char c) throws IOException {
            this.write(new char[]{c}, 0, 1);
            return this;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

