/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.extension.apiregions.api.ApiExport;
import org.apache.sling.feature.extension.apiregions.api.ApiRegion;

public class ApiRegions {
    public static final String EXTENSION_NAME = "api-regions";
    private static final String NAME_KEY = "name";
    private static final String EXPORTS_KEY = "exports";
    private final List<ApiRegion> regions = new ArrayList<ApiRegion>();

    public List<ApiRegion> listRegions() {
        return Collections.unmodifiableList(this.regions);
    }

    public ApiRegion getRoot() {
        if (this.regions.isEmpty()) {
            return null;
        }
        return this.regions.get(0);
    }

    public boolean isEmpty() {
        return this.regions.isEmpty();
    }

    public boolean add(ApiRegion region) {
        return this.add(this.regions.size(), region);
    }

    public boolean add(int idx, ApiRegion region) {
        for (ApiRegion c : this.regions) {
            if (!c.getName().equals(region.getName())) continue;
            return false;
        }
        LinkedHashSet<ArtifactId> origins = new LinkedHashSet<ArtifactId>(Arrays.asList(region.getFeatureOrigins()));
        this.regions.stream().filter(existingRegion -> {
            ArtifactId[] targetOrigins = existingRegion.getFeatureOrigins();
            if (targetOrigins.length == 0) {
                if (origins.isEmpty()) return true;
            }
            if (!Stream.of(targetOrigins).anyMatch(origins::contains)) return false;
            return true;
        }).reduce((a, b) -> b).ifPresent(region::setParent);
        this.regions.add(idx, region);
        return true;
    }

    public ApiRegion getRegionByName(String name) {
        ApiRegion found = null;
        for (ApiRegion c : this.regions) {
            if (!c.getName().equals(name)) continue;
            found = c;
            break;
        }
        return found;
    }

    public ApiRegion[] getRegionsByFeature(ArtifactId featureId) {
        return (ApiRegion[])this.regions.stream().filter(region -> Stream.of(region.getFeatureOrigins()).anyMatch(arg_0 -> ((ArtifactId)featureId).equals(arg_0))).toArray(ApiRegion[]::new);
    }

    public List<String> getRegionNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ApiRegion c : this.regions) {
            names.add(c.getName());
        }
        return Collections.unmodifiableList(names);
    }

    public JsonArray toJSONArray() throws IOException {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (ApiRegion region : this.regions) {
            ArtifactId[] origins;
            JsonObjectBuilder regionBuilder = Json.createObjectBuilder();
            regionBuilder.add(NAME_KEY, region.getName());
            if (!region.listExports().isEmpty()) {
                JsonArrayBuilder expArrayBuilder = Json.createArrayBuilder();
                for (ApiExport apiExport : region.listExports()) {
                    expArrayBuilder.add(apiExport.toJSONValue());
                }
                regionBuilder.add(EXPORTS_KEY, expArrayBuilder);
            }
            if ((origins = region.getFeatureOrigins()).length > 0) {
                JsonArrayBuilder originBuilder = Json.createArrayBuilder();
                for (ArtifactId origin : origins) {
                    originBuilder.add(origin.toMvnId());
                }
                regionBuilder.add("feature-origins", originBuilder);
            }
            for (Map.Entry entry : region.getProperties().entrySet()) {
                regionBuilder.add((String)entry.getKey(), (String)entry.getValue());
            }
            arrayBuilder.add(regionBuilder);
        }
        return arrayBuilder.build();
    }

    public String toJSON() throws IOException {
        JsonArray array = this.toJSONArray();
        try (StringWriter stringWriter = new StringWriter();){
            String string;
            block11: {
                JsonWriter writer = Json.createWriter((Writer)stringWriter);
                try {
                    writer.writeArray(array);
                    string = stringWriter.toString();
                    if (writer == null) break block11;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
    }

    public static ApiRegions parse(String json) throws IOException {
        try (JsonReader reader = Json.createReader((Reader)new StringReader(json));){
            ApiRegions apiRegions = ApiRegions.parse(reader.readArray());
            return apiRegions;
        }
    }

    public static ApiRegions parse(JsonArray json) throws IOException {
        try {
            ApiRegions regions = new ApiRegions();
            for (JsonValue value : json) {
                if (value.getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new IOException("Illegal api regions json " + json);
                }
                JsonObject obj = (JsonObject)value;
                ApiRegion region = new ApiRegion(obj.getString(NAME_KEY));
                for (Map.Entry entry : obj.entrySet()) {
                    if (NAME_KEY.equals(entry.getKey())) continue;
                    if (((String)entry.getKey()).equals(EXPORTS_KEY)) {
                        for (JsonValue e : (JsonArray)entry.getValue()) {
                            ApiExport.fromJson(region, e);
                        }
                        continue;
                    }
                    if (((String)entry.getKey()).equals("feature-origins")) {
                        LinkedHashSet<ArtifactId> origins = new LinkedHashSet<ArtifactId>();
                        for (JsonValue origin : (JsonArray)entry.getValue()) {
                            origins.add(ArtifactId.fromMvnId((String)((JsonString)origin).getString()));
                        }
                        region.setFeatureOrigins(origins.toArray(new ArtifactId[0]));
                        continue;
                    }
                    region.getProperties().put((String)entry.getKey(), ((JsonString)entry.getValue()).getString());
                }
                if (regions.add(region)) continue;
                throw new IOException("Region " + region.getName() + " is defined twice");
            }
            return regions;
        }
        catch (JsonException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public static ApiRegions getApiRegions(Feature feature) {
        Extension ext = feature == null ? null : feature.getExtensions().getByName(EXTENSION_NAME);
        return ApiRegions.getApiRegions(ext);
    }

    public static ApiRegions getApiRegions(Extension ext) {
        if (ext == null) {
            return null;
        }
        if (ext.getType() != ExtensionType.JSON) {
            throw new IllegalArgumentException("Extension " + ext.getName() + " must have JSON type");
        }
        if (ext.getJSONStructure() == null) {
            return new ApiRegions();
        }
        try {
            return ApiRegions.parse(ext.getJSONStructure().asJsonArray());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage(), ioe);
        }
    }

    public String toString() {
        return "ApiRegions [regions=" + this.regions + "]";
    }

    public int hashCode() {
        return Objects.hash(this.regions);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiRegions other = (ApiRegions)obj;
        return Objects.equals(this.regions, other.regions);
    }
}

