/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl.launchers;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunner
implements Callable<Integer> {
    private static final String CM_CONFIG_PM = "felix.cm.pm";
    private static final String PM_FEATURE_LAUNCHER = "featurelauncher";
    private static final String PM_MEMORY_FILTER = "(&(objectClass=org.apache.felix.cm.PersistenceManager)(name=memory))";
    private volatile ServiceTracker<Object, Object> configAdminTracker;
    private volatile ServiceTracker<Object, Object> installerTracker;
    private final List<Object[]> configurations;
    private final List<URL> installables;
    protected final Logger logger;
    private Supplier<String> featureSupplier;
    private BiConsumer<URL, Map<String, String>> bundleReporter;

    public AbstractRunner(List<Object[]> configurations, List<URL> installables) {
        this.configurations = new ArrayList<Object[]>(configurations);
        this.installables = installables;
        this.logger = LoggerFactory.getLogger((String)"launcher");
    }

    public void setFeatureSupplier(Supplier<String> supplier) {
        this.featureSupplier = supplier;
    }

    public void setBundleReporter(BiConsumer<URL, Map<String, String>> reporter) {
        this.bundleReporter = reporter;
    }

    protected void setupFramework(final Framework framework, Map<Integer, List<URL>> bundlesMap) throws BundleException {
        String pm = framework.getBundleContext().getProperty(CM_CONFIG_PM);
        if (PM_FEATURE_LAUNCHER.equals(pm)) {
            this.logger.info("Using feature launcher configuration admin persistence manager");
            try {
                this.configAdminTracker = new ServiceTracker(framework.getBundleContext(), framework.getBundleContext().createFilter(PM_MEMORY_FILTER), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){
                    private volatile ServiceRegistration<?> reg;

                    public Object addingService(ServiceReference<Object> reference) {
                        Object memoryPM = framework.getBundleContext().getService(reference);
                        if (memoryPM != null) {
                            try {
                                Method storeMethod = memoryPM.getClass().getDeclaredMethod("store", String.class, Dictionary.class);
                                for (Object[] obj : AbstractRunner.this.configurations) {
                                    String pid;
                                    Dictionary props = (Dictionary)obj[2];
                                    if (obj[1] != null) {
                                        String factoryPid = (String)obj[1];
                                        pid = factoryPid.concat("~").concat((String)obj[0]);
                                        props.put("service.factoryPid", factoryPid);
                                    } else {
                                        pid = (String)obj[0];
                                    }
                                    props.put("service.pid", pid);
                                    storeMethod.invoke(memoryPM, pid, props);
                                }
                                Hashtable<String, String> properties = new Hashtable<String, String>();
                                ((Dictionary)properties).put("name", AbstractRunner.PM_FEATURE_LAUNCHER);
                                this.reg = reference.getBundle().getBundleContext().registerService("org.apache.felix.cm.PersistenceManager", memoryPM, properties);
                            }
                            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return memoryPM;
                    }

                    public void modifiedService(ServiceReference<Object> reference, Object service) {
                    }

                    public void removedService(ServiceReference<Object> reference, Object service) {
                        if (this.reg != null) {
                            this.reg.unregister();
                            this.reg = null;
                        }
                        reference.getBundle().getBundleContext().ungetService(reference);
                    }
                });
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException(e);
            }
            this.configAdminTracker.open(true);
        } else if (!this.configurations.isEmpty()) {
            this.configAdminTracker = new ServiceTracker(framework.getBundleContext(), "org.osgi.service.cm.ConfigurationAdmin", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

                public Object addingService(ServiceReference<Object> reference) {
                    Object cm = framework.getBundleContext().getService(reference);
                    if (cm != null) {
                        try {
                            AbstractRunner.this.configure(cm);
                        }
                        finally {
                            framework.getBundleContext().ungetService(reference);
                        }
                    }
                    return null;
                }

                public void modifiedService(ServiceReference<Object> reference, Object service) {
                }

                public void removedService(ServiceReference<Object> reference, Object service) {
                }
            });
            this.configAdminTracker.open(true);
        }
        if (!this.installables.isEmpty()) {
            this.installerTracker = new ServiceTracker(framework.getBundleContext(), "org.apache.sling.installer.api.OsgiInstaller", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

                public Object addingService(ServiceReference<Object> reference) {
                    Object installer = framework.getBundleContext().getService(reference);
                    if (installer != null) {
                        try {
                            AbstractRunner.this.install(installer);
                        }
                        finally {
                            framework.getBundleContext().ungetService(reference);
                        }
                    }
                    return null;
                }

                public void modifiedService(ServiceReference<Object> reference, Object service) {
                }

                public void removedService(ServiceReference<Object> reference, Object service) {
                }
            });
            this.installerTracker.open();
        }
        this.install(framework, bundlesMap);
    }

    protected boolean startFramework(final Framework framework, long timeout, TimeUnit unit) throws BundleException, InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Void> result = executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                framework.start();
                return null;
            }
        });
        try {
            result.get(timeout, unit);
            boolean bl = true;
            return bl;
        }
        catch (TimeoutException ex) {
            boolean bl = false;
            return bl;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof BundleException) {
                throw (BundleException)cause;
            }
            throw (RuntimeException)cause;
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void configure(Object configAdmin) {
        try {
            Method createConfig = configAdmin.getClass().getDeclaredMethod("getConfiguration", String.class, String.class);
            Method createFactoryConfig = configAdmin.getClass().getDeclaredMethod("getFactoryConfiguration", String.class, String.class, String.class);
            Method updateMethod = null;
            for (Object[] obj : this.configurations) {
                Object cfg = obj[1] != null ? createFactoryConfig.invoke(configAdmin, obj[1], obj[0], null) : createConfig.invoke(configAdmin, obj[0], null);
                if (updateMethod == null) {
                    updateMethod = cfg.getClass().getDeclaredMethod("update", Dictionary.class);
                }
                updateMethod.invoke(cfg, obj[2]);
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to create configurations", (Throwable)e);
            throw new RuntimeException(e);
        }
        Thread t = new Thread(() -> {
            this.configAdminTracker.close();
            this.configAdminTracker = null;
        });
        t.setDaemon(false);
        t.start();
        this.configurations.clear();
    }

    private boolean isSystemBundleFragment(Bundle installedBundle) {
        String fragmentHeader = this.getFragmentHostHeader(installedBundle);
        return fragmentHeader != null && fragmentHeader.indexOf("extension") > 0;
    }

    private String getFragmentHostHeader(Bundle b) {
        return (String)b.getHeaders().get("Fragment-Host");
    }

    private void install(Framework framework, Map<Integer, List<URL>> bundleMap) throws BundleException {
        BundleContext bc = framework.getBundleContext();
        int defaultStartLevel = AbstractRunner.getProperty(bc, "felix.startlevel.bundle", 1);
        for (Integer startLevel : AbstractRunner.sortStartLevels(bundleMap.keySet(), defaultStartLevel)) {
            this.logger.debug("Installing bundles with start level {}", (Object)startLevel);
            for (URL file : bundleMap.get(startLevel)) {
                Bundle bundle;
                this.logger.debug("- {}", (Object)file);
                String location = "";
                if (file.getProtocol().equals("file")) {
                    location = "reference:";
                }
                if (!this.isSystemBundleFragment(bundle = bc.installBundle(location = location.concat(file.toString()), null)) && this.getFragmentHostHeader(bundle) == null) {
                    if (startLevel > 0) {
                        ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).setStartLevel(startLevel.intValue());
                    }
                    bundle.start();
                }
                if (this.bundleReporter == null) continue;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("Bundle-SymbolicName", bundle.getSymbolicName());
                params.put("Bundle-Version", bundle.getVersion().toString());
                params.put("Bundle-Id", String.valueOf(bundle.getBundleId()));
                this.bundleReporter.accept(file, params);
            }
        }
    }

    protected void finishStartup(Framework framework) {
        Bundle featureBundle = null;
        for (Bundle bundle : framework.getBundleContext().getBundles()) {
            if (this.featureSupplier == null || !"org.apache.sling.feature".equals(bundle.getSymbolicName())) continue;
            featureBundle = bundle;
        }
        if (featureBundle != null) {
            final Bundle bundle = featureBundle;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("name", "org.apache.sling.feature.launcher");
            featureBundle.getBundleContext().registerService(new String[]{"org.apache.sling.feature.Feature"}, (Object)new PrototypeServiceFactory<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object getService(Bundle client, ServiceRegistration<Object> registration) {
                    ClassLoader cl = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
                    ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    try {
                        Class<?> readerClass = cl.loadClass("org.apache.sling.feature.io.json.FeatureJSONReader");
                        Method readMethod = readerClass.getDeclaredMethod("read", Reader.class, String.class);
                        StringReader reader = new StringReader((String)AbstractRunner.this.featureSupplier.get());
                        try {
                            Object object = readMethod.invoke(null, reader, null);
                            reader.close();
                            return object;
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                            }
                        }
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldTCCL);
                    }
                    return null;
                }

                public void ungetService(Bundle client, ServiceRegistration<Object> registration, Object service) {
                }
            }, properties);
        }
    }

    private static Iterable<Integer> sortStartLevels(Collection<Integer> startLevels, int defaultStartLevel) {
        ArrayList<Integer> result = new ArrayList<Integer>(startLevels);
        Collections.sort(result, (o1, o2) -> {
            int i1 = o1 == 0 ? defaultStartLevel : o1;
            int i2 = o2 == 0 ? defaultStartLevel : o2;
            return Integer.compare(i1, i2);
        });
        return result;
    }

    private static int getProperty(BundleContext bc, String propName, int defaultValue) {
        String val = bc.getProperty(propName);
        if (val == null) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    private void install(Object installer) {
        try {
            Class<?> installableResourceClass = installer.getClass().getClassLoader().loadClass("org.apache.sling.installer.api.InstallableResource");
            Object resources = Array.newInstance(installableResourceClass, this.installables.size());
            Method registerResources = installer.getClass().getDeclaredMethod("registerResources", String.class, resources.getClass());
            Constructor<?> constructor = installableResourceClass.getDeclaredConstructor(String.class, InputStream.class, Dictionary.class, String.class, String.class, Integer.class);
            for (int i = 0; i < this.installables.size(); ++i) {
                URL f = this.installables.get(i);
                Hashtable<String, String> dict = new Hashtable<String, String>();
                ((Dictionary)dict).put("resource.uri.hint", f.toURI().toString());
                Object rsrc = constructor.newInstance(f.getPath(), f.openStream(), dict, f.getPath(), "file", null);
                Array.set(resources, i, rsrc);
            }
            registerResources.invoke(installer, "cloudlauncher", resources);
        }
        catch (Exception e) {
            this.logger.error("Unable to contact installer and install additional artifacts", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            Thread t = new Thread(() -> {
                this.installerTracker.close();
                this.installerTracker = null;
            });
            t.setDaemon(false);
            t.start();
            this.installables.clear();
        }
    }
}

