/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.queue.impl;

import java.io.Closeable;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.impl.publisher.PackageQueuedNotifier;
import org.apache.sling.distribution.journal.messages.PackageStatusMessage;
import org.apache.sling.distribution.journal.queue.CacheCallback;
import org.apache.sling.distribution.journal.queue.OffsetQueue;
import org.apache.sling.distribution.journal.queue.PubQueueProvider;
import org.apache.sling.distribution.journal.queue.QueueState;
import org.apache.sling.distribution.journal.queue.impl.OffsetQueueImpl;
import org.apache.sling.distribution.journal.queue.impl.PubErrQueue;
import org.apache.sling.distribution.journal.queue.impl.PubQueue;
import org.apache.sling.distribution.journal.queue.impl.PubQueueCache;
import org.apache.sling.distribution.journal.queue.impl.QueueErrors;
import org.apache.sling.distribution.journal.shared.AgentId;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class PubQueueProviderImpl
implements PubQueueProvider,
Runnable {
    private static final int CLEANUP_THRESHOLD = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(PubQueueProviderImpl.class);
    private final PackageQueuedNotifier queuedNotifier;
    private final CacheCallback callback;
    private volatile PubQueueCache cache;
    private final QueueErrors queueErrors;
    private final Map<String, OffsetQueue<Long>> errorQueues = new ConcurrentHashMap<String, OffsetQueue<Long>>();
    private ServiceRegistration<?> reg;

    public PubQueueProviderImpl(EventAdmin eventAdmin, QueueErrors queueErrors, CacheCallback callback, BundleContext context) {
        this.queuedNotifier = new PackageQueuedNotifier(eventAdmin);
        this.queueErrors = queueErrors;
        this.callback = callback;
        this.cache = this.newCache();
        this.startCleanupTask(context);
        LOG.info("Started Publisher queue provider service");
    }

    private void startCleanupTask(BundleContext context) {
        Hashtable<String, Comparable<Boolean>> props = new Hashtable<String, Comparable<Boolean>>();
        ((Dictionary)props).put("scheduler.concurrent", false);
        ((Dictionary)props).put("scheduler.period", 43200L);
        this.reg = context.registerService(Runnable.class.getName(), (Object)this, props);
    }

    @Override
    public void close() {
        PubQueueCache queueCache = this.cache;
        if (queueCache != null) {
            queueCache.close();
        }
        if (this.reg != null) {
            try {
                this.reg.unregister();
                this.reg = null;
            }
            catch (Exception e) {
                LOG.info(e.getMessage(), (Throwable)e);
            }
        }
        IOUtils.closeQuietly((Closeable)this.queuedNotifier);
        LOG.info("Stopped Publisher queue provider service");
    }

    @Override
    public void run() {
        LOG.info("Starting package cache cleanup task");
        PubQueueCache queueCache = this.cache;
        if (queueCache != null) {
            int size = queueCache.size();
            if (size > 10000) {
                LOG.info("Cleanup package cache (size={}/{})", (Object)size, (Object)10000);
                queueCache.close();
                this.cache = this.newCache();
            } else {
                LOG.info("No cleanup required for package cache (size={}/{})", (Object)size, (Object)10000);
            }
        }
        LOG.info("Stopping package cache cleanup task");
    }

    @Override
    @Nonnull
    public Set<String> getQueueNames(String pubAgentName) {
        HashSet<String> queueNames = new HashSet<String>();
        for (String subAgentId : this.callback.getSubscribedAgentIds(pubAgentName)) {
            boolean errorQueueEnabled;
            queueNames.add(subAgentId);
            QueueState subState = this.callback.getQueueState(pubAgentName, subAgentId);
            if (subState == null || !(errorQueueEnabled = subState.getMaxRetries() >= 0)) continue;
            queueNames.add(String.format("%s-error", subAgentId));
        }
        return queueNames;
    }

    @Override
    @Nonnull
    public PackageQueuedNotifier getQueuedNotifier() {
        return this.queuedNotifier;
    }

    @Override
    @Nullable
    public DistributionQueue getQueue(String pubAgentName, String queueName) {
        if (queueName.endsWith("-error")) {
            return this.getErrorQueue(pubAgentName, queueName);
        }
        QueueState state = this.callback.getQueueState(pubAgentName, queueName);
        if (state == null) {
            return null;
        }
        long minOffset = state.getLastProcessedOffset() + 1L;
        OffsetQueue<DistributionQueueItem> agentQueue = this.getOffsetQueue(pubAgentName, minOffset);
        Throwable error = this.queueErrors.getError(pubAgentName, queueName);
        return new PubQueue(queueName, agentQueue.getMinOffsetQueue(minOffset), state.getHeadRetries(), error, state.getClearCallback());
    }

    @Nonnull
    private DistributionQueue getErrorQueue(String pubAgentName, String queueName) {
        AgentId subAgentId = new AgentId(StringUtils.substringBeforeLast((String)queueName, (String)"-error"));
        String errorQueueKey = this.getErrorQueueKey(pubAgentName, subAgentId.getSlingId(), subAgentId.getAgentName());
        OffsetQueue errorQueue = this.errorQueues.getOrDefault(errorQueueKey, new OffsetQueueImpl());
        Long minReferencedOffset = (Long)errorQueue.getHeadItem();
        OffsetQueue<Object> agentQueue = minReferencedOffset == null ? new OffsetQueueImpl() : this.getOffsetQueue(pubAgentName, minReferencedOffset);
        return new PubErrQueue(queueName, agentQueue, errorQueue);
    }

    @Override
    @Nonnull
    public OffsetQueue<DistributionQueueItem> getOffsetQueue(String pubAgentName, long minOffset) {
        try {
            return this.cache.getOffsetQueue(pubAgentName, minOffset);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleStatus(MessageInfo info, PackageStatusMessage message) {
        if (message.getStatus() == PackageStatusMessage.Status.REMOVED_FAILED) {
            String errorQueueKey = this.getErrorQueueKey(message.getPubAgentName(), message.getSubSlingId(), message.getSubAgentName());
            OffsetQueue errorQueue = this.errorQueues.computeIfAbsent(errorQueueKey, key -> new OffsetQueueImpl());
            errorQueue.putItem(info.getOffset(), message.getOffset());
        }
    }

    private String getErrorQueueKey(String pubAgentName, String subSlingId, String subAgentName) {
        return String.format("%s#%s#%s", pubAgentName, subSlingId, subAgentName);
    }

    private PubQueueCache newCache() {
        return new PubQueueCache(this.queuedNotifier, this.callback);
    }
}

