/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.bookkeeper;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.distribution.journal.shared.JMXRegistration;
import org.apache.sling.distribution.journal.shared.LocalStoreJMXMBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class LocalStoreJMX
implements LocalStoreJMXMBean {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private ResourceResolverFactory resolverFactory;
    private JMXRegistration jmxRegistration;

    @Activate
    public void activate() throws NotCompliantMBeanException {
        Objects.requireNonNull(this.resolverFactory, "resolverFactory must not be null");
        StandardMBean mbean = new StandardMBean(this, LocalStoreJMXMBean.class);
        this.jmxRegistration = new JMXRegistration(mbean, "offsetReset", "default");
    }

    @Deactivate
    public void close() throws IOException {
        this.jmxRegistration.close();
    }

    @Override
    public void resetStores() {
        String path = "/var/sling/distribution/journal/stores";
        try (ResourceResolver resolver = this.getBookKeeperServiceResolver();){
            Resource rootResource = Objects.requireNonNull(resolver.getResource(path), path + " not found");
            Iterable children = resolver.getChildren(rootResource);
            children.forEach(res -> this.delete(resolver, (Resource)res));
            resolver.commit();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void delete(ResourceResolver resolver, Resource resource) {
        try {
            this.log.info("Deleting store {}", (Object)resource.getPath());
            resolver.delete(resource);
        }
        catch (PersistenceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ResourceResolver getBookKeeperServiceResolver() throws LoginException {
        return this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "bookkeeper"));
    }
}

