/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.binary.jcr;

import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.binary.jcr.JcrBinaryStore;
import org.apache.sling.distribution.journal.shared.PublisherConfigurationAvailable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Component(property={"scheduler.concurrent:Boolean=false", "scheduler.immediate:Boolean=true", "scheduler.period:Long=604800", "scheduler.runOn=LEADER"})
public class PackageCleanupTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(PackageCleanupTask.class);
    private static final long PKG_MAX_LIFETIME_MS = 2592000000L;
    @Reference
    private JcrBinaryStore binaryStore;
    @Reference
    private PublisherConfigurationAvailable publisherConfigurationAvailable;

    @Override
    public void run() {
        LOG.info("Starting Package Cleanup Task");
        long deleteOlderThanTime = System.currentTimeMillis() - 2592000000L;
        this.binaryStore.cleanup(deleteOlderThanTime);
        LOG.info("Finished Package Cleanup Task");
    }
}

