/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.testutils.mapsupport;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.contentparser.testutils.mapsupport.ContentElement;
import org.apache.sling.contentparser.testutils.mapsupport.ContentElementHandlerException;

public final class ContentElementHandler
implements ContentHandler {
    private ContentElement root;
    private static final Pattern PATH_PATTERN = Pattern.compile("^((/[^/]+)*)(/([^/]+))$");

    public void resource(String path, Map<String, Object> properties) {
        if (StringUtils.equals((CharSequence)path, (CharSequence)"/")) {
            this.root = new ContentElement(null, properties);
        } else {
            if (this.root == null) {
                throw new ContentElementHandlerException("Root resource not set.");
            }
            Matcher matcher = PATH_PATTERN.matcher(path);
            if (!matcher.matches()) {
                throw new ContentElementHandlerException("Unexpected path:" + path);
            }
            String relativeParentPath = StringUtils.stripStart((String)matcher.group(1), (String)"/");
            String name = matcher.group(4);
            ContentElement parent = StringUtils.isEmpty((CharSequence)relativeParentPath) ? this.root : this.root.getChild(relativeParentPath);
            if (parent == null) {
                throw new ContentElementHandlerException("Parent '" + relativeParentPath + "' does not exist.");
            }
            parent.getChildren().put(name, new ContentElement(name, properties));
        }
    }

    public ContentElement getRoot() {
        return this.root;
    }
}

