/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bundleresource.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.bundleresource.impl.BundleResource;
import org.apache.sling.bundleresource.impl.BundleResourceCache;
import org.apache.sling.bundleresource.impl.PathMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleResourceIterator
implements Iterator<Resource> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ResourceResolver resourceResolver;
    private final BundleResourceCache cache;
    private final PathMapping mappedPath;
    private final Iterator<String> entries;
    private final int prefixLength;
    private Resource nextResult;
    private final Map<String, Map<String, Object>> subResources;

    BundleResourceIterator(BundleResource parent) {
        this(parent.getResourceResolver(), parent.getBundle(), parent.getMappedPath(), parent.getPath(), parent.getSubResources());
    }

    BundleResourceIterator(ResourceResolver resourceResolver, BundleResourceCache bundle, PathMapping mappedPath, String parentPath, Map<String, Map<String, Object>> subResources) {
        String parentEntryPath = mappedPath.getEntryPath(parentPath.concat("/"));
        this.prefixLength = parentEntryPath.length();
        this.resourceResolver = resourceResolver;
        this.cache = bundle;
        this.subResources = subResources != null ? new HashMap<String, Map<String, Object>>(subResources) : null;
        this.mappedPath = mappedPath;
        this.entries = this.getFilteredEntries(parentEntryPath);
        this.nextResult = this.entries != null ? this.seek() : null;
    }

    private Iterator<String> getFilteredEntries(String parentEntryPath) {
        TreeSet<String> bundleEntries = new TreeSet<String>(this.cache.getEntryPaths(parentEntryPath));
        if (this.mappedPath.getJSONPropertiesExtension() != null) {
            HashSet<String> add = new HashSet<String>();
            Iterator iter = bundleEntries.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (!path.endsWith(this.mappedPath.getJSONPropertiesExtension())) continue;
                iter.remove();
                add.add(path.substring(0, path.length() - this.mappedPath.getJSONPropertiesExtension().length()));
            }
            bundleEntries.addAll(add);
            if (this.subResources != null) {
                for (String name : this.subResources.keySet()) {
                    String fullPath = parentEntryPath.concat(name);
                    if (!bundleEntries.contains(fullPath)) {
                        bundleEntries.add(fullPath);
                        continue;
                    }
                    this.subResources.remove(name);
                }
            }
        }
        return bundleEntries.isEmpty() ? null : bundleEntries.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.nextResult != null;
    }

    @Override
    public Resource next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Resource result = this.nextResult;
        this.nextResult = this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private Resource seek() {
        while (this.entries.hasNext()) {
            int slash;
            String entry = this.entries.next();
            if (!entry.startsWith("/")) {
                entry = "/".concat(entry);
            }
            if ((slash = entry.indexOf(47, this.prefixLength)) < 0 || slash == entry.length() - 1) {
                this.log.debug("seek: Using entry {}", (Object)entry);
                boolean isFolder = entry.endsWith("/");
                String entryPath = isFolder ? entry.substring(0, entry.length() - 1) : entry;
                return new BundleResource(this.resourceResolver, this.cache, this.mappedPath, this.mappedPath.getResourcePath(entryPath), this.subResources != null ? this.subResources.get(ResourceUtil.getName((String)entryPath)) : null, isFolder);
            }
            this.log.debug("seek: Ignoring entry {}", (Object)entry);
        }
        this.log.debug("seek: No more nodes, iterator exhausted");
        return null;
    }
}

