/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.oauth_client.impl;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.jcr.Credentials;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.oauth_client.impl.TokenStore;
import org.apache.sling.auth.oauth_client.spi.LoginCookieManager;
import org.apache.sling.auth.oauth_client.spi.OidcAuthCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={LoginCookieManager.class}, immediate=true, property={"service.ranking:Integer=10"})
public class SlingLoginCookieManager
implements LoginCookieManager {
    private static final Logger log = LoggerFactory.getLogger(SlingLoginCookieManager.class);
    private final TokenStore tokenStore;
    private final long sessionTimeout;
    private final String cookieName;

    @Activate
    public SlingLoginCookieManager(SlingLoginCookieManagerConfig config, BundleContext bundleContext) throws InvalidKeyException, NoSuchAlgorithmException, IllegalStateException {
        String tokenFileName = config.tokenFile();
        File tokenFile = SlingLoginCookieManager.getTokenFile(tokenFileName, bundleContext);
        boolean fastSeed = config.form_token_fastseed();
        log.info("Storing tokens in {}", (Object)tokenFile.getAbsolutePath());
        this.sessionTimeout = config.sessionTimeout();
        this.cookieName = config.cookieName();
        this.tokenStore = new TokenStore(tokenFile, this.sessionTimeout, fastSeed);
    }

    @Override
    public void setLoginCookie(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Credentials creds) {
        long expires = System.currentTimeMillis() + this.sessionTimeout;
        String authData = null;
        try {
            authData = this.tokenStore.encode(expires, ((OidcAuthCredentials)creds).getUserId());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String cookieValue = Base64.encodeBase64URLSafeString((byte[])authData.getBytes(StandardCharsets.UTF_8));
        SlingLoginCookieManager.setCookie(request, response, this.cookieName, cookieValue, (int)(this.sessionTimeout / 1000L));
    }

    @Override
    @Nullable
    public AuthenticationInfo verifyLoginCookie(@NotNull HttpServletRequest request) {
        Cookie cookie = this.getLoginCookie(request);
        if (cookie == null) {
            return null;
        }
        String cookieValue = cookie.getValue();
        if (cookieValue.isEmpty()) {
            return null;
        }
        String decodedCookieValue = new String(Base64.decodeBase64((String)cookieValue), StandardCharsets.UTF_8);
        if (this.tokenStore.isValid(decodedCookieValue)) {
            return SlingLoginCookieManager.createAuthInfo(decodedCookieValue);
        }
        return null;
    }

    @Override
    @Nullable
    public Cookie getLoginCookie(@NotNull HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!this.cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Nullable
    private static AuthenticationInfo createAuthInfo(@NotNull String authData) {
        String userId = SlingLoginCookieManager.getUserId(authData);
        if (userId == null) {
            return null;
        }
        OidcAuthCredentials credentials = new OidcAuthCredentials(userId, "oidc");
        credentials.setAttribute(".token", "");
        AuthenticationInfo authInfo = new AuthenticationInfo("oidc", userId);
        authInfo.put("user.jcr.credentials", (Object)credentials);
        return authInfo;
    }

    @Nullable
    private static String getUserId(@NotNull String authData) {
        String[] parts = TokenStore.split(authData);
        if (parts.length == 3) {
            return parts[2];
        }
        return null;
    }

    private static void setCookie(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String name, @NotNull String value, int maxAge) {
        StringBuilder cookie = new StringBuilder(name);
        cookie.append('=');
        cookie.append(value);
        cookie.append("; Path=/; HttpOnly");
        if (maxAge >= 0) {
            cookie.append("; Max-Age=");
            cookie.append(maxAge);
        }
        cookie.append("; SameSite=Lax");
        if (request.isSecure()) {
            cookie.append("; Secure");
        }
        response.addHeader("Set-Cookie", cookie.toString());
    }

    @NotNull
    private static File getTokenFile(@NotNull String tokenFileName, @NotNull BundleContext bundleContext) {
        File tokenFile = new File(tokenFileName);
        if (tokenFile.isAbsolute()) {
            return tokenFile;
        }
        tokenFile = bundleContext.getDataFile(tokenFileName);
        if (tokenFile == null) {
            String slingHome = bundleContext.getProperty("sling.home");
            tokenFile = slingHome != null ? new File(slingHome, tokenFileName) : new File(tokenFileName);
        }
        return tokenFile.getAbsoluteFile();
    }

    @ObjectClassDefinition(name="Apache Sling Token Update Configuration for OIDC Authentication Handler", description="Apache Sling Token Update Configuration for OIDC Authentication Handler")
    static @interface SlingLoginCookieManagerConfig {
        @AttributeDefinition(name="tokenFile", description="Token File")
        public String tokenFile() default "cookie-tokens.bin";

        @AttributeDefinition(name="form_token_fastseed", description="Form Token Fast Seed")
        public boolean form_token_fastseed() default false;

        @AttributeDefinition(name="sessionTimeout", description="Session Timeout")
        public long sessionTimeout() default 28800000L;

        @AttributeDefinition(name="cookieName", description="Cookie Name")
        public String cookieName() default "sling.oidcauth";
    }
}

