/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.pojo;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.springframework.util.ReflectionUtils;

public class DefaultMethodMeta {
    private final Map<Method, MethodHandle> defaultMethodHandles = new ConcurrentHashMapEx();
    private final Method privateLookupIn = ReflectionUtils.findMethod(MethodHandles.class, (String)"privateLookupIn", (Class[])new Class[]{Class.class, MethodHandles.Lookup.class});
    private Constructor<MethodHandles.Lookup> lookupConstructor;

    public MethodHandle getOrCreateMethodHandle(Object proxy, Method method) {
        return this.defaultMethodHandles.computeIfAbsent(method, key -> this.createMethodHandle(proxy, method));
    }

    protected MethodHandle createMethodHandle(Object proxy, Method method) {
        try {
            if (this.privateLookupIn != null) {
                return this.createForJava11(proxy, method);
            }
            return this.createForJava8(proxy, method);
        }
        catch (Exception e) {
            AsyncUtils.rethrow((Throwable)e);
            return null;
        }
    }

    protected MethodHandle createForJava11(Object proxy, Method method) throws Exception {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandles.Lookup privateLookup = (MethodHandles.Lookup)this.privateLookupIn.invoke(null, method.getDeclaringClass(), lookup);
        return privateLookup.unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy);
    }

    protected MethodHandle createForJava8(Object proxy, Method method) throws Exception {
        if (this.lookupConstructor == null) {
            this.lookupConstructor = ReflectionUtils.accessibleConstructor(MethodHandles.Lookup.class, (Class[])new Class[]{Class.class});
        }
        return this.lookupConstructor.newInstance(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy);
    }
}

