/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.Part;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.PartUtils;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientRequestParametersImpl
implements RestClientRequestParameters {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClientRequestParametersImpl.class);
    protected final MultiMap headers;
    protected Map<String, String> cookieMap;
    protected Map<String, Object> formMap;
    protected Multimap<String, Part> uploads;
    protected Buffer bodyBuffer;

    public RestClientRequestParametersImpl(@Nonnull MultiMap headers) {
        this.headers = headers;
    }

    @Override
    public Map<String, String> getCookieMap() {
        return this.cookieMap;
    }

    public void addCookie(String name, String value) {
        if (this.cookieMap == null) {
            this.cookieMap = new HashMap<String, String>();
        }
        this.cookieMap.put(name, value);
    }

    @Override
    public Map<String, Object> getFormMap() {
        return this.formMap;
    }

    public void addForm(String name, Object value) {
        if (this.formMap == null) {
            this.formMap = new HashMap<String, Object>();
        }
        if (value != null) {
            this.formMap.put(name, value);
        }
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public void putHeader(String name, String value) {
        this.headers.add(name, value);
    }

    @Override
    public Buffer getBodyBuffer() {
        return this.bodyBuffer;
    }

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
    }

    @Override
    public Multimap<String, Part> getUploads() {
        return this.uploads;
    }

    public void attach(String name, Object partOrList) {
        if (this.uploads == null) {
            this.uploads = ArrayListMultimap.create();
        }
        if (partOrList == null) {
            return;
        }
        if (partOrList.getClass().isArray()) {
            for (Object part : (Object[])partOrList) {
                this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, (Object)part));
            }
            return;
        }
        if (partOrList instanceof Collection) {
            for (Object part : (Collection)partOrList) {
                this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, part));
            }
            return;
        }
        this.uploads.put((Object)name, (Object)PartUtils.getSinglePart((String)name, (Object)partOrList));
    }
}

