/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.royale;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FilterWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.royale.compiler.codegen.js.goog.IJSGoogDocEmitter;
import org.apache.royale.compiler.codegen.js.royale.IJSRoyaleEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.constants.IASLanguageConstants;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.INamespaceDefinition;
import org.apache.royale.compiler.definitions.IPackageDefinition;
import org.apache.royale.compiler.definitions.IParameterDefinition;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.definitions.IVariableDefinition;
import org.apache.royale.compiler.definitions.metadata.IMetaTagAttribute;
import org.apache.royale.compiler.definitions.references.INamespaceResolvedReference;
import org.apache.royale.compiler.embedding.EmbedAttribute;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSessionModel;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitter;
import org.apache.royale.compiler.internal.codegen.js.goog.JSGoogEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.jx.AccessorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.AsIsEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BinaryOperatorEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.BindableEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ClassEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.DefinePropertyFunctionEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.FieldEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ForEachEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.FunctionCallEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.IdentifierEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.InterfaceEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.LiteralEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.MemberAccessEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.MethodEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.ObjectDefinePropertyEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.PackageFooterEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.PackageHeaderEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SelfReferenceEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.SuperCallEmitter;
import org.apache.royale.compiler.internal.codegen.js.jx.VarDeclarationEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleDocEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.utils.EmitterUtils;
import org.apache.royale.compiler.internal.codegen.mxml.royale.MXMLRoyaleEmitter;
import org.apache.royale.compiler.internal.definitions.AccessorDefinition;
import org.apache.royale.compiler.internal.definitions.ClassDefinition;
import org.apache.royale.compiler.internal.definitions.FunctionDefinition;
import org.apache.royale.compiler.internal.definitions.VariableDefinition;
import org.apache.royale.compiler.internal.embedding.EmbedData;
import org.apache.royale.compiler.internal.embedding.EmbedMIMEType;
import org.apache.royale.compiler.internal.projects.CompilerProject;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.scopes.FunctionScope;
import org.apache.royale.compiler.internal.scopes.PackageScope;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorIsNode;
import org.apache.royale.compiler.internal.tree.as.BinaryOperatorNodeBase;
import org.apache.royale.compiler.internal.tree.as.BlockNode;
import org.apache.royale.compiler.internal.tree.as.ChainedVariableNode;
import org.apache.royale.compiler.internal.tree.as.DynamicAccessNode;
import org.apache.royale.compiler.internal.tree.as.ExpressionNodeBase;
import org.apache.royale.compiler.internal.tree.as.FunctionNode;
import org.apache.royale.compiler.internal.tree.as.IdentifierNode;
import org.apache.royale.compiler.internal.tree.as.LabeledStatementNode;
import org.apache.royale.compiler.internal.tree.as.MemberAccessExpressionNode;
import org.apache.royale.compiler.internal.tree.as.NumericLiteralNode;
import org.apache.royale.compiler.internal.tree.as.TypedExpressionNode;
import org.apache.royale.compiler.problems.EmbedUnableToReadSourceProblem;
import org.apache.royale.compiler.problems.FilePrivateItemsWithMainVarWarningProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IAccessorNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IClassNode;
import org.apache.royale.compiler.tree.as.IContainerNode;
import org.apache.royale.compiler.tree.as.IDefaultXMLNamespaceNode;
import org.apache.royale.compiler.tree.as.IDefinitionNode;
import org.apache.royale.compiler.tree.as.IDynamicAccessNode;
import org.apache.royale.compiler.tree.as.IEmbedNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFileNode;
import org.apache.royale.compiler.tree.as.IForLoopNode;
import org.apache.royale.compiler.tree.as.IFunctionCallNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.tree.as.IFunctionObjectNode;
import org.apache.royale.compiler.tree.as.IGetterNode;
import org.apache.royale.compiler.tree.as.IIdentifierNode;
import org.apache.royale.compiler.tree.as.IInterfaceNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IMemberAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceAccessExpressionNode;
import org.apache.royale.compiler.tree.as.INamespaceDecorationNode;
import org.apache.royale.compiler.tree.as.INamespaceNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.compiler.tree.as.IScopedNode;
import org.apache.royale.compiler.tree.as.ISetterNode;
import org.apache.royale.compiler.tree.as.ITypedExpressionNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.compiler.tree.as.IUseNamespaceNode;
import org.apache.royale.compiler.tree.as.IVariableNode;
import org.apache.royale.compiler.utils.ASNodeUtils;
import org.apache.royale.compiler.utils.NativeUtils;
import org.apache.royale.utils.FilenameNormalization;

public class JSRoyaleEmitter
extends JSGoogEmitter
implements IJSRoyaleEmitter {
    private JSRoyaleDocEmitter docEmitter = null;
    private PackageHeaderEmitter packageHeaderEmitter;
    public PackageFooterEmitter packageFooterEmitter;
    private BindableEmitter bindableEmitter;
    private ClassEmitter classEmitter;
    private InterfaceEmitter interfaceEmitter;
    private FieldEmitter fieldEmitter;
    public VarDeclarationEmitter varDeclarationEmitter;
    public AccessorEmitter accessorEmitter;
    public MethodEmitter methodEmitter;
    private FunctionCallEmitter functionCallEmitter;
    private SuperCallEmitter superCallEmitter;
    private ForEachEmitter forEachEmitter;
    private MemberAccessEmitter memberAccessEmitter;
    private BinaryOperatorEmitter binaryOperatorEmitter;
    private IdentifierEmitter identifierEmitter;
    private LiteralEmitter literalEmitter;
    private AsIsEmitter asIsEmitter;
    private SelfReferenceEmitter selfReferenceEmitter;
    private ObjectDefinePropertyEmitter objectDefinePropertyEmitter;
    private DefinePropertyFunctionEmitter definePropertyFunctionEmitter;
    public ArrayList<String> usedNames = new ArrayList();
    public ArrayList<String> staticUsedNames = new ArrayList();
    private boolean needNamespace;
    private Set<IFunctionNode> emittingHoistedNodes = new HashSet<IFunctionNode>();
    public MXMLRoyaleEmitter mxmlEmitter = null;

    @Override
    public String postProcess(String output) {
        output = super.postProcess(output);
        String[] lines = output.split("\n");
        ArrayList<String> finalLines = new ArrayList<String>();
        boolean foundLanguage = false;
        boolean foundXML = false;
        boolean foundNamespace = false;
        boolean sawRequires = false;
        boolean stillSearching = true;
        int addIndex = -1;
        int provideIndex = -1;
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if (stillSearching) {
                int c;
                if (!(provideIndex != -1 && sawRequires || (c = line.indexOf(JSGoogEmitterTokens.GOOG_PROVIDE.getToken())) == -1)) {
                    provideIndex = addIndex = i + 1;
                }
                if ((c = line.indexOf(JSGoogEmitterTokens.GOOG_REQUIRE.getToken())) != -1) {
                    addIndex = -1;
                    int c2 = line.indexOf(")");
                    String s = line.substring(c + 14, c2 - 1);
                    if (s.equals(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken())) {
                        foundLanguage = true;
                    } else if (s.equals("XML")) {
                        foundXML = true;
                    } else if (s.equals("Namespace")) {
                        foundNamespace = true;
                    }
                    sawRequires = true;
                } else if (sawRequires || i == len - 1) {
                    stillSearching = false;
                    ICompilerProject project = this.getWalker().getProject();
                    if (project instanceof RoyaleJSProject) {
                        StringBuilder appendString;
                        boolean needXML;
                        RoyaleJSProject royaleProject = (RoyaleJSProject)project;
                        boolean needLanguage = this.getModel().needLanguage;
                        if (needLanguage && !foundLanguage) {
                            StringBuilder appendString2 = new StringBuilder();
                            appendString2.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString2.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString2.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString2.append(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken());
                            appendString2.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString2.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString2.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString2.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString2.toString());
                                this.addLineToMappings(i);
                            }
                        }
                        if ((needXML = royaleProject.needXML) && !foundXML) {
                            appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append("XML");
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString.toString());
                                this.addLineToMappings(i);
                            }
                        }
                        if (this.needNamespace && !foundNamespace) {
                            appendString = new StringBuilder();
                            appendString.append(JSGoogEmitterTokens.GOOG_REQUIRE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_OPEN.getToken());
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append("Namespace");
                            appendString.append(ASEmitterTokens.SINGLE_QUOTE.getToken());
                            appendString.append(ASEmitterTokens.PAREN_CLOSE.getToken());
                            appendString.append(ASEmitterTokens.SEMICOLON.getToken());
                            if (addIndex != -1) {
                                finalLines.add(addIndex, appendString.toString());
                                this.addLineToMappings(addIndex);
                            } else {
                                finalLines.add(appendString.toString());
                                this.addLineToMappings(i);
                            }
                        }
                    }
                }
            }
            finalLines.add(line);
        }
        if (this.staticUsedNames.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(JSGoogEmitterTokens.ROYALE_STATIC_DEPENDENCY_LIST.getToken());
            boolean firstDependency = true;
            for (String staticName : this.staticUsedNames) {
                if (!firstDependency) {
                    sb.append(",");
                }
                firstDependency = false;
                sb.append(staticName);
            }
            sb.append("*/");
            finalLines.add(provideIndex, sb.toString());
            this.addLineToMappings(provideIndex);
        }
        return Joiner.on("\n").join(finalLines);
    }

    public String formatGetter(String name) {
        String configPrefix;
        String prefix = JSRoyaleEmitterTokens.GETTER_PREFIX.getToken();
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        if (project.config != null && (configPrefix = project.config.getJsGetterPrefix()) != null && configPrefix.length() > 0) {
            prefix = configPrefix;
        }
        return prefix + name;
    }

    public String formatSetter(String name) {
        String configPrefix;
        String prefix = JSRoyaleEmitterTokens.SETTER_PREFIX.getToken();
        RoyaleJSProject project = (RoyaleJSProject)this.getWalker().getProject();
        if (project.config != null && (configPrefix = project.config.getJsSetterPrefix()) != null && configPrefix.length() > 0) {
            prefix = configPrefix;
        }
        return prefix + name;
    }

    public BindableEmitter getBindableEmitter() {
        return this.bindableEmitter;
    }

    public FieldEmitter getFieldEmitter() {
        return this.fieldEmitter;
    }

    public ClassEmitter getClassEmitter() {
        return this.classEmitter;
    }

    public AccessorEmitter getAccessorEmitter() {
        return this.accessorEmitter;
    }

    public PackageFooterEmitter getPackageFooterEmitter() {
        return this.packageFooterEmitter;
    }

    @Override
    public IJSGoogDocEmitter getDocEmitter() {
        if (this.docEmitter == null) {
            this.docEmitter = new JSRoyaleDocEmitter(this);
        }
        return this.docEmitter;
    }

    public JSRoyaleEmitter(FilterWriter out) {
        super(out);
        this.packageHeaderEmitter = new PackageHeaderEmitter(this);
        this.packageFooterEmitter = new PackageFooterEmitter(this);
        this.bindableEmitter = new BindableEmitter(this);
        this.classEmitter = new ClassEmitter(this);
        this.interfaceEmitter = new InterfaceEmitter(this);
        this.fieldEmitter = new FieldEmitter(this);
        this.varDeclarationEmitter = new VarDeclarationEmitter(this);
        this.accessorEmitter = new AccessorEmitter(this);
        this.methodEmitter = new MethodEmitter(this);
        this.functionCallEmitter = new FunctionCallEmitter(this);
        this.superCallEmitter = new SuperCallEmitter(this);
        this.forEachEmitter = new ForEachEmitter(this);
        this.memberAccessEmitter = new MemberAccessEmitter(this);
        this.binaryOperatorEmitter = new BinaryOperatorEmitter(this);
        this.identifierEmitter = new IdentifierEmitter(this);
        this.literalEmitter = new LiteralEmitter(this);
        this.asIsEmitter = new AsIsEmitter(this);
        this.selfReferenceEmitter = new SelfReferenceEmitter(this);
        this.objectDefinePropertyEmitter = new ObjectDefinePropertyEmitter(this);
        this.definePropertyFunctionEmitter = new DefinePropertyFunctionEmitter(this);
    }

    @Override
    protected void writeIndent() {
        this.write(JSRoyaleEmitterTokens.INDENT);
    }

    @Override
    protected String getIndent(int numIndent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numIndent; ++i) {
            sb.append(JSRoyaleEmitterTokens.INDENT.getToken());
        }
        return sb.toString();
    }

    @Override
    public void emitLocalNamedFunction(IFunctionNode node) {
        IFunctionNode parentFnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        if (parentFnNode == null || this.isEmittingHoistedNodes(parentFnNode).booleanValue()) {
            super.emitLocalNamedFunction(node);
        }
    }

    public Boolean isEmittingHoistedNodes(IFunctionNode node) {
        return this.emittingHoistedNodes.contains(node);
    }

    protected void setEmittingHoistedNodes(IFunctionNode node, boolean emit) {
        if (emit) {
            this.emittingHoistedNodes.add(node);
        } else {
            this.emittingHoistedNodes.remove(node);
        }
    }

    @Override
    public void emitFunctionBlockHeader(IFunctionNode node) {
        this.setEmittingHoistedNodes(node, true);
        super.emitFunctionBlockHeader(node);
        if (node.isConstructor()) {
            IClassNode cnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
            if (cnode.getDefinition().needsEventDispatcher(this.getWalker().getProject())) {
                if (this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS) {
                    this.bindableEmitter.emitBindableImplementsConstructorCode();
                } else if (this.getModel().getImplicitBindableImplementation() == JSSessionModel.ImplicitBindableImplementation.EXTENDS) {
                    this.bindableEmitter.emitBindableExtendsConstructorCode(cnode.getDefinition().getQualifiedName(), false);
                }
            }
            this.emitComplexInitializers(cnode);
        }
        this.emitHoistedFunctionsCodeBlock(node);
        if (!this.getModel().isExterns) {
            this.emitHoistedVariablesCodeBlock(node);
        }
        this.setEmittingHoistedNodes(node, false);
    }

    protected void emitHoistedFunctionsCodeBlock(IFunctionNode node) {
        if (!node.containsLocalFunctions()) {
            return;
        }
        List localFns = node.getLocalFunctions();
        int n = localFns.size();
        for (int i = 0; i < n; ++i) {
            IFunctionNode localFn = (IFunctionNode)localFns.get(i);
            if (localFn.getName().length() <= 0) continue;
            this.getWalker().walk((IASNode)localFn);
            this.write(ASEmitterTokens.SEMICOLON);
            this.writeNewline();
        }
    }

    protected void emitHoistedVariablesCodeBlock(IFunctionNode node) {
        boolean defaultInitializers = false;
        ICompilerProject project = this.getWalker().getProject();
        if (project instanceof RoyaleJSProject) {
            RoyaleJSProject fjsProject = (RoyaleJSProject)project;
            if (fjsProject.config != null) {
                defaultInitializers = fjsProject.config.getJsDefaultInitializers();
            }
        }
        Collection localDefs = node.getScopedNode().getScope().getAllLocalDefinitions();
        for (IDefinition localDef : localDefs) {
            IVariableDefinition varDef;
            IVariableNode varNode;
            if (!(localDef instanceof IVariableDefinition) || (varNode = (varDef = (IVariableDefinition)localDef).getVariableNode()) == null || varNode instanceof ChainedVariableNode) continue;
            if (EmitterUtils.needsDefaultValue(varNode, defaultInitializers, this.getWalker().getProject())) {
                this.emitVarDeclaration(varNode);
                this.write(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
                continue;
            }
            int len = varNode.getChildCount();
            for (int i = 0; i < len; ++i) {
                ChainedVariableNode childVarNode;
                IASNode child = varNode.getChild(i);
                if (!(child instanceof ChainedVariableNode) || !EmitterUtils.needsDefaultValue((IVariableNode)(childVarNode = (ChainedVariableNode)child), defaultInitializers, this.getWalker().getProject())) continue;
                this.writeToken(ASEmitterTokens.VAR);
                this.emitVarDeclaration((IVariableNode)childVarNode);
                this.write(ASEmitterTokens.SEMICOLON);
                this.writeNewline();
            }
        }
    }

    @Override
    public void emitFunctionObject(IFunctionObjectNode node) {
        IFunctionNode parentFnNode = (IFunctionNode)node.getAncestorOfType(IFunctionNode.class);
        FunctionNode localFnNode = node.getFunctionNode();
        if (parentFnNode == null || this.isEmittingHoistedNodes(parentFnNode).booleanValue()) {
            super.emitFunctionObject(node);
        } else if (localFnNode.getName().length() == 0) {
            super.emitFunctionObject(node);
        } else {
            List localFns = parentFnNode.getLocalFunctions();
            int i = localFns.indexOf(node.getFunctionNode());
            if (i < 0) {
                System.out.println("missing index for " + node.toString());
            } else {
                IFunctionNode localFn = (IFunctionNode)localFns.get(i);
                IExpressionNode idNode = localFn.getNameExpressionNode();
                String fnName = "";
                if (idNode != null && idNode.getNodeID() == ASTNodeID.IdentifierID) {
                    fnName = ((IdentifierNode)idNode).getName();
                }
                if (!fnName.isEmpty()) {
                    this.write(((IdentifierNode)idNode).getName());
                } else {
                    this.write("__localFn" + Integer.toString(i) + "__");
                }
            }
        }
    }

    @Override
    public void emitNamespace(INamespaceNode node) {
        IExpressionNode uriNode;
        this.needNamespace = true;
        if (node.getContainingScope().getScope() instanceof PackageScope) {
            this.startMapping((ISourceLocation)node);
            this.write(this.formatQualifiedName(node.getQualifiedName()));
            this.endMapping((ISourceLocation)node);
        } else if (node.getContainingScope().getScope() instanceof FunctionScope) {
            this.writeToken(ASEmitterTokens.VAR);
            this.write("/** @type {Namespace} */");
            this.startMapping((ISourceLocation)node);
            this.write(node.getName());
            this.endMapping((ISourceLocation)node);
        } else if (!(node.getDefinition().getParent() instanceof IClassDefinition)) {
            this.startMapping((ISourceLocation)node);
            this.write(node.getQualifiedName());
            this.endMapping((ISourceLocation)node);
        } else {
            this.write(node.getDefinition().getParent().getQualifiedName());
            this.write(ASEmitterTokens.MEMBER_ACCESS);
            this.startMapping((ISourceLocation)node);
            this.write(node.getName());
            this.endMapping((ISourceLocation)node);
        }
        this.write(ASEmitterTokens.SPACE);
        this.writeToken(ASEmitterTokens.EQUAL);
        this.writeToken(ASEmitterTokens.NEW);
        this.startMapping((ISourceLocation)node);
        this.write("Namespace");
        this.endMapping((ISourceLocation)node);
        this.write(ASEmitterTokens.PAREN_OPEN);
        if (!this.staticUsedNames.contains("Namespace")) {
            this.staticUsedNames.add("Namespace");
        }
        if ((uriNode = node.getNamespaceURINode()) == null) {
            this.startMapping((ISourceLocation)node);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(node.getName());
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.endMapping((ISourceLocation)node);
        } else {
            this.getWalker().walk((IASNode)uriNode);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    @Override
    public void emitUseNamespace(IUseNamespaceNode node) {
        this.write("//use namespace ");
        this.getWalker().walk((IASNode)node.getTargetNamespaceNode());
    }

    public boolean isCustomNamespace(FunctionNode node) {
        String nsName;
        INamespaceDecorationNode ns = node.getActualNamespaceNode();
        return ns != null && (nsName = node.getNamespace()) != "private" && nsName != "protected" && nsName != "internal" && nsName != "http://adobe.com/AS3/2006/builtin" && nsName != "public";
    }

    public boolean isCustomNamespace(FunctionDefinition def) {
        INamespaceDefinition nsDef = def.getNamespaceReference().resolveNamespaceReference(this.getWalker().getProject());
        String uri = nsDef.getURI();
        return !def.getNamespaceReference().isLanguageNamespace() && !uri.equals("http://adobe.com/AS3/2006/builtin") && !nsDef.getBaseName().equals(ASEmitterTokens.PRIVATE.getToken());
    }

    @Override
    public void emitMemberName(IDefinitionNode node) {
        FunctionNode fn;
        ICompilerProject project = this.getWalker().getProject();
        if (node.getNodeID() == ASTNodeID.FunctionID && this.isCustomNamespace(fn = (FunctionNode)node)) {
            INamespaceDecorationNode ns = ((FunctionNode)node).getActualNamespaceNode();
            INamespaceDefinition nsDef = (INamespaceDefinition)ns.resolve(project);
            this.formatQualifiedName(nsDef.getQualifiedName());
            String s = nsDef.getURI();
            this.write(JSRoyaleEmitter.formatNamespacedProperty(s, node.getName(), true));
            return;
        }
        String qname = node.getName();
        IDefinition nodeDef = node.getDefinition();
        if (nodeDef != null && !nodeDef.isStatic() && nodeDef.isPrivate() && project.getAllowPrivateNameConflicts()) {
            qname = this.formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
        }
        this.write(qname);
    }

    public static String formatNamespacedProperty(String s, String propName, boolean access) {
        s = s.replace(":", "_");
        s = s.replace(".", "_");
        s = s.replace("/", "$");
        s = s + "__" + propName;
        if (access) {
            s = ASEmitterTokens.MEMBER_ACCESS.getToken() + s;
        }
        return s;
    }

    @Override
    public String formatQualifiedName(String name) {
        return this.formatQualifiedName(name, false);
    }

    public String formatQualifiedName(String name, boolean isDoc) {
        if (this.mxmlEmitter != null) {
            name = this.mxmlEmitter.formatQualifiedName(name);
        }
        if (this.getModel().isInternalClass(name)) {
            return this.getModel().getInternalClasses().get(name);
        }
        if (NativeUtils.isJSNative(name)) {
            return name;
        }
        if (name.startsWith("window.")) {
            name = name.substring(7);
        } else if (!isDoc) {
            if (!(!this.getModel().inStaticInitializer || this.staticUsedNames.contains(name) || NativeUtils.isJSNative(name) || !this.isGoogProvided(name) || this.getModel().getCurrentClass() != null && this.getModel().getCurrentClass().getQualifiedName().equals(name) || this.getModel().primaryDefinitionQName != null && this.getModel().primaryDefinitionQName.equals(name))) {
                this.staticUsedNames.add(name);
            }
            if (!this.usedNames.contains(name) && this.isGoogProvided(name)) {
                this.usedNames.add(name);
            }
        }
        return name;
    }

    public String convertASTypeToJS(String name) {
        String result = name;
        if (name.equals("")) {
            result = "Object";
        } else if (name.equals("Class")) {
            result = "Object";
        } else if (name.equals("int") || name.equals("uint")) {
            result = "Number";
        } else if (name.equals("Vector") || name.equals("__AS3__.vec.Vector")) {
            result = JSRoyaleEmitterTokens.VECTOR.getToken();
        }
        return result;
    }

    @Override
    public void emitPackageHeader(IPackageDefinition definition) {
        IPackageNode packageNode = definition.getNode();
        IFileNode fileNode = (IFileNode)packageNode.getAncestorOfType(IFileNode.class);
        int nodeCount = fileNode.getChildCount();
        String mainClassName = null;
        Boolean mainClassNameisVar = false;
        IASNode firstInternalContent = null;
        block0: for (int i = 0; i < nodeCount; ++i) {
            String className;
            IASNode pnode = fileNode.getChild(i);
            if (pnode instanceof IPackageNode) {
                IScopedNode snode = ((IPackageNode)pnode).getScopedNode();
                int snodeCount = snode.getChildCount();
                for (int j = 0; j < snodeCount; ++j) {
                    IASNode cnode = snode.getChild(j);
                    if (cnode instanceof IClassNode) {
                        mainClassName = ((IClassNode)cnode).getQualifiedName();
                        continue block0;
                    }
                    if (cnode instanceof IFunctionNode) {
                        mainClassName = ((IFunctionNode)cnode).getQualifiedName();
                        continue block0;
                    }
                    if (cnode instanceof INamespaceNode) {
                        mainClassName = ((INamespaceNode)cnode).getQualifiedName();
                        continue block0;
                    }
                    if (!(cnode instanceof IVariableNode)) continue;
                    mainClassName = ((IVariableNode)cnode).getQualifiedName();
                    mainClassNameisVar = true;
                    continue block0;
                }
                continue;
            }
            if (pnode instanceof IClassNode) {
                className = ((IClassNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                if (firstInternalContent != null) continue;
                firstInternalContent = pnode;
                continue;
            }
            if (pnode instanceof IInterfaceNode) {
                className = ((IInterfaceNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                if (firstInternalContent != null) continue;
                firstInternalContent = pnode;
                continue;
            }
            if (pnode instanceof IFunctionNode) {
                className = ((IFunctionNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                if (firstInternalContent != null) continue;
                firstInternalContent = pnode;
                continue;
            }
            if (pnode instanceof INamespaceNode) {
                className = ((INamespaceNode)pnode).getQualifiedName();
                this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
                if (firstInternalContent != null) continue;
                firstInternalContent = pnode;
                continue;
            }
            if (!(pnode instanceof IVariableNode)) continue;
            className = ((IVariableNode)pnode).getQualifiedName();
            this.getModel().getInternalClasses().put(className, mainClassName + "." + className);
            if (firstInternalContent != null) continue;
            firstInternalContent = pnode;
        }
        if (mainClassNameisVar.booleanValue() && firstInternalContent != null) {
            this.getProblems().add((ICompilerProblem)new FilePrivateItemsWithMainVarWarningProblem(firstInternalContent));
        }
        this.packageHeaderEmitter.emit(definition);
    }

    @Override
    public void emitPackageHeaderContents(IPackageDefinition definition) {
        this.packageHeaderEmitter.emitContents(definition);
        this.usedNames.clear();
    }

    @Override
    public void emitPackageFooter(IPackageDefinition definition) {
        this.packageFooterEmitter.emit(definition);
    }

    @Override
    public void emitClass(IClassNode node) {
        this.classEmitter.emit(node);
    }

    @Override
    public void emitInterface(IInterfaceNode node) {
        this.interfaceEmitter.emit(node);
    }

    @Override
    public void emitField(IVariableNode node) {
        this.fieldEmitter.emit(node);
    }

    @Override
    public void emitVarDeclaration(IVariableNode node) {
        this.varDeclarationEmitter.emit(node);
    }

    @Override
    public void emitAccessors(IAccessorNode node) {
        this.accessorEmitter.emit(node);
    }

    @Override
    public void emitGetAccessor(IGetterNode node) {
        this.accessorEmitter.emitGet(node);
    }

    @Override
    public void emitSetAccessor(ISetterNode node) {
        this.accessorEmitter.emitSet(node);
    }

    @Override
    public void emitMethod(IFunctionNode node) {
        this.methodEmitter.emit(node);
    }

    public void emitComplexInitializers(IClassNode node) {
        this.classEmitter.emitComplexInitializers(node);
    }

    @Override
    public void emitFunctionCall(IFunctionCallNode node) {
        this.functionCallEmitter.emit(node);
    }

    @Override
    public void emitForEachLoop(IForLoopNode node) {
        this.forEachEmitter.emit(node);
    }

    @Override
    public void emitSuperCall(IASNode node, String type) {
        this.superCallEmitter.emit(node, type);
    }

    @Override
    public void emitMemberAccessExpression(IMemberAccessExpressionNode node) {
        this.memberAccessEmitter.emit(node);
    }

    @Override
    public void emitArguments(IContainerNode node) {
        IDefinition def;
        IExpressionNode nameNode;
        IFunctionCallNode fcNode;
        ICompilerProject project;
        IContainerNode newNode = node;
        int len = node.getChildCount();
        if (len == 2) {
            project = this.getWalker().getProject();
            fcNode = (IFunctionCallNode)node.getParent();
            nameNode = fcNode.getNameNode();
            def = nameNode.resolve(project);
            if (def != null && def.getBaseName().equals("insertAt") && def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && nameNode instanceof MemberAccessExpressionNode) {
                newNode = EmitterUtils.insertArgumentsAt(node, 1, new IASNode[]{new NumericLiteralNode("0")});
            }
        }
        if (len == 1) {
            IDefinition parentDef;
            project = this.getWalker().getProject();
            fcNode = (IFunctionCallNode)node.getParent();
            nameNode = fcNode.getNameNode();
            def = nameNode.resolve(project);
            if (def != null && def.getBaseName().equals("removeAt")) {
                if (def.getParent() != null && def.getParent().getQualifiedName().equals("Array") && nameNode instanceof MemberAccessExpressionNode) {
                    newNode = EmitterUtils.insertArgumentsAfter(node, new IASNode[]{new NumericLiteralNode("1")});
                }
            } else if (def != null && def.getBaseName().equals("parseInt") && (parentDef = def.getParent()) == null && nameNode instanceof IdentifierNode) {
                NumericLiteralNode appendedArgument = new NumericLiteralNode("0");
                appendedArgument.setSynthetic(true);
                newNode = EmitterUtils.insertArgumentsAfter(node, new IASNode[]{appendedArgument});
            }
        }
        super.emitArguments(newNode);
    }

    @Override
    public void emitE4XFilter(IMemberAccessExpressionNode node) {
        this.getWalker().walk((IASNode)node.getLeftOperandNode());
        this.getModel().inE4xFilter = true;
        String s = this.stringifyNode((IASNode)node.getRightOperandNode());
        if (s.startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.contains("this")) {
            this.write(".filter((function(/** @type {XML} */ node){return (");
            this.write(s);
            this.write(")})");
            this.write(".bind(this))");
        } else {
            this.write(".filter(function(/** @type {XML} */ node){return (");
            this.write(s);
            this.write(")})");
        }
        this.getModel().inE4xFilter = false;
    }

    @Override
    public void emitE4XDefaultNamespaceDirective(IDefaultXMLNamespaceNode node) {
        this.write("// e4x default namespace active: ");
        this.getWalker().walk((IASNode)node.getKeywordNode());
        this.write(" = ");
        this.getWalker().walk((IASNode)node.getExpressionNode());
        if (node.getContainingScope().getScope() instanceof FunctionScope) {
            this.getModel().registerDefaultXMLNamespace((FunctionScope)node.getContainingScope().getScope(), node.getExpressionNode());
        }
    }

    @Override
    public void emitBinaryOperator(IBinaryOperatorNode node) {
        this.binaryOperatorEmitter.emit(node);
    }

    @Override
    public void emitIdentifier(IIdentifierNode node) {
        this.identifierEmitter.emit(node);
    }

    @Override
    public void emitLiteral(ILiteralNode node) {
        this.literalEmitter.emit(node);
    }

    @Override
    public void emitEmbed(IEmbedNode node) {
        EmbedData data = new EmbedData(node.getParent().getSourcePath(), null);
        boolean hadError = false;
        for (IMetaTagAttribute attribute : node.getAttributes()) {
            String key = attribute.getKey();
            String value = attribute.getValue();
            if (!data.addAttribute((ICompilerProject)((CompilerProject)this.project), (ISourceLocation)node.getParent(), key, value, this.getProblems())) continue;
            hadError = true;
        }
        if (hadError) {
            this.write("");
            return;
        }
        String source = (String)data.getAttribute(EmbedAttribute.SOURCE);
        EmbedMIMEType mimeType = (EmbedMIMEType)data.getAttribute(EmbedAttribute.MIME_TYPE);
        if (mimeType != null && mimeType.toString().equals(EmbedMIMEType.TEXT.toString()) && source != null) {
            File file = new File(FilenameNormalization.normalize((String)source));
            try {
                String newlineReplacement = "\\\\n";
                String s = FileUtils.readFileToString(file);
                s = s.replaceAll("\n", "__NEWLINE_PLACEHOLDER__");
                s = s.replaceAll("\r", "__CR_PLACEHOLDER__");
                s = s.replaceAll("\t", "__TAB_PLACEHOLDER__");
                s = s.replaceAll("\f", "__FORMFEED_PLACEHOLDER__");
                s = s.replaceAll("\b", "__BACKSPACE_PLACEHOLDER__");
                s = s.replaceAll("\\\\", "__ESCAPE_PLACEHOLDER__");
                s = s.replaceAll("\\\\\"", "__QUOTE_PLACEHOLDER__");
                s = s.replaceAll("\"", "\\\\\"");
                s = s.replaceAll("__QUOTE_PLACEHOLDER__", "\\\\\"");
                s = s.replaceAll("__ESCAPE_PLACEHOLDER__", "\\\\\\\\");
                s = s.replaceAll("__BACKSPACE_PLACEHOLDER__", "\\\\b");
                s = s.replaceAll("__FORMFEED_PLACEHOLDER__", "\\\\f");
                s = s.replaceAll("__TAB_PLACEHOLDER__", "\\\\t");
                s = s.replaceAll("__CR_PLACEHOLDER__", "\\\\r");
                s = s.replaceAll("__NEWLINE_PLACEHOLDER__", newlineReplacement);
                this.write("\"" + s + "\"");
            }
            catch (IOException e) {
                this.getProblems().add((ICompilerProblem)new EmbedUnableToReadSourceProblem((Exception)e, file.getPath()));
            }
        }
    }

    public void emitIsAs(IExpressionNode node, IExpressionNode left, IExpressionNode right, ASTNodeID id, boolean coercion) {
        this.asIsEmitter.emitIsAs(node, left, right, id, coercion);
    }

    @Override
    protected void emitSelfReference(IFunctionNode node) {
        this.selfReferenceEmitter.emit(node);
    }

    @Override
    protected void emitObjectDefineProperty(IAccessorNode node) {
        this.objectDefinePropertyEmitter.emit(node);
    }

    @Override
    public void emitDefinePropertyFunction(IAccessorNode node) {
        this.definePropertyFunctionEmitter.emit(node);
    }

    public String stringifyDefineProperties(IClassDefinition cdef) {
        this.setBufferWrite(true);
        this.accessorEmitter.emit(cdef);
        String result = this.getBuilder().toString();
        this.getBuilder().setLength(0);
        this.setBufferWrite(false);
        return result;
    }

    @Override
    public void emitClosureStart() {
        if (this.getDocEmitter() instanceof JSRoyaleDocEmitter && ((JSRoyaleDocEmitter)this.getDocEmitter()).getSuppressClosure().booleanValue()) {
            return;
        }
        ICompilerProject project = this.getWalker().getProject();
        if (project instanceof RoyaleJSProject) {
            ((RoyaleJSProject)project).needLanguage = true;
        }
        this.getModel().needLanguage = true;
        this.write(JSRoyaleEmitterTokens.CLOSURE_FUNCTION_NAME);
        this.write(ASEmitterTokens.PAREN_OPEN);
    }

    @Override
    public void emitClosureEnd(IASNode node, IDefinition nodeDef) {
        if (this.getDocEmitter() instanceof JSRoyaleDocEmitter && ((JSRoyaleDocEmitter)this.getDocEmitter()).getSuppressClosure().booleanValue()) {
            return;
        }
        this.write(ASEmitterTokens.COMMA);
        this.write(ASEmitterTokens.SPACE);
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        IIdentifierNode identifierNode = null;
        if (node.getNodeID() == ASTNodeID.IdentifierID) {
            identifierNode = (IIdentifierNode)node;
        } else if (node.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            identifierNode = this.getChainedIdentifierNode(node);
        }
        if (identifierNode == null) {
            System.out.println("unexpected node in emitClosureEnd");
        } else {
            if (!node.equals(identifierNode)) {
                nodeDef = identifierNode.resolve(this.getWalker().getProject());
            }
            if (nodeDef instanceof FunctionDefinition && this.isCustomNamespace((FunctionDefinition)nodeDef)) {
                String ns = ((INamespaceResolvedReference)((FunctionDefinition)nodeDef).getNamespaceReference()).resolveAETNamespace(this.getWalker().getProject()).getName();
                this.write(ns + "::");
            }
            String qname = nodeDef.getBaseName();
            if (nodeDef != null && !nodeDef.isStatic() && !(nodeDef instanceof IParameterDefinition) && nodeDef.isPrivate() && this.getWalker().getProject().getAllowPrivateNameConflicts()) {
                qname = this.formatPrivateName(nodeDef.getParent().getQualifiedName(), qname);
            }
            this.write(qname);
        }
        this.write(ASEmitterTokens.SINGLE_QUOTE);
        this.write(ASEmitterTokens.PAREN_CLOSE);
    }

    @Override
    public void emitStatement(IASNode node) {
        IFunctionNode fnode;
        if (node instanceof IFunctionNode && (fnode = (IFunctionNode)node).getName().length() > 0) {
            return;
        }
        super.emitStatement(node);
    }

    private IIdentifierNode getChainedIdentifierNode(IASNode node) {
        while (node.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            node = ((IMemberAccessExpressionNode)node).getRightOperandNode();
        }
        if (node.getNodeID() == ASTNodeID.IdentifierID) {
            return (IIdentifierNode)node;
        }
        return null;
    }

    @Override
    public void emitUnaryOperator(IUnaryOperatorNode node) {
        if (node.getNodeID() == ASTNodeID.Op_DeleteID) {
            MemberAccessExpressionNode obj;
            if (node.getChild(0).getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                if (node.getChild(0).getChild(0).getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    MemberAccessExpressionNode obj2 = (MemberAccessExpressionNode)node.getChild(0).getChild(0);
                    if (this.isXMLList((IMemberAccessExpressionNode)obj2)) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk((IASNode)obj2);
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".removeChildAt(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                } else if (node.getChild(0).getChild(0).getNodeID() == ASTNodeID.IdentifierID) {
                    if (this.isXMLish((IExpressionNode)((IdentifierNode)node.getChild(0).getChild(0)))) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk(node.getChild(0).getChild(0));
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".removeChild(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                    if (this.isProxy((IExpressionNode)((IdentifierNode)node.getChild(0).getChild(0)))) {
                        if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_OPEN);
                        }
                        this.getWalker().walk(node.getChild(0).getChild(0));
                        DynamicAccessNode dan = (DynamicAccessNode)node.getChild(0);
                        IASNode indexNode = dan.getChild(1);
                        this.write(".deleteProperty(");
                        this.getWalker().walk(indexNode);
                        this.write(")");
                        if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                            this.write(ASEmitterTokens.PAREN_CLOSE);
                        }
                        return;
                    }
                }
            } else if (node.getChild(0).getNodeID() == ASTNodeID.MemberAccessExpressionID && this.isXMLList((IMemberAccessExpressionNode)(obj = (MemberAccessExpressionNode)node.getChild(0)))) {
                if (ASNodeUtils.hasParenOpen((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_OPEN);
                }
                IExpressionNode rightNode = obj.getRightOperandNode();
                String s = this.stringifyNode((IASNode)obj.getLeftOperandNode());
                boolean avoidMethodAccess = rightNode instanceof IDynamicAccessNode && ((IDynamicAccessNode)rightNode).getLeftOperandNode().getNodeID() == ASTNodeID.Op_AtID;
                boolean needsQuotes = rightNode.getNodeID() != ASTNodeID.Op_AtID && !avoidMethodAccess;
                this.write(s);
                this.write(".removeChild(");
                if (needsQuotes) {
                    this.write("'");
                } else if (!avoidMethodAccess) {
                    this.write(s + ".");
                }
                s = this.stringifyNode((IASNode)rightNode);
                this.write(s);
                if (needsQuotes) {
                    this.write("'");
                }
                this.write(")");
                if (ASNodeUtils.hasParenClose((IOperatorNode)node)) {
                    this.write(ASEmitterTokens.PAREN_CLOSE);
                }
                return;
            }
        } else if (node.getNodeID() == ASTNodeID.Op_AtID) {
            IExpressionNode op = node.getOperandNode();
            if (op != null) {
                if (EmitterUtils.writeE4xFilterNode(this.getWalker().getProject(), this.getModel(), (IExpressionNode)node)) {
                    this.write("node.");
                }
                this.write("attribute(");
                if (op instanceof INamespaceAccessExpressionNode) {
                    this.write("XML.createAttributeQName(");
                    this.write("new QName(");
                    this.getWalker().walk((IASNode)((INamespaceAccessExpressionNode)op).getLeftOperandNode());
                    this.write(",'");
                    this.getWalker().walk((IASNode)((INamespaceAccessExpressionNode)op).getRightOperandNode());
                    this.write("')");
                    this.write(")");
                } else if (this.getModel().defaultXMLNamespaceActive.booleanValue() && op instanceof IIdentifierNode && node.getContainingScope().getScope() instanceof FunctionScope && this.getModel().getDefaultXMLNamespace((FunctionScope)node.getContainingScope().getScope()) != null) {
                    this.write("XML.swfCompatibleQuery(");
                    this.write("new QName(");
                    this.getWalker().walk((IASNode)this.getModel().getDefaultXMLNamespace((FunctionScope)node.getContainingScope().getScope()));
                    this.write(",'");
                    this.getWalker().walk((IASNode)node.getOperandNode());
                    this.write("')");
                    this.write(", true");
                    this.write(")");
                } else {
                    this.write("'");
                    this.getWalker().walk((IASNode)node.getOperandNode());
                    this.write("'");
                }
                this.write(")");
            } else if (node.getParent().getNodeID() == ASTNodeID.ArrayIndexExpressionID) {
                DynamicAccessNode parentNode = (DynamicAccessNode)node.getParent();
                if (EmitterUtils.writeE4xFilterNode(this.getWalker().getProject(), this.getModel(), (IExpressionNode)node)) {
                    this.write("node.");
                }
                if (node.getParent().getParent() != null && node.getParent().getParent().getParent() != null && node.getParent().getParent().getParent().getNodeID() == ASTNodeID.Op_DeleteID) {
                    this.write("'@' + ");
                    this.getWalker().walk((IASNode)parentNode.getRightOperandNode());
                    return;
                }
                this.write("attribute(");
                this.getWalker().walk((IASNode)parentNode.getRightOperandNode());
                this.write(")");
            }
            return;
        }
        super.emitUnaryOperator(node);
    }

    public boolean isXMLList(IMemberAccessExpressionNode obj) {
        return EmitterUtils.isXMLList(obj, this.getWalker().getProject());
    }

    public boolean isLeftNodeXMLish(IExpressionNode leftNode) {
        return EmitterUtils.isLeftNodeXMLish(leftNode, this.getWalker().getProject());
    }

    public boolean isProxy(IExpressionNode obj) {
        RoyaleProject project = (RoyaleProject)this.getWalker().getProject();
        ITypeDefinition leftDef = obj.resolveType((ICompilerProject)project);
        if (leftDef == null) {
            if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                IExpressionNode leftNode = ((MemberAccessExpressionNode)obj).getLeftOperandNode();
                leftDef = leftNode.resolveType((ICompilerProject)project);
                if (leftDef != null && leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project)) {
                    return true;
                }
                while (leftNode.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
                    leftDef = (leftNode = ((MemberAccessExpressionNode)leftNode).getLeftOperandNode()).resolveType((ICompilerProject)project);
                    if (leftDef == null || !leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project)) continue;
                    return true;
                }
            }
            return false;
        }
        return leftDef.isInstanceOf(project.getProxyBaseClass(), (ICompilerProject)project);
    }

    public boolean isDateProperty(IExpressionNode obj, boolean writeAccess) {
        RoyaleProject project = (RoyaleProject)this.getWalker().getProject();
        if (obj.getNodeID() == ASTNodeID.MemberAccessExpressionID) {
            IExpressionNode leftNode = ((MemberAccessExpressionNode)obj).getLeftOperandNode();
            IExpressionNode rightNode = ((MemberAccessExpressionNode)obj).getRightOperandNode();
            ITypeDefinition leftDef = leftNode.resolveType((ICompilerProject)project);
            IDefinition rightDef = rightNode.resolve((ICompilerProject)project);
            if (leftDef != null && leftDef.getQualifiedName().equals("Date")) {
                BinaryOperatorEmitter.DatePropertiesGetters propGetter;
                BinaryOperatorEmitter.DatePropertiesSetters propSetter;
                if (rightDef instanceof AccessorDefinition) {
                    return true;
                }
                if (rightDef instanceof VariableDefinition) {
                    return true;
                }
                if (rightDef == null && rightNode.getNodeID() == ASTNodeID.IdentifierID && (writeAccess ? (propSetter = BinaryOperatorEmitter.DatePropertiesSetters.valueOf(((IIdentifierNode)rightNode).getName().toUpperCase())) != null : (propGetter = BinaryOperatorEmitter.DatePropertiesGetters.valueOf(((IIdentifierNode)rightNode).getName().toUpperCase())) != null)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isXMLish(IExpressionNode obj) {
        return EmitterUtils.isXMLish(obj, this.getWalker().getProject());
    }

    public MemberAccessExpressionNode getLastMAEInChain(MemberAccessExpressionNode node) {
        while (node.getRightOperandNode() instanceof MemberAccessExpressionNode) {
            node = (MemberAccessExpressionNode)node.getRightOperandNode();
        }
        return node;
    }

    @Override
    public void emitLabelStatement(LabeledStatementNode node) {
        BlockNode innerBlock = node.getLabeledStatement();
        if (innerBlock.getChildCount() == 1 && innerBlock.getChild(0).getNodeID() == ASTNodeID.ForEachLoopID) {
            this.getWalker().walk((IASNode)node.getLabeledStatement());
            return;
        }
        super.emitLabelStatement(node);
    }

    @Override
    public void emitTypedExpression(ITypedExpressionNode node) {
        ICompilerProject project = this.getWalker().getProject();
        if (project instanceof RoyaleJSProject) {
            String vectorClassName;
            String string = vectorClassName = ((RoyaleJSProject)project).config == null ? null : ((RoyaleJSProject)project).config.getJsVectorEmulationClass();
            if (vectorClassName != null) {
                if (!vectorClassName.equals("Array")) {
                    this.write(vectorClassName);
                }
                return;
            }
        }
        Boolean written = false;
        if (node instanceof TypedExpressionNode) {
            this.startMapping((ISourceLocation)node);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(JSRoyaleEmitterTokens.SYNTH_VECTOR);
            this.write(ASEmitterTokens.PAREN_OPEN);
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(this.formatQualifiedName(node.getTypeNode().resolve(project).getQualifiedName()));
            this.write(ASEmitterTokens.SINGLE_QUOTE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.write(ASEmitterTokens.PAREN_CLOSE);
            this.endMapping((ISourceLocation)node);
            written = true;
        }
        if (!written.booleanValue()) {
            this.write(JSRoyaleEmitterTokens.VECTOR);
        }
        if (this.getModel().inStaticInitializer && !this.staticUsedNames.contains(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken())) {
            this.staticUsedNames.add(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken());
        }
        if (project instanceof RoyaleJSProject) {
            ((RoyaleJSProject)project).needLanguage = true;
        }
        this.getModel().needLanguage = true;
    }

    @Override
    public void emitAssignmentCoercion(IExpressionNode assignedNode, IDefinition definition) {
        super.emitAssignmentCoercion(assignedNode, definition);
        if (this.getModel().inStaticInitializer && !this.staticUsedNames.contains(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken())) {
            this.staticUsedNames.add(JSRoyaleEmitterTokens.LANGUAGE_QNAME.getToken());
        }
    }

    @Override
    public void emitNamespaceAccessExpression(INamespaceAccessExpressionNode node) {
        this.getWalker().walk((IASNode)node.getRightOperandNode());
    }

    boolean isGoogProvided(String className) {
        ICompilerProject project = this.getWalker().getProject();
        return ((RoyaleJSProject)project).isGoogProvided(className);
    }

    public void processBindableSupport(IClassDefinition type, ArrayList<String> requiresList) {
        ICompilerProject royaleProject = this.getWalker().getProject();
        boolean needsBindableSupport = type.needsEventDispatcher(royaleProject);
        if (needsBindableSupport) {
            IClassDefinition bindableClassDef = type;
            ClassDefinition objectClassDefinition = (ClassDefinition)royaleProject.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT);
            if (bindableClassDef.resolveBaseClass(royaleProject).equals(objectClassDefinition)) {
                this.getModel().registerImplicitBindableImplementation(bindableClassDef, JSSessionModel.ImplicitBindableImplementation.EXTENDS);
                if (!requiresList.contains(this.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME))) {
                    requiresList.add(this.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME));
                }
            } else {
                this.getModel().registerImplicitBindableImplementation(bindableClassDef, JSSessionModel.ImplicitBindableImplementation.IMPLEMENTS);
                if (!requiresList.contains(this.formatQualifiedName(BindableEmitter.DISPATCHER_INTERFACE_QNAME))) {
                    requiresList.add(this.formatQualifiedName(BindableEmitter.DISPATCHER_INTERFACE_QNAME));
                }
                if (!requiresList.contains(this.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME))) {
                    requiresList.add(this.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME));
                }
            }
        }
        if (!needsBindableSupport && (needsBindableSupport = type.needsStaticEventDispatcher(royaleProject)) && !requiresList.contains(this.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME))) {
            requiresList.add(this.formatQualifiedName(BindableEmitter.DISPATCHER_CLASS_QNAME));
        }
    }

    @Override
    public BinaryOperatorNodeBase getGeneratedTypeCheck(ExpressionNodeBase leftOperand, ExpressionNodeBase rightOperand) {
        BinaryOperatorIsNode check = new BinaryOperatorIsNode(null, leftOperand, rightOperand);
        this.getModel().needLanguage = true;
        return check;
    }
}

