/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import java.util.Collection;
import java.util.ListIterator;
import org.apache.royale.compiler.common.PrefixMap;
import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.mxml.EntityProcessor;
import org.apache.royale.compiler.internal.mxml.MXMLData;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.internal.mxml.MXMLStateSplitter;
import org.apache.royale.compiler.internal.parsing.ISourceFragment;
import org.apache.royale.compiler.internal.parsing.SourceFragment;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.mxml.IMXMLTagAttributeData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.MXMLUnclosedTagProblem;
import org.apache.royale.compiler.problems.SyntaxProblem;

public class MXMLTagAttributeData
extends SourceLocation
implements IMXMLTagAttributeData {
    protected IMXMLTagData parent;
    protected String uri;
    protected String attributeName;
    protected String stateName;
    protected int stateStart;
    protected String valueIncludingDelimiters;
    protected int valueStart;
    protected int valueLine;
    protected int valueColumn;

    MXMLTagAttributeData(MXMLToken nameToken, ListIterator<MXMLToken> tokenIterator, MXMLDialect mxmlDialect, IFileSpecification spec, Collection<ICompilerProblem> problems) {
        this.setStart(nameToken.getStart());
        this.setLine(nameToken.getLine());
        this.setColumn(nameToken.getColumn());
        this.setEndLine(nameToken.getEndLine());
        this.setEndColumn(nameToken.getEndColumn());
        this.setEnd(nameToken.getEnd());
        MXMLStateSplitter splitState = new MXMLStateSplitter(nameToken, mxmlDialect, problems, spec);
        this.attributeName = splitState.getBaseName();
        if (splitState.getStateName() != null) {
            this.stateName = splitState.getStateName();
            this.stateStart = nameToken.getStart() + splitState.getStateNameOffset();
        }
        MXMLToken token = null;
        if (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (token.getType() != 6) {
                if (token.getSourcePath() == null) {
                    token.setSourcePath(spec.getPath());
                }
                problems.add(new SyntaxProblem(token));
                tokenIterator.previous();
                return;
            }
            this.valueStart = token.getEnd();
            this.valueLine = token.getLine();
            this.valueColumn = token.getColumn();
        }
        Boolean firstToken = true;
        while (tokenIterator.hasNext()) {
            token = tokenIterator.next();
            if (token.getType() != 10) {
                if (firstToken.booleanValue()) {
                    if (token.getSourcePath() == null) {
                        token.setSourcePath(spec.getPath());
                    }
                    problems.add(new SyntaxProblem(token));
                } else if (!MXMLToken.isTagEnd(token.getType()) && token.getType() != 7) {
                    if (token.getSourcePath() == null) {
                        token.setSourcePath(spec.getPath());
                    }
                    problems.add(new MXMLUnclosedTagProblem(token));
                }
                tokenIterator.previous();
                return;
            }
            this.valueIncludingDelimiters = token.getText();
            firstToken = false;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.buildAttributeString(false);
        return sb.toString();
    }

    @Override
    public MXMLDialect getMXMLDialect() {
        return this.getParent().getParent().getMXMLDialect();
    }

    @Override
    public IMXMLTagData getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    @Override
    public String getPrefix() {
        String name = this.getName();
        int i = name.indexOf(58);
        return i != -1 ? name.substring(0, i) : null;
    }

    @Override
    public String getURI() {
        if (this.uri == null) {
            String prefix = this.getPrefix();
            if (prefix == null) {
                return null;
            }
            for (IMXMLTagData lookingAt = this.parent; lookingAt != null && lookingAt.getParent() != null; lookingAt = lookingAt.getParentTag()) {
                PrefixMap depth = lookingAt.getParent().getPrefixMapForData(lookingAt);
                if (depth == null || !depth.containsPrefix(prefix)) continue;
                this.uri = depth.getNamespaceForPrefix(prefix);
                break;
            }
        }
        return this.uri;
    }

    @Override
    public String getShortName() {
        String name = this.getName();
        int i = name.indexOf(58);
        return i != -1 ? name.substring(i + 1) : name;
    }

    @Override
    public XMLName getXMLName() {
        return new XMLName(this.getURI(), this.getShortName());
    }

    @Override
    public String getStateName() {
        return this.stateName != null ? this.stateName : "";
    }

    @Override
    public boolean isSpecialAttribute(String name) {
        String languageURI = this.getMXMLDialect().getLanguageNamespace();
        return this.getName().equals(name) && (this.getPrefix() == null || this.getURI() == languageURI);
    }

    @Override
    public boolean hasValue() {
        return this.getRawValue() != null;
    }

    @Override
    public String getRawValue() {
        String value = this.getValueWithQuotes();
        if (value != null && value.length() > 0) {
            value = value.charAt(0) == value.charAt(value.length() - 1) && value.length() != 1 ? value.substring(1, value.length() - 1) : value.substring(1);
        }
        return value;
    }

    @Override
    public ISourceFragment[] getValueFragments(Collection<ICompilerProblem> problems) {
        String value = this.getRawValue();
        if (value == null) {
            return new ISourceFragment[0];
        }
        SourceLocation location = this.getValueLocation();
        MXMLDialect mxmlDialect = this.getMXMLDialect();
        String s = EntityProcessor.parseAsString(value, location, mxmlDialect, problems);
        ISourceFragment[] result = new ISourceFragment[]{new SourceFragment(s, location)};
        return result;
    }

    @Override
    public int getValueStart() {
        return this.hasValue() ? this.valueStart + 1 : 0;
    }

    @Override
    public int getValueEnd() {
        if (this.hasValue()) {
            return this.getValueStart() + this.getRawValue().length();
        }
        return -1;
    }

    @Override
    public int getValueLine() {
        return this.hasValue() ? this.valueLine : 0;
    }

    @Override
    public int getValueColumn() {
        return this.hasValue() ? this.valueColumn + 1 : 0;
    }

    @Override
    public SourceLocation getValueLocation() {
        return new SourceLocation(this.getSourcePath(), this.getValueStart(), this.getValueEnd(), this.getValueLine(), this.getValueColumn(), this.getValueLine(), this.getValueColumn() + this.getValueEnd() - this.getValueStart());
    }

    public IFileSpecification getSource() {
        return this.getParent().getSource();
    }

    public void setParent(IMXMLTagData parent) {
        this.parent = parent;
        this.setSourcePath(parent.getSourcePath());
    }

    public void adjustOffsets(int offsetAdjustment) {
        if (this.attributeName != null) {
            this.setStart(this.getAbsoluteStart() + offsetAdjustment);
            this.setEnd(this.getAbsoluteEnd() + offsetAdjustment);
        }
        if (this.hasValue()) {
            this.valueStart += offsetAdjustment;
        }
        if (this.stateName != null) {
            this.stateStart += offsetAdjustment;
        }
    }

    public PrefixMap getCompositePrefixMap() {
        return this.parent.getCompositePrefixMap();
    }

    void invalidateURI() {
        this.uri = null;
    }

    public int getNameStart() {
        return this.getAbsoluteStart();
    }

    public int getNameEnd() {
        return this.getAbsoluteStart() + this.attributeName.length();
    }

    public final int getNameLine() {
        return this.getLine();
    }

    public final int getNameColumn() {
        return this.getColumn();
    }

    public boolean isInsideName(int offset) {
        if (this.attributeName != null) {
            return MXMLData.contains(this.getNameStart(), this.getNameEnd(), offset);
        }
        return false;
    }

    public boolean hasState() {
        return this.stateName != null;
    }

    public int getStateStart() {
        return this.stateName != null ? this.stateStart : 0;
    }

    public int getStateEnd() {
        return this.stateName != null ? this.stateStart + this.stateName.length() : 0;
    }

    public boolean isInsideStateName(int offset) {
        if (this.stateName != null) {
            return MXMLData.contains(this.getStateStart(), this.getStateEnd(), offset);
        }
        return false;
    }

    public String getValueWithQuotes() {
        return this.valueIncludingDelimiters;
    }

    protected boolean valueIsWellFormed() {
        if (this.hasValue()) {
            char firstChar = this.valueIncludingDelimiters.charAt(0);
            char lastChar = this.valueIncludingDelimiters.charAt(this.valueIncludingDelimiters.length() - 1);
            return (firstChar == '\"' || firstChar == '\'') && firstChar == lastChar;
        }
        return false;
    }

    public boolean isInsideValue(int offset) {
        if (this.hasValue()) {
            return MXMLData.contains(this.getValueStart() - 1, this.getValueEnd(), offset);
        }
        return false;
    }

    public String buildAttributeString(boolean skipSrcPath) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append('=');
        sb.append('\"');
        sb.append(this.getRawValue());
        sb.append('\"');
        sb.append(' ');
        if (skipSrcPath) {
            sb.append(this.getOffsetsString());
        } else {
            sb.append(super.toString());
        }
        return sb.toString();
    }

    public boolean verify() {
        assert (this.getSourcePath() != null) : "Attribute has null source path: " + this.toString();
        assert (this.getStart() != -1) : "Attribute has unknown start: " + this.toString();
        assert (this.getEnd() != -1) : "Attribute has unknown end: " + this.toString();
        assert (this.getLine() != -1) : "Attribute has unknown line: " + this.toString();
        assert (this.getColumn() != -1) : "Attribute has unknown column: " + this.toString();
        return true;
    }
}

