/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.fxg.swf;

import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.royale.compiler.definitions.ITypeDefinition;
import org.apache.royale.compiler.fxg.IFXGTranscoder;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.fxg.flex.FXGSymbolClass;
import org.apache.royale.compiler.fxg.resources.IFXGResourceResolver;
import org.apache.royale.compiler.internal.fxg.dom.AbstractShapeNode;
import org.apache.royale.compiler.internal.fxg.dom.BitmapGraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.DefinitionNode;
import org.apache.royale.compiler.internal.fxg.dom.EllipseNode;
import org.apache.royale.compiler.internal.fxg.dom.GradientEntryNode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContentNode;
import org.apache.royale.compiler.internal.fxg.dom.GraphicContext;
import org.apache.royale.compiler.internal.fxg.dom.GraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.GroupDefinitionNode;
import org.apache.royale.compiler.internal.fxg.dom.GroupNode;
import org.apache.royale.compiler.internal.fxg.dom.IFillNode;
import org.apache.royale.compiler.internal.fxg.dom.IFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.IMaskableNode;
import org.apache.royale.compiler.internal.fxg.dom.IMaskingNode;
import org.apache.royale.compiler.internal.fxg.dom.IStrokeNode;
import org.apache.royale.compiler.internal.fxg.dom.LineNode;
import org.apache.royale.compiler.internal.fxg.dom.PathNode;
import org.apache.royale.compiler.internal.fxg.dom.PlaceObjectNode;
import org.apache.royale.compiler.internal.fxg.dom.RectNode;
import org.apache.royale.compiler.internal.fxg.dom.RichTextNode;
import org.apache.royale.compiler.internal.fxg.dom.TextGraphicNode;
import org.apache.royale.compiler.internal.fxg.dom.fills.BitmapFillNode;
import org.apache.royale.compiler.internal.fxg.dom.fills.LinearGradientFillNode;
import org.apache.royale.compiler.internal.fxg.dom.fills.RadialGradientFillNode;
import org.apache.royale.compiler.internal.fxg.dom.fills.SolidColorFillNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.AbstractFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.BevelFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.BlurFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.ColorMatrixFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.DropShadowFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.GlowFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.GradientBevelFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.filters.GradientGlowFilterNode;
import org.apache.royale.compiler.internal.fxg.dom.strokes.AbstractStrokeNode;
import org.apache.royale.compiler.internal.fxg.dom.strokes.LinearGradientStrokeNode;
import org.apache.royale.compiler.internal.fxg.dom.strokes.RadialGradientStrokeNode;
import org.apache.royale.compiler.internal.fxg.dom.strokes.SolidColorStrokeNode;
import org.apache.royale.compiler.internal.fxg.dom.transforms.ColorTransformNode;
import org.apache.royale.compiler.internal.fxg.dom.transforms.MatrixNode;
import org.apache.royale.compiler.internal.fxg.dom.types.BevelType;
import org.apache.royale.compiler.internal.fxg.dom.types.BlendMode;
import org.apache.royale.compiler.internal.fxg.dom.types.Caps;
import org.apache.royale.compiler.internal.fxg.dom.types.InterpolationMethod;
import org.apache.royale.compiler.internal.fxg.dom.types.Joints;
import org.apache.royale.compiler.internal.fxg.dom.types.MaskType;
import org.apache.royale.compiler.internal.fxg.dom.types.ScaleMode;
import org.apache.royale.compiler.internal.fxg.dom.types.ScalingGrid;
import org.apache.royale.compiler.internal.fxg.dom.types.SpreadMethod;
import org.apache.royale.compiler.internal.fxg.dom.types.Winding;
import org.apache.royale.compiler.internal.fxg.swf.DefineImage;
import org.apache.royale.compiler.internal.fxg.swf.ImageHelper;
import org.apache.royale.compiler.internal.fxg.swf.ShapeHelper;
import org.apache.royale.compiler.internal.fxg.swf.TypeHelper;
import org.apache.royale.compiler.internal.fxg.types.FXGMatrix;
import org.apache.royale.compiler.problems.FXGErrorEmbeddingImageProblem;
import org.apache.royale.compiler.problems.FXGMissingAttributeProblem;
import org.apache.royale.compiler.problems.FXGMissingGroupChildNodeProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.swf.builders.IShapeIterator;
import org.apache.royale.swf.builders.ShapeBuilder;
import org.apache.royale.swf.tags.DefineScalingGridTag;
import org.apache.royale.swf.tags.DefineShape4Tag;
import org.apache.royale.swf.tags.DefineShapeTag;
import org.apache.royale.swf.tags.DefineSpriteTag;
import org.apache.royale.swf.tags.ICharacterTag;
import org.apache.royale.swf.tags.ITag;
import org.apache.royale.swf.tags.PlaceObject3Tag;
import org.apache.royale.swf.types.BevelFilter;
import org.apache.royale.swf.types.BlurFilter;
import org.apache.royale.swf.types.CXFormWithAlpha;
import org.apache.royale.swf.types.DropShadowFilter;
import org.apache.royale.swf.types.FillStyle;
import org.apache.royale.swf.types.FillStyleArray;
import org.apache.royale.swf.types.Filter;
import org.apache.royale.swf.types.FocalGradient;
import org.apache.royale.swf.types.GlowFilter;
import org.apache.royale.swf.types.GradRecord;
import org.apache.royale.swf.types.Gradient;
import org.apache.royale.swf.types.GradientBevelFilter;
import org.apache.royale.swf.types.GradientGlowFilter;
import org.apache.royale.swf.types.IDataType;
import org.apache.royale.swf.types.LineStyle;
import org.apache.royale.swf.types.LineStyle2;
import org.apache.royale.swf.types.LineStyleArray;
import org.apache.royale.swf.types.Matrix;
import org.apache.royale.swf.types.RGB;
import org.apache.royale.swf.types.RGBA;
import org.apache.royale.swf.types.Rect;
import org.apache.royale.swf.types.Shape;
import org.apache.royale.swf.types.ShapeRecord;
import org.apache.royale.swf.types.ShapeWithStyle;
import org.apache.royale.swf.types.Styles;

public class FXG2SWFTranscoder
implements IFXGTranscoder {
    protected FXGSymbolClass graphicClass;
    protected HashMap<String, DefineSpriteTag> definitions;
    protected Stack<DefineSpriteTag> spriteStack = new Stack();
    protected Map<DefineSpriteTag, Integer> depthMap = new HashMap<DefineSpriteTag, Integer>();
    protected IFXGResourceResolver resourceResolver;
    protected Map<ITag, ITag> extraTags;
    protected Map<String, DefineImage> imageMap = new HashMap<String, DefineImage>();
    protected Collection<ICompilerProblem> problems;

    public FXG2SWFTranscoder newInstance() {
        FXG2SWFTranscoder transcoder = new FXG2SWFTranscoder();
        transcoder.extraTags = this.extraTags;
        transcoder.imageMap = this.imageMap;
        transcoder.depthMap = this.depthMap;
        return transcoder;
    }

    @Override
    public void setResourceResolver(IFXGResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    protected int getSpriteDepth(DefineSpriteTag sprite) {
        if (this.depthMap.containsKey(sprite)) {
            return this.depthMap.get(sprite);
        }
        this.depthMap.put(sprite, 0);
        return 0;
    }

    private void setSpriteDepth(DefineSpriteTag sprite, Integer depth) {
        this.depthMap.put(sprite, depth);
    }

    @Override
    public FXGSymbolClass transcode(IFXGNode fxgNode, String packageName, String className, Map<ITag, ITag> extraTags, Collection<ICompilerProblem> problems) {
        this.problems = problems;
        this.extraTags = extraTags;
        this.graphicClass = new FXGSymbolClass();
        this.graphicClass.setPackageName(packageName);
        this.graphicClass.setClassName(className);
        GraphicNode node = (GraphicNode)fxgNode;
        DefineSpriteTag sprite = this.createDefineSpriteTag("Graphic");
        this.spriteStack.push(sprite);
        if (node.mask != null) {
            this.mask(node, sprite);
        }
        if (node.definesScaleGrid()) {
            DefineScalingGridTag grid = this.createDefineScalingGridTag(node.getScalingGrid());
            grid.setCharacter(sprite);
            extraTags.put(sprite, grid);
        }
        if (node.children != null) {
            this.graphicContentNodes(node.children);
        }
        this.spriteStack.pop();
        this.graphicClass.setSymbol(sprite);
        return this.graphicClass;
    }

    private PlaceObject3Tag bitmapWithClip(DefineImage defImage, BitmapGraphicNode node) {
        GraphicContext context = node.createGraphicContext();
        List<IFilterNode> filters = null;
        if (context.filters != null) {
            filters = context.filters;
            context.filters = null;
            DefineSpriteTag filterSprite = this.createDefineSpriteTag("MaskFilter");
            this.spriteStack.push(filterSprite);
        }
        DefineSpriteTag imageSprite = this.createDefineSpriteTag("BitmapGraphic");
        this.spriteStack.push(imageSprite);
        DefineSpriteTag clipSprite = this.createDefineSpriteTag("BitmapGraphic_Clip");
        this.spriteStack.push(clipSprite);
        double width = (double)defImage.getWidth() < node.width ? (double)defImage.getWidth() : node.width;
        double height = (double)defImage.getHeight() < node.height ? (double)defImage.getHeight() : node.height;
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
        DefineShapeTag clipShape = this.createDefineShapeTag(null, shapeRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
        this.PlaceObject3Tag(clipShape, new GraphicContext());
        this.spriteStack.pop();
        PlaceObject3Tag po3clip = this.PlaceObject3Tag(clipSprite, context);
        po3clip.setClipDepth(po3clip.getDepth() + 1);
        po3clip.setHasClipDepth(true);
        DefineShapeTag imageShape = ImageHelper.createShapeForImage(defImage, node);
        this.PlaceObject3Tag(imageShape, context);
        this.spriteStack.pop();
        PlaceObject3Tag po3 = this.PlaceObject3Tag(imageSprite, new GraphicContext());
        if (filters != null) {
            DefineSpriteTag sprite = this.spriteStack.pop();
            GraphicContext gc = new GraphicContext();
            gc.filters = filters;
            PlaceObject3Tag poFilter = this.PlaceObject3Tag(sprite, gc);
            return poFilter;
        }
        return po3;
    }

    protected PlaceObject3Tag bitmap(BitmapGraphicNode node) {
        GraphicContext context = node.createGraphicContext();
        String source = this.parseSource(node.source);
        if (source == null) {
            this.problems.add(new FXGMissingAttributeProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "source", node.getNodeName()));
            return null;
        }
        DefineImage imageTag = this.createDefineBitsTag(node, source);
        if (imageTag == null) {
            return null;
        }
        if (node.visible && !node.isPartofClipMask) {
            ScalingGrid scalingGrid = context.scalingGrid;
            if (scalingGrid != null) {
                Rect grid = TypeHelper.rect(scalingGrid.scaleGridLeft, scalingGrid.scaleGridTop, scalingGrid.scaleGridRight, scalingGrid.scaleGridBottom);
                DefineShapeTag imageShape = ImageHelper.create9SlicedShape(imageTag, grid, Double.NaN, Double.NaN);
                PlaceObject3Tag po3 = this.PlaceObject3Tag(imageShape, context);
                return po3;
            }
            if (ImageHelper.bitmapImageNeedsClipping(imageTag, node)) {
                PlaceObject3Tag p03 = this.bitmapWithClip(imageTag, node);
                return p03;
            }
            DefineShapeTag imageShape = ImageHelper.createShapeForImage(imageTag, node);
            PlaceObject3Tag po3 = this.PlaceObject3Tag(imageShape, context);
            return po3;
        }
        if (!ImageHelper.bitmapImageNeedsClipping(imageTag, node)) {
            double width = Double.isNaN(node.width) ? (double)imageTag.getWidth() : node.width;
            double height = Double.isNaN(node.height) ? (double)imageTag.getHeight() : node.height;
            List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
            DefineShapeTag shape = this.createDefineShapeTag(null, shapeRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
            PlaceObject3Tag po3 = this.PlaceObject3Tag(shape, context);
            return po3;
        }
        double width = (double)imageTag.getWidth() < node.width || Double.isNaN(node.width) ? (double)imageTag.getWidth() : node.width;
        double height = (double)imageTag.getHeight() < node.height || Double.isNaN(node.height) ? (double)imageTag.getHeight() : node.height;
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(0.0, 0.0, width, height);
        DefineShapeTag shape = this.createDefineShapeTag(null, shapeRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
        PlaceObject3Tag po3 = this.PlaceObject3Tag(shape, context);
        return po3;
    }

    protected void graphicContentNodes(List<GraphicContentNode> nodes) {
        if (nodes == null) {
            return;
        }
        for (GraphicContentNode node : nodes) {
            this.graphicContentNode(node);
        }
    }

    protected PlaceObject3Tag graphicContentNode(GraphicContentNode node) {
        PlaceObject3Tag po3 = null;
        if (!node.visible) {
            ColorTransformNode ct = new ColorTransformNode();
            ct.alphaMultiplier = 0.0;
            ct.alphaOffset = 0.0;
            ct.blueMultiplier = 1.0;
            ct.blueOffset = 0.0;
            ct.greenMultiplier = 1.0;
            ct.greenOffset = 0.0;
            ct.redMultiplier = 1.0;
            ct.redOffset = 0.0;
            node.colorTransform = ct;
            if (node instanceof AbstractShapeNode) {
                AbstractShapeNode shapeNode = (AbstractShapeNode)node;
                shapeNode.fill = null;
                shapeNode.stroke = null;
            }
        }
        if (node instanceof GroupNode) {
            this.group((GroupNode)node);
        } else {
            if (node.blendMode == BlendMode.AUTO) {
                node.blendMode = BlendMode.NORMAL;
            }
            List<IFilterNode> filters = null;
            if (node.mask != null) {
                if (node.filters != null) {
                    filters = node.filters;
                    node.filters = null;
                    DefineSpriteTag filterSprite = this.createDefineSpriteTag("MaskFilter");
                    this.spriteStack.push(filterSprite);
                }
                DefineSpriteTag parentSprite = this.spriteStack.peek();
                this.mask(node, parentSprite);
            }
            if (node instanceof EllipseNode) {
                po3 = this.ellipse((EllipseNode)node);
            } else if (node instanceof LineNode) {
                po3 = this.line((LineNode)node);
            } else if (node instanceof PathNode) {
                po3 = this.path((PathNode)node);
            } else if (node instanceof RectNode) {
                po3 = this.rect((RectNode)node);
            } else if (node instanceof PlaceObjectNode) {
                po3 = this.PlaceObject3TagInstance((PlaceObjectNode)node);
            } else if (node instanceof BitmapGraphicNode) {
                po3 = this.bitmap((BitmapGraphicNode)node);
            } else if (node instanceof TextGraphicNode) {
                po3 = this.text((TextGraphicNode)node);
            } else if (node instanceof RichTextNode) {
                po3 = this.richtext((RichTextNode)node);
            }
            if (filters != null) {
                DefineSpriteTag sprite = this.spriteStack.pop();
                GraphicContext gc = new GraphicContext();
                gc.filters = filters;
                PlaceObject3Tag poFilter = this.PlaceObject3Tag(sprite, gc);
                return poFilter;
            }
        }
        return po3;
    }

    protected PlaceObject3Tag ellipse(EllipseNode node) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, node.width, node.height);
        ShapeBuilder builder = new ShapeBuilder();
        PathIteratorWrapper iterator = new PathIteratorWrapper(ellipse.getPathIterator(null));
        builder.processShape(iterator);
        Shape shape = builder.build();
        return this.placeDefineShapeTag(node, shape.getShapeRecords(), node.fill, node.stroke, node.createGraphicContext(), new Winding[0]);
    }

    protected PlaceObject3Tag group(GroupNode node) {
        DefineSpriteTag sprite;
        if (node.blendMode == BlendMode.AUTO) {
            node.blendMode = node.alpha == 0.0 || node.alpha == 1.0 ? BlendMode.NORMAL : BlendMode.LAYER;
        }
        DefineSpriteTag groupSprite = this.createDefineSpriteTag("Group");
        GraphicContext context = node.createGraphicContext();
        if (node.definesScaleGrid()) {
            DefineScalingGridTag grid = this.createDefineScalingGridTag(context.scalingGrid);
            grid.setCharacter(groupSprite);
            this.extraTags.put(groupSprite, grid);
        }
        PlaceObject3Tag po3 = this.PlaceObject3Tag(groupSprite, context);
        this.spriteStack.push(groupSprite);
        List<IFilterNode> filters = null;
        if (node.mask != null) {
            filters = node.filters;
            if (filters == null) {
                List<GraphicContentNode> children = node.children;
                if (children != null) {
                    GraphicContentNode gcNodeI;
                    int i;
                    GraphicContentNode gcNode0 = children.get(0);
                    filters = gcNode0.filters;
                    if (filters != null) {
                        for (i = 1; i < children.size() && filters != null; ++i) {
                            gcNodeI = children.get(i);
                            if (gcNodeI.filters == filters) continue;
                            filters = null;
                        }
                    }
                    if (filters != null) {
                        for (i = 0; i < children.size(); ++i) {
                            gcNodeI = children.get(i);
                            gcNodeI.filters = null;
                        }
                    }
                }
            } else {
                node.filters = null;
            }
            if (filters != null) {
                DefineSpriteTag filterSprite = this.createDefineSpriteTag("MaskFilter");
                this.spriteStack.push(filterSprite);
            }
            sprite = this.spriteStack.peek();
            this.mask(node, sprite);
        }
        if (node.children != null) {
            this.graphicContentNodes(node.children);
        }
        if (filters != null) {
            sprite = this.spriteStack.pop();
            GraphicContext gc = new GraphicContext();
            gc.filters = filters;
            PlaceObject3Tag poFilter = this.PlaceObject3Tag(sprite, gc);
            return poFilter;
        }
        this.spriteStack.pop();
        return po3;
    }

    protected PlaceObject3Tag line(LineNode node) {
        List<ShapeRecord> shapeRecords = ShapeHelper.line(node.xFrom, node.yFrom, node.xTo, node.yTo);
        GraphicContext context = node.createGraphicContext();
        PlaceObject3Tag po3 = this.placeDefineShapeTag(node, shapeRecords, node.fill, node.stroke, context, new Winding[0]);
        return po3;
    }

    protected PlaceObject3Tag mask(IMaskableNode node, DefineSpriteTag parentSprite) {
        PlaceObject3Tag po3 = null;
        IMaskingNode mask = node.getMask();
        if (mask instanceof GroupNode) {
            if (!(node instanceof GroupNode) && !(node instanceof GraphicNode)) {
                FXGMatrix nodeMatrix = null;
                MatrixNode matrixNodeShape = ((GraphicContentNode)node).matrix;
                nodeMatrix = matrixNodeShape == null ? FXGMatrix.convertToMatrix(((GraphicContentNode)node).scaleX, ((GraphicContentNode)node).scaleY, ((GraphicContentNode)node).rotation, ((GraphicContentNode)node).x, ((GraphicContentNode)node).y) : new FXGMatrix(matrixNodeShape);
                MatrixNode matrixNodeMasking = ((GraphicContentNode)((Object)mask)).matrix;
                if (matrixNodeMasking == null) {
                    ((GraphicContentNode)((Object)mask)).convertTransformAttrToMatrix(this.problems);
                    matrixNodeMasking = ((GraphicContentNode)((Object)mask)).matrix;
                }
                FXGMatrix maskMatrix = new FXGMatrix(matrixNodeMasking);
                maskMatrix.concat(nodeMatrix);
                maskMatrix.setMatrixNodeValue(matrixNodeMasking);
            }
            this.markLeafNodesAsMask(node, (GroupNode)mask);
            po3 = this.group((GroupNode)mask);
        } else if (mask instanceof PlaceObjectNode) {
            po3 = this.PlaceObject3TagInstance((PlaceObjectNode)mask);
        }
        if (po3 != null) {
            int clipDepth = 1;
            if (node instanceof GroupNode) {
                GroupNode group = (GroupNode)node;
                if (group.children != null) {
                    clipDepth = this.getSpriteDepth(parentSprite) + group.children.size();
                }
            } else if (node instanceof GraphicNode) {
                GraphicNode graphic = (GraphicNode)node;
                if (graphic.children != null) {
                    clipDepth = this.getSpriteDepth(parentSprite) + graphic.children.size();
                }
            } else {
                clipDepth = po3.getDepth() + 1;
            }
            po3.setClipDepth(clipDepth);
            po3.setHasClipDepth(true);
            if (node.getMaskType() == MaskType.ALPHA) {
                po3.setHasCacheAsBitmap(true);
            }
        }
        return po3;
    }

    protected PlaceObject3Tag path(PathNode node) {
        List<ShapeRecord> shapeRecords = ShapeHelper.path(node, node.fill != null, this.problems);
        GraphicContext context = node.createGraphicContext();
        Winding[] winding = new Winding[]{node.winding};
        PlaceObject3Tag po3 = this.placeDefineShapeTag(node, shapeRecords, node.fill, node.stroke, context, winding);
        return po3;
    }

    protected void setPixelBenderBlendMode(PlaceObject3Tag po, BlendMode blendMode) {
    }

    protected void setAlphaMask(PlaceObject3Tag po) {
        po.setHasCacheAsBitmap(true);
    }

    protected void setLuminosityMask(PlaceObject3Tag po) {
    }

    protected PlaceObject3Tag PlaceObject3Tag(ICharacterTag symbol, GraphicContext context) {
        DefineSpriteTag sprite = this.spriteStack.peek();
        PlaceObject3Tag po3 = new PlaceObject3Tag();
        po3.setCharacter(symbol);
        assert (symbol != sprite);
        po3.setHasCharacter(true);
        Integer depthCount = this.getSpriteDepth(sprite) + 1;
        this.setSpriteDepth(sprite, depthCount);
        po3.setDepth(depthCount);
        if (context.blendMode != null) {
            if (!context.blendMode.needsPixelBenderSupport()) {
                int blendMode = this.createBlendMode(context.blendMode);
                po3.setBlendMode(blendMode);
                po3.setHasBlendMode(true);
            } else {
                this.setPixelBenderBlendMode(po3, context.blendMode);
            }
        }
        if (context.filters != null) {
            List<Filter> filters = this.createFilters(context.filters);
            Filter[] filterArray = new Filter[]{};
            po3.setSurfaceFilterList(filters.toArray(filterArray));
            po3.setHasFilterList(true);
        }
        Matrix matrix = context.getTransform().toSWFMatrix();
        po3.setMatrix(matrix);
        po3.setHasMatrix(true);
        if (context.colorTransform != null) {
            ColorTransformNode t = context.colorTransform;
            CXFormWithAlpha cx = TypeHelper.cxFormWithAlpha(t.alphaMultiplier, t.redMultiplier, t.greenMultiplier, t.blueMultiplier, t.alphaOffset, t.redOffset, t.greenOffset, t.blueOffset);
            po3.setColorTransform(cx);
            po3.setHasColorTransform(true);
        }
        if (context.maskType == MaskType.ALPHA) {
            this.setAlphaMask(po3);
        } else if (context.maskType == MaskType.LUMINOSITY) {
            this.setLuminosityMask(po3);
        }
        sprite.getControlTags().add(po3);
        return po3;
    }

    protected PlaceObject3Tag rect(RectNode node) {
        GraphicContext context = node.createGraphicContext();
        List<ShapeRecord> shapeRecords = node.radiusX != 0.0 || node.radiusY != 0.0 || !Double.isNaN(node.topLeftRadiusX) || !Double.isNaN(node.topLeftRadiusY) || !Double.isNaN(node.topRightRadiusX) || !Double.isNaN(node.topRightRadiusY) || !Double.isNaN(node.bottomLeftRadiusX) || !Double.isNaN(node.bottomLeftRadiusY) || !Double.isNaN(node.bottomRightRadiusX) || !Double.isNaN(node.bottomRightRadiusY) ? ShapeHelper.rectangle(0.0, 0.0, node.width, node.height, node.radiusX, node.radiusY, node.topLeftRadiusX, node.topLeftRadiusY, node.topRightRadiusX, node.topRightRadiusY, node.bottomLeftRadiusX, node.bottomLeftRadiusY, node.bottomRightRadiusX, node.bottomRightRadiusY) : ShapeHelper.rectangle(0.0, 0.0, node.width, node.height);
        PlaceObject3Tag po3 = this.placeDefineShapeTag(node, shapeRecords, node.fill, node.stroke, context, new Winding[0]);
        return po3;
    }

    protected PlaceObject3Tag text(TextGraphicNode node) {
        return null;
    }

    protected PlaceObject3Tag richtext(RichTextNode node) {
        return null;
    }

    protected PlaceObject3Tag PlaceObject3TagInstance(PlaceObjectNode node) {
        DefineSpriteTag definitionSprite;
        String definitionName = node.getNodeName();
        if (this.definitions == null) {
            this.definitions = new HashMap();
        }
        if ((definitionSprite = this.definitions.get(definitionName)) == null) {
            definitionSprite = this.createDefineSpriteTag("Definition");
            FXG2SWFTranscoder graphics = this.newInstance();
            graphics.setResourceResolver(this.resourceResolver);
            this.definitions.put(definitionName, definitionSprite);
            graphics.definitions = this.definitions;
            graphics.problems = this.problems;
            graphics.definition(node.definition, definitionSprite);
        }
        PlaceObject3Tag po3 = this.PlaceObject3Tag(definitionSprite, node.createGraphicContext());
        return po3;
    }

    protected void definition(DefinitionNode node, DefineSpriteTag definitionSprite) {
        GroupDefinitionNode groupDefinition = node.groupDefinition;
        if (groupDefinition == null) {
            this.problems.add(new FXGMissingGroupChildNodeProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn()));
            return;
        }
        this.spriteStack.push(definitionSprite);
        if (groupDefinition.definesScaleGrid()) {
            DefineScalingGridTag scalingGrid = this.createDefineScalingGridTag(groupDefinition.getScalingGrid());
            scalingGrid.setCharacter(definitionSprite);
            this.extraTags.put(definitionSprite, scalingGrid);
        }
        this.graphicContentNodes(groupDefinition.children);
        this.spriteStack.pop();
    }

    protected DefineImage createDefineBitsTag(IFXGNode node, String source) {
        DefineImage imageTag = this.imageMap.get(source);
        if (imageTag == null) {
            try {
                InputStream stream = this.resourceResolver.openStream(source);
                imageTag = ImageHelper.createDefineBits(stream, ImageHelper.guessMimeType(source));
                this.imageMap.put(source, imageTag);
            }
            catch (IOException ioe) {
                this.problems.add(new FXGErrorEmbeddingImageProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), ioe.getMessage(), source));
                return null;
            }
        }
        return imageTag;
    }

    protected DefineScalingGridTag createDefineScalingGridTag(ScalingGrid grid) {
        DefineScalingGridTag scalingGrid = new DefineScalingGridTag();
        scalingGrid.setSplitter(TypeHelper.rect(grid.scaleGridLeft, grid.scaleGridTop, grid.scaleGridRight, grid.scaleGridBottom));
        return scalingGrid;
    }

    protected DefineSpriteTag createDefineSpriteTag(String name) {
        DefineSpriteTag sprite = new DefineSpriteTag(0, new ArrayList<ITag>());
        if (name == null) {
            name = "";
        }
        return sprite;
    }

    protected DefineShapeTag createDefineShapeTag(AbstractShapeNode node, List<ShapeRecord> shapeRecords, IFillNode fill, IStrokeNode stroke, FXGMatrix transform, Winding ... windings) {
        Rect shapeBounds;
        FillStyle fillStyle;
        Rect edgeBounds = node == null ? ShapeHelper.getBounds(shapeRecords, null, (AbstractStrokeNode)stroke) : node.getBounds(shapeRecords, null);
        int lineStyleIndex = stroke == null ? 0 : 1;
        int fillStyle0Index = fill == null ? 0 : 1;
        int fillStyle1Index = 0;
        FillStyleArray fillStyles = new FillStyleArray(1);
        LineStyleArray lineStyles = new LineStyleArray();
        if (fill != null && (fillStyle = this.createFillStyle(fill, edgeBounds)) != null) {
            fillStyles.add(fillStyle);
        }
        if (stroke != null) {
            LineStyle2 ls = this.createGenericLineStyle((AbstractStrokeNode)stroke);
            shapeBounds = node == null ? ShapeHelper.getBounds(shapeRecords, ls, (AbstractStrokeNode)stroke) : node.getBounds(shapeRecords, ls);
            LineStyle lineStyle = this.createLineStyle(stroke, shapeBounds);
            lineStyles.add(lineStyle);
        } else {
            shapeBounds = edgeBounds;
        }
        Styles styles = new Styles(fillStyles, lineStyles);
        if (windings.length > 0) {
            ShapeHelper.setPathStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index, styles);
        } else {
            ShapeHelper.setStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index, styles);
        }
        ShapeWithStyle sws = new ShapeWithStyle(styles);
        sws.addShapeRecords(shapeRecords);
        DefineShape4Tag DefineShapeTag4 = new DefineShape4Tag();
        DefineShapeTag4.setShapes(sws);
        DefineShapeTag4.setShapeBounds(shapeBounds);
        DefineShapeTag4.setEdgeBounds(edgeBounds);
        if (fill != null && windings.length > 0) {
            Winding windingValue = windings[0];
            DefineShapeTag4.setUsesFillWindingRule(windingValue == Winding.NON_ZERO);
        }
        return DefineShapeTag4;
    }

    protected PlaceObject3Tag placeDefineShapeTag(AbstractShapeNode node, List<ShapeRecord> shapeRecords, IFillNode fill, IStrokeNode stroke, GraphicContext context, Winding ... windings) {
        if (node != null && fill != null && !node.isPartofClipMask && ImageHelper.isBitmapFillWithClip(fill)) {
            BitmapFillNode fillNode = (BitmapFillNode)fill;
            Rect edgeBounds = node.getBounds(shapeRecords, null);
            String source = this.parseSource(fillNode.source);
            if (source == null) {
                this.problems.add(new FXGMissingAttributeProblem(node.getDocumentPath(), node.getStartLine(), node.getStartColumn(), "source", node.getNodeName()));
                return null;
            }
            DefineImage defImage = this.createDefineBitsTag(fill, source);
            if (defImage == null) {
                return null;
            }
            List<IFilterNode> filters = null;
            if (context.filters != null) {
                filters = context.filters;
                context.filters = null;
                DefineSpriteTag filterSprite = this.createDefineSpriteTag("MaskFilter");
                this.spriteStack.push(filterSprite);
            }
            DefineSpriteTag imageSprite = this.createDefineSpriteTag("BitmapFill");
            this.spriteStack.push(imageSprite);
            DefineSpriteTag clipSprite = this.createDefineSpriteTag("BitmapFill_Clip");
            this.spriteStack.push(clipSprite);
            List<ShapeRecord> clipRectRecords = ShapeHelper.rectangle(0.0, 0.0, defImage.getWidth(), defImage.getHeight());
            DefineShapeTag clipShape = this.createDefineShapeTag(null, clipRectRecords, new SolidColorFillNode(), null, context.getTransform(), new Winding[0]);
            FXGMatrix bitmapMatrix = TypeHelper.bitmapFillMatrix(fillNode, defImage, edgeBounds);
            FXGMatrix clipMatrix = new FXGMatrix(bitmapMatrix.a, bitmapMatrix.b, bitmapMatrix.c, bitmapMatrix.d, 0.0, 0.0);
            clipMatrix.scale(0.05, 0.05);
            clipMatrix.translate(bitmapMatrix.tx, bitmapMatrix.ty);
            GraphicContext clipContext = new GraphicContext();
            clipContext.setTransform(clipMatrix);
            this.PlaceObject3Tag(clipShape, clipContext);
            this.spriteStack.pop();
            clipContext.setTransform(context.getTransform());
            PlaceObject3Tag po3clip = this.PlaceObject3Tag(clipSprite, clipContext);
            po3clip.setClipDepth(po3clip.getDepth() + 1);
            po3clip.setHasClipDepth(true);
            Styles styles = new Styles(new FillStyleArray(), new LineStyleArray());
            ShapeWithStyle sws = new ShapeWithStyle(styles);
            int lineStyleIndex = 0;
            int fillStyle0Index = 1;
            int fillStyle1Index = 0;
            FillStyle fillStyle = this.createFillStyle(fill, edgeBounds);
            if (fillStyle != null) {
                sws.getFillStyles().add(fillStyle);
            }
            if (windings.length > 0) {
                ShapeHelper.setPathStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index, styles);
            } else {
                ShapeHelper.setStyles(shapeRecords, lineStyleIndex, fillStyle0Index, fillStyle1Index, styles);
            }
            sws.addShapeRecords(shapeRecords);
            DefineShape4Tag imageShape = new DefineShape4Tag();
            imageShape.setShapes(sws);
            imageShape.setShapeBounds(edgeBounds);
            imageShape.setEdgeBounds(edgeBounds);
            if (fill != null && windings.length > 0) {
                Winding windingValue = windings[0];
                imageShape.setUsesFillWindingRule(windingValue == Winding.NON_ZERO);
            }
            PlaceObject3Tag po3 = this.PlaceObject3Tag(imageShape, context);
            if (stroke != null) {
                ArrayList<ShapeRecord> shapeRecords2 = new ArrayList<ShapeRecord>(shapeRecords);
                Collections.copy(shapeRecords2, shapeRecords);
                Styles strokeStyles = new Styles(new FillStyleArray(), new LineStyleArray());
                ShapeWithStyle swsStroke = new ShapeWithStyle(strokeStyles);
                AbstractStrokeNode strokeNode = (AbstractStrokeNode)stroke;
                LineStyle2 ls = this.createGenericLineStyle(strokeNode);
                Rect shapeBounds = node.getBounds(shapeRecords2, ls);
                LineStyle lineStyle = this.createLineStyle(stroke, shapeBounds);
                swsStroke.getLineStyles().add(lineStyle);
                lineStyleIndex = 1;
                fillStyle0Index = 0;
                fillStyle1Index = 0;
                ShapeHelper.replaceStyles(shapeRecords2, lineStyleIndex, fillStyle0Index, fillStyle1Index, strokeStyles);
                swsStroke.addShapeRecords(shapeRecords2);
                DefineShape4Tag strokeShape = new DefineShape4Tag();
                strokeShape.setShapes(swsStroke);
                strokeShape.setShapeBounds(shapeBounds);
                strokeShape.setEdgeBounds(edgeBounds);
                po3 = this.PlaceObject3Tag(strokeShape, context);
            }
            this.spriteStack.pop();
            po3 = this.PlaceObject3Tag(imageSprite, new GraphicContext());
            if (filters != null) {
                DefineSpriteTag sprite = this.spriteStack.pop();
                GraphicContext gc = new GraphicContext();
                gc.filters = filters;
                PlaceObject3Tag poFilter = this.PlaceObject3Tag(sprite, gc);
                return poFilter;
            }
            return po3;
        }
        DefineShapeTag shape = this.createDefineShapeTag(node, shapeRecords, fill, stroke, context.getTransform(), windings);
        PlaceObject3Tag po3 = this.PlaceObject3Tag(shape, context);
        return po3;
    }

    protected FillStyle createFillStyle(IFillNode fill, Rect bounds) {
        if (fill instanceof SolidColorFillNode) {
            return this.createFillStyle((SolidColorFillNode)fill);
        }
        if (fill instanceof LinearGradientFillNode) {
            return this.createFillStyle((LinearGradientFillNode)fill, bounds);
        }
        if (fill instanceof RadialGradientFillNode) {
            return this.createFillStyle((RadialGradientFillNode)fill, bounds);
        }
        if (fill instanceof BitmapFillNode) {
            return this.createFillStyle((BitmapFillNode)fill, bounds);
        }
        return null;
    }

    protected FillStyle createFillStyle(SolidColorFillNode fill) {
        FillStyle fs = new FillStyle();
        fs.setColor(TypeHelper.splitColor(TypeHelper.colorARGB(fill.color, fill.alpha)));
        fs.setFillStyleType(0);
        return fs;
    }

    protected FillStyle createFillStyle(BitmapFillNode fill, Rect bounds) {
        FillStyle fs = new FillStyle();
        if (ImageHelper.bitmapFillModeIsRepeat(fill)) {
            fs.setFillStyleType(64);
        } else {
            fs.setFillStyleType(65);
        }
        String sourceFormatted = this.parseSource(fill.source);
        if (sourceFormatted == null) {
            this.problems.add(new FXGMissingAttributeProblem(fill.getDocumentPath(), fill.getStartLine(), fill.getStartColumn(), "source", fill.getNodeName()));
            return null;
        }
        DefineImage img = this.createDefineBitsTag(fill, sourceFormatted);
        if (img != null) {
            fs.setBitmapCharacter(img.getTag());
            fs.setBitmapMatrix(TypeHelper.bitmapFillMatrix(fill, img, bounds).toSWFMatrix());
        }
        return fs;
    }

    protected FillStyle createFillStyle(LinearGradientFillNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.setFillStyleType(16);
        fs.setGradientMatrix(TypeHelper.linearGradientMatrix(node, bounds));
        Gradient gradient = new Gradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        fs.setGradient(gradient);
        return fs;
    }

    protected FillStyle createFillStyle(LinearGradientStrokeNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.setFillStyleType(16);
        fs.setGradientMatrix(TypeHelper.linearGradientMatrix(node, bounds));
        Gradient gradient = new Gradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        fs.setGradient(gradient);
        return fs;
    }

    protected FillStyle createFillStyle(RadialGradientFillNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.setFillStyleType(19);
        fs.setGradientMatrix(TypeHelper.radialGradientMatrix(node, bounds));
        FocalGradient gradient = new FocalGradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        gradient.setFocalPoint((float)node.focalPointRatio);
        fs.setGradient(gradient);
        return fs;
    }

    protected FillStyle createFillStyle(RadialGradientStrokeNode node, Rect bounds) {
        FillStyle fs = new FillStyle();
        fs.setFillStyleType(19);
        fs.setGradientMatrix(TypeHelper.radialGradientMatrix(node, bounds));
        FocalGradient gradient = new FocalGradient();
        this.populateGradient(gradient, node.entries, node.interpolationMethod, node.spreadMethod);
        gradient.setFocalPoint((float)node.focalPointRatio);
        fs.setGradient(gradient);
        return fs;
    }

    protected LineStyle createLineStyle(IStrokeNode stroke, Rect bounds) {
        if (stroke instanceof SolidColorStrokeNode) {
            return this.createLineStyle((SolidColorStrokeNode)stroke);
        }
        if (stroke instanceof LinearGradientStrokeNode) {
            return this.createLineStyle((LinearGradientStrokeNode)stroke, bounds);
        }
        if (stroke instanceof RadialGradientStrokeNode) {
            return this.createLineStyle((RadialGradientStrokeNode)stroke, bounds);
        }
        return null;
    }

    private LineStyle2 createGenericLineStyle(AbstractStrokeNode stroke) {
        int startCapStyle;
        LineStyle2 ls = new LineStyle2();
        ls.setWidth((int)StrictMath.rint(stroke.getWeight() * 20.0));
        int endCapStyle = startCapStyle = this.createCaps(stroke.caps);
        int jointStyle = this.createJoints(stroke.joints);
        boolean noHScaleFlag = stroke.scaleMode == ScaleMode.VERTICAL || stroke.scaleMode == ScaleMode.NONE;
        boolean noVScaleFlag = stroke.scaleMode == ScaleMode.HORIZONTAL || stroke.scaleMode == ScaleMode.NONE;
        ls.setNoHScaleFlag(noHScaleFlag);
        ls.setNoVScaleFlag(noVScaleFlag);
        ls.setJoinStyle(jointStyle);
        ls.setStartCapStyle(startCapStyle);
        ls.setEndCapStyle(endCapStyle);
        ls.setPixelHintingFlag(stroke.pixelHinting);
        if (jointStyle == 2) {
            ls.setMiterLimitFactor((float)stroke.miterLimit);
        }
        return ls;
    }

    protected LineStyle createLineStyle(SolidColorStrokeNode stroke) {
        LineStyle2 ls = this.createGenericLineStyle(stroke);
        ls.setColor(TypeHelper.splitColor(TypeHelper.colorARGB(stroke.color, stroke.alpha)));
        return ls;
    }

    protected LineStyle2 createLineStyle(LinearGradientStrokeNode stroke, Rect bounds) {
        LineStyle2 ls = this.createGenericLineStyle(stroke);
        ls.setFillType(this.createFillStyle(stroke, bounds));
        ls.setHasFillFlag(true);
        return ls;
    }

    protected LineStyle2 createLineStyle(RadialGradientStrokeNode stroke, Rect edgeBounds) {
        LineStyle2 ls = this.createGenericLineStyle(stroke);
        ls.setFillType(this.createFillStyle(stroke, edgeBounds));
        ls.setHasFillFlag(true);
        return ls;
    }

    protected int createCaps(Caps value) {
        if (value != null) {
            return value.ordinal();
        }
        return Caps.NONE.ordinal();
    }

    protected int createJoints(Joints value) {
        if (value != null) {
            return value.ordinal();
        }
        return Joints.ROUND.ordinal();
    }

    protected int createSpreadMode(SpreadMethod value) {
        return value.ordinal();
    }

    protected int createBlendMode(BlendMode value) {
        return value.ordinal();
    }

    protected int createInterpolationMode(InterpolationMethod value) {
        return value.ordinal();
    }

    protected List<Filter> createFilters(List<IFilterNode> list) {
        ArrayList<Filter> filters = new ArrayList<Filter>(list.size());
        for (IFilterNode f : list) {
            Filter rec;
            IDataType filter;
            AbstractFilterNode node;
            if (f instanceof BevelFilterNode) {
                node = (BevelFilterNode)f;
                filter = this.createBevelFilter((BevelFilterNode)node);
                rec = new Filter();
                rec.setFilterID(3);
                rec.setBevelFilter((BevelFilter)filter);
                filters.add(rec);
                continue;
            }
            if (f instanceof BlurFilterNode) {
                node = (BlurFilterNode)f;
                filter = this.createBlurFilter((BlurFilterNode)node);
                rec = new Filter();
                rec.setFilterID(1);
                rec.setBlurFilter((BlurFilter)filter);
                filters.add(rec);
                continue;
            }
            if (f instanceof ColorMatrixFilterNode) {
                node = (ColorMatrixFilterNode)f;
                Filter rec2 = new Filter();
                rec2.setFilterID(6);
                rec2.setColorMatrixFilter(((ColorMatrixFilterNode)node).matrix);
                filters.add(rec2);
                continue;
            }
            if (f instanceof DropShadowFilterNode) {
                node = (DropShadowFilterNode)f;
                filter = this.createDropShadowFilter((DropShadowFilterNode)node);
                rec = new Filter();
                rec.setFilterID(0);
                rec.setDropShadowFilter((DropShadowFilter)filter);
                filters.add(rec);
                continue;
            }
            if (f instanceof GlowFilterNode) {
                node = (GlowFilterNode)f;
                filter = this.createGlowFilter((GlowFilterNode)node);
                rec = new Filter();
                rec.setFilterID(2);
                rec.setGlowFilter((GlowFilter)filter);
                filters.add(rec);
                continue;
            }
            if (f instanceof GradientBevelFilterNode) {
                node = (GradientBevelFilterNode)f;
                filter = this.createGradientBevelFilter((GradientBevelFilterNode)node);
                rec = new Filter();
                rec.setFilterID(7);
                rec.setGradientBevelFilter((GradientBevelFilter)filter);
                filters.add(rec);
                continue;
            }
            if (!(f instanceof GradientGlowFilterNode)) continue;
            node = (GradientGlowFilterNode)f;
            filter = this.createGradientGlowFilter((GradientGlowFilterNode)node);
            rec = new Filter();
            rec.setFilterID(4);
            rec.setGradientGlowFilter((GradientGlowFilter)filter);
            filters.add(rec);
        }
        return filters;
    }

    protected BevelFilter createBevelFilter(BevelFilterNode node) {
        BevelFilter filter = new BevelFilter();
        filter.setAngle((float)(node.angle * Math.PI / 180.0));
        filter.setBlurX((float)node.blurX);
        filter.setBlurY((float)node.blurY);
        filter.setDistance((float)node.distance);
        filter.setStrength((float)node.strength);
        filter.setShadowColor(TypeHelper.splitColor(TypeHelper.colorARGB(node.shadowColor, node.shadowAlpha)));
        filter.setHighlightColor(TypeHelper.splitColor(TypeHelper.colorARGB(node.highlightColor, node.highlightAlpha)));
        filter.setOnTop(node.type == BevelType.FULL);
        filter.setInnerShadow(node.type == BevelType.INNER);
        filter.setPasses(node.quality);
        filter.setKnockout(node.knockout);
        filter.setCompositeSource(true);
        return filter;
    }

    protected BlurFilter createBlurFilter(BlurFilterNode node) {
        BlurFilter filter = new BlurFilter();
        filter.setBlurX((float)node.blurX);
        filter.setBlurY((float)node.blurY);
        filter.setPasses(node.quality);
        return filter;
    }

    protected DropShadowFilter createDropShadowFilter(DropShadowFilterNode node) {
        DropShadowFilter filter = new DropShadowFilter();
        filter.setDropShadowColor(TypeHelper.splitColor(TypeHelper.colorARGB(node.color, node.alpha)));
        filter.setAngle((float)(node.angle * Math.PI / 180.0));
        filter.setBlurX((float)node.blurX);
        filter.setBlurY((float)node.blurY);
        filter.setDistance((float)node.distance);
        filter.setStrength((float)node.strength);
        filter.setPasses(node.quality);
        filter.setCompositeSource(!node.hideObject);
        filter.setKnockout(node.knockout);
        filter.setInnerShadow(node.inner);
        return filter;
    }

    protected GlowFilter createGlowFilter(GlowFilterNode node) {
        GlowFilter filter = new GlowFilter();
        filter.setGlowColor(TypeHelper.splitColor(TypeHelper.colorARGB(node.color, node.alpha)));
        filter.setBlurX((float)node.blurX);
        filter.setBlurY((float)node.blurY);
        filter.setStrength((float)node.strength);
        filter.setKnockout(node.knockout);
        filter.setInnerGlow(node.inner);
        filter.setCompositeSource(true);
        filter.setPasses(node.quality);
        return filter;
    }

    protected GradientBevelFilter createGradientBevelFilter(GradientBevelFilterNode node) {
        GradientBevelFilter filter = new GradientBevelFilter();
        if (node.entries != null) {
            byte count = (byte)node.entries.size();
            filter.setNumColors(count);
            RGBA[] gradientColors = new RGBA[count];
            int[] gradientRatios = new int[count];
            filter.setGradientColors(gradientColors);
            filter.setGradientRatio(gradientRatios);
            GradRecord[] records = this.createGradRecords(node.entries);
            for (int i = 0; i < records.length; ++i) {
                GradRecord record = records[i];
                RGB color = record.getColor();
                gradientColors[i] = color instanceof RGBA ? (RGBA)color : new RGBA(color.getRed(), color.getGreen(), color.getBlue(), 255);
                gradientRatios[i] = record.getRatio();
            }
        }
        filter.setAngle((float)(node.angle * Math.PI / 180.0));
        filter.setBlurX((float)node.blurX);
        filter.setBlurY((float)node.blurY);
        filter.setDistance((float)node.distance);
        filter.setStrength((float)node.strength);
        filter.setKnockout(node.knockout);
        filter.setPasses(node.quality);
        filter.setCompositeSource(true);
        filter.setInnerShadow(node.type == BevelType.INNER);
        filter.setOnTop(node.type == BevelType.FULL);
        return filter;
    }

    protected GradientGlowFilter createGradientGlowFilter(GradientGlowFilterNode node) {
        GradientGlowFilter filter = new GradientGlowFilter();
        if (node.entries != null) {
            byte count = (byte)node.entries.size();
            filter.setNumColors(count);
            RGBA[] gradientColors = new RGBA[count];
            int[] gradientRatio = new int[count];
            GradRecord[] records = this.createGradRecords(node.entries);
            for (int i = 0; i < records.length; ++i) {
                GradRecord record = records[i];
                RGB color = record.getColor();
                gradientColors[i] = color instanceof RGBA ? (RGBA)color : new RGBA(color.getRed(), color.getGreen(), color.getBlue(), 255);
                gradientRatio[i] = record.getRatio();
            }
            filter.setGradientColors(gradientColors);
            filter.setGradientRatio(gradientRatio);
        }
        filter.setAngle((float)(node.angle * Math.PI / 180.0));
        filter.setBlurX((float)node.blurX);
        filter.setBlurY((float)node.blurY);
        filter.setDistance((float)node.distance);
        filter.setStrength((float)node.strength);
        filter.setPasses(node.quality);
        filter.setKnockout(node.knockout);
        filter.setInnerGlow(node.inner);
        filter.setCompositeSource(true);
        return filter;
    }

    protected void populateGradient(Gradient gradient, List<GradientEntryNode> entries, InterpolationMethod interpolation, SpreadMethod spread) {
        gradient.setGradientRecords(Arrays.asList(this.createGradRecords(entries)));
        if (interpolation != null) {
            gradient.setInterpolationMode(this.createInterpolationMode(interpolation));
        }
        if (spread != null) {
            gradient.setSpreadMode(this.createSpreadMode(spread));
        }
    }

    protected GradRecord[] createGradRecords(List<GradientEntryNode> entries) {
        int count = entries.size();
        GradRecord[] records = new GradRecord[count];
        double previousRatio = 0.0;
        for (int currentIndex = 0; currentIndex < count; ++currentIndex) {
            GradRecord record;
            GradientEntryNode entry = entries.get(currentIndex);
            double thisRatio = entry.ratio;
            if (Double.isNaN(thisRatio)) {
                if (currentIndex == 0) {
                    thisRatio = 0.0;
                } else if (currentIndex == count - 1) {
                    thisRatio = 1.0;
                } else {
                    int entryGap;
                    double nextRatio = 1.0;
                    int nextIndex = count - 1;
                    for (int i = currentIndex; i < count; ++i) {
                        GradientEntryNode nextEntry = entries.get(i);
                        if (Double.isNaN(nextEntry.ratio)) continue;
                        nextRatio = nextEntry.ratio;
                        nextIndex = i;
                        break;
                    }
                    thisRatio = (entryGap = nextIndex - (currentIndex - 1)) > 0 ? previousRatio + (nextRatio - previousRatio) / (double)entryGap : previousRatio;
                }
            }
            records[currentIndex] = record = new GradRecord(TypeHelper.gradientRatio(thisRatio), TypeHelper.splitColor(TypeHelper.colorARGB(entry.color, entry.alpha)));
            previousRatio = thisRatio;
        }
        return records;
    }

    protected String parseSource(String source) {
        if (source != null && (source = source.trim()).startsWith("@Embed(")) {
            if ((source = source.substring(7).trim()).endsWith(")")) {
                source = source.substring(0, source.length() - 1).trim();
            }
            if (source.charAt(0) == '\'' && source.charAt(source.length() - 1) == '\'') {
                source = source.substring(1, source.length() - 1).trim();
            }
        }
        return source;
    }

    private void markLeafNodesAsMask(IMaskableNode maskableNode, GroupNode mask) {
        if (mask == null || mask.children == null) {
            return;
        }
        for (GraphicContentNode gcNode : mask.children) {
            if (gcNode instanceof GroupNode) {
                this.markLeafNodesAsMask(maskableNode, (GroupNode)gcNode);
                continue;
            }
            if (maskableNode.getMaskType() != MaskType.CLIP) continue;
            gcNode.isPartofClipMask = true;
        }
    }

    @Override
    public ITypeDefinition[] getDependencies() {
        return new ITypeDefinition[0];
    }

    private static class PathIteratorWrapper
    implements IShapeIterator {
        private PathIterator pi;

        public PathIteratorWrapper(PathIterator pi) {
            this.pi = pi;
        }

        @Override
        public short currentSegment(double[] coords) {
            int code = this.pi.currentSegment(coords);
            return (short)code;
        }

        @Override
        public boolean isDone() {
            return this.pi.isDone();
        }

        @Override
        public void next() {
            this.pi.next();
        }
    }
}

