/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.ILiteralNode;
import org.apache.royale.compiler.tree.as.IOperatorNode;
import org.apache.royale.compiler.tree.as.IUnaryOperatorNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class ValidTypeofRule
extends LinterRule {
    private static final Set<String> VALID_RESULTS = new HashSet<String>();

    public ValidTypeofRule() {
        VALID_RESULTS.add("boolean");
        VALID_RESULTS.add("function");
        VALID_RESULTS.add("number");
        VALID_RESULTS.add("object");
        VALID_RESULTS.add("string");
        VALID_RESULTS.add("xml");
        VALID_RESULTS.add("undefined");
    }

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.Op_TypeOfID, (node, tokenQuery, problems) -> this.checkUnaryOperatorNode((IUnaryOperatorNode)node, tokenQuery, problems));
        return result;
    }

    private void checkUnaryOperatorNode(IUnaryOperatorNode typeofNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        IExpressionNode otherNode;
        if (!IOperatorNode.OperatorType.TYPEOF.equals((Object)typeofNode.getOperator())) {
            return;
        }
        IASNode parentNode = typeofNode.getParent();
        if (!(parentNode instanceof IBinaryOperatorNode)) {
            return;
        }
        IBinaryOperatorNode binaryOperatorNode = (IBinaryOperatorNode)parentNode;
        IOperatorNode.OperatorType parentOperatorType = binaryOperatorNode.getOperator();
        if (!(IOperatorNode.OperatorType.EQUAL.equals((Object)parentOperatorType) || IOperatorNode.OperatorType.NOT_EQUAL.equals((Object)parentOperatorType) || IOperatorNode.OperatorType.STRICT_EQUAL.equals((Object)parentOperatorType) || IOperatorNode.OperatorType.STRICT_NOT_EQUAL.equals((Object)parentOperatorType))) {
            return;
        }
        IExpressionNode iExpressionNode = otherNode = binaryOperatorNode.getLeftOperandNode() == typeofNode ? binaryOperatorNode.getRightOperandNode() : binaryOperatorNode.getLeftOperandNode();
        if (!(otherNode instanceof ILiteralNode)) {
            return;
        }
        ILiteralNode stringLiteral = (ILiteralNode)otherNode;
        if (!ILiteralNode.LiteralType.STRING.equals((Object)stringLiteral.getLiteralType())) {
            return;
        }
        if (VALID_RESULTS.contains(stringLiteral.getValue())) {
            return;
        }
        problems.add(new ValidTypeofLinterProblem(stringLiteral));
    }

    public static class ValidTypeofLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "String '${value}' is not a valid result for typeof operator";
        public String value;

        public ValidTypeofLinterProblem(ILiteralNode node) {
            super((ISourceLocation)node);
            this.value = node.getValue();
        }
    }
}

