/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Tag;
import flash.swf.TagHandler;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineTag;
import java.util.HashMap;
import java.util.Map;

public class Dictionary {
    private static DefineTag INVALID_TAG = new DefineTag(0){

        @Override
        public void visit(TagHandler t) {
        }
    };
    Map<Integer, DefineTag> ids = new HashMap<Integer, DefineTag>();
    Map<DefineTag, Integer> tags = new HashMap<DefineTag, Integer>();
    Map<String, DefineTag> names = new HashMap<String, DefineTag>();
    Map<String, DefineFont> fonts = new HashMap<String, DefineFont>();
    private int nextId = 1;

    public boolean contains(int id) {
        return this.ids.containsKey(new Integer(id));
    }

    public boolean contains(DefineTag tag) {
        return this.tags.containsKey(tag);
    }

    public int getId(DefineTag tag) {
        if (tag == null || tag == INVALID_TAG) {
            return -1;
        }
        Integer idobj = this.tags.get(tag);
        if (idobj == null) {
            for (Map.Entry<Integer, DefineTag> entry : this.ids.entrySet()) {
                if (entry.getValue() != tag) continue;
                idobj = entry.getKey();
                break;
            }
        }
        if (idobj == null) assert (false) : "encoding error, " + tag.name + " not in dictionary";
        return idobj;
    }

    public int add(DefineTag tag) {
        assert (tag != null);
        Integer obj = this.tags.get(tag);
        if (obj != null) {
            return obj;
        }
        Integer key = new Integer(this.nextId++);
        this.tags.put(tag, key);
        this.ids.put(key, tag);
        return key;
    }

    public void add(int id, DefineTag s) throws IllegalArgumentException {
        Integer key = new Integer(id);
        Tag t = this.ids.get(key);
        if (t != null) {
            if (t.equals(s)) {
                throw new IllegalArgumentException("symbol " + id + " redefined by identical tag");
            }
            throw new IllegalArgumentException("symbol " + id + " redefined by different tag");
        }
        this.ids.put(key, s);
    }

    public void addName(DefineTag s, String name) {
        this.names.put(name, s);
    }

    private static String makeFontKey(String name, boolean bold, boolean italic) {
        return name + (bold ? "_bold_" : "_normal_") + (italic ? "_italic" : "_regular");
    }

    public void addFontFace(DefineFont defineFont) {
        this.fonts.put(Dictionary.makeFontKey(defineFont.getFontName(), defineFont.isBold(), defineFont.isItalic()), defineFont);
    }

    public DefineFont getFontFace(String name, boolean bold, boolean italic) {
        return this.fonts.get(Dictionary.makeFontKey(name, bold, italic));
    }

    public boolean contains(String name) {
        return this.names.containsKey(name);
    }

    public DefineTag getTag(String name) {
        return this.names.get(name);
    }

    public DefineTag getTag(int idref) throws IllegalArgumentException {
        Integer key = new Integer(idref);
        DefineTag t = this.ids.get(key);
        if (t == null) {
            if (idref != 65535) {
                throw new IllegalArgumentException("symbol " + idref + " not defined");
            }
            return INVALID_TAG;
        }
        return t;
    }

    public void setNextId(int nextId) {
        this.nextId = nextId;
    }

    public int getNextId() {
        return this.nextId;
    }
}

