/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.clients.problems.CompilerProblemCategorizer;
import org.apache.royale.compiler.clients.problems.ProblemFormatter;
import org.apache.royale.compiler.clients.problems.ProblemPrinter;
import org.apache.royale.compiler.clients.problems.ProblemQuery;
import org.apache.royale.compiler.clients.problems.WorkspaceProblemFormatter;
import org.apache.royale.compiler.common.IPathResolver;
import org.apache.royale.compiler.common.VersionInfo;
import org.apache.royale.compiler.config.ConfigurationPathResolver;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.internal.config.localization.LocalizationManager;
import org.apache.royale.compiler.internal.workspaces.Workspace;
import org.apache.royale.compiler.problems.ConfigurationProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.FormatterSettings;
import org.apache.royale.formatter.FormatterUtils;
import org.apache.royale.formatter.MXMLTokenFormatter;
import org.apache.royale.formatter.config.CommandLineConfigurator;
import org.apache.royale.formatter.config.Configuration;
import org.apache.royale.formatter.config.ConfigurationBuffer;
import org.apache.royale.formatter.config.ConfigurationValue;
import org.apache.royale.formatter.config.Configurator;
import org.apache.royale.formatter.config.Semicolons;
import org.apache.royale.utils.FilenameNormalization;

public class FORMATTER {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String DEFAULT_VAR = "files";
    private static final String L10N_CONFIG_PREFIX = "org.apache.royale.compiler.internal.config.configuration";
    @Deprecated
    public int tabSize = 4;
    @Deprecated
    public boolean insertSpaces = false;
    @Deprecated
    public boolean insertFinalNewLine = false;
    @Deprecated
    public boolean placeOpenBraceOnNewLine = true;
    @Deprecated
    public boolean insertSpaceAfterSemicolonInForStatements = true;
    @Deprecated
    public boolean insertSpaceAfterKeywordsInControlFlowStatements = true;
    @Deprecated
    public boolean insertSpaceAfterFunctionKeywordForAnonymousFunctions = false;
    @Deprecated
    public boolean insertSpaceBeforeAndAfterBinaryOperators = true;
    @Deprecated
    public boolean insertSpaceAfterCommaDelimiter = true;
    @Deprecated
    public boolean insertSpaceBetweenMetadataAttributes = true;
    @Deprecated
    public boolean insertSpaceAtStartOfLineComment = true;
    @Deprecated
    public int maxPreserveNewLines = 2;
    @Deprecated
    public Semicolons semicolons = Semicolons.INSERT;
    @Deprecated
    public boolean ignoreProblems = false;
    @Deprecated
    public boolean collapseEmptyBlocks = false;
    @Deprecated
    public boolean mxmlAlignAttributes = false;
    @Deprecated
    public boolean mxmlInsertNewLineBetweenAttributes = false;
    private FormatterSettings settings = new FormatterSettings();
    private ProblemQuery problemQuery;
    private List<File> inputFiles = new ArrayList<File>();
    private boolean writeBackToInputFiles = false;
    private boolean listChangedFiles = false;
    private Configuration configuration;
    private ConfigurationBuffer configBuffer;

    public static void main(String[] args) {
        FORMATTER formatter = new FORMATTER();
        int exitCode = formatter.execute(args);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String[] args) {
        ExitCode exitCode;
        block19: {
            exitCode = ExitCode.SUCCESS;
            this.problemQuery = new ProblemQuery();
            this.problemQuery.setShowWarnings(false);
            try {
                boolean continueFormatting = this.configure(args, this.problemQuery);
                if (continueFormatting) {
                    String filePath;
                    if (this.inputFiles.size() == 0) {
                        String formattedText;
                        StringBuilder builder = new StringBuilder();
                        Scanner sysInScanner = new Scanner(System.in);
                        try {
                            while (sysInScanner.hasNext()) {
                                builder.append(sysInScanner.next());
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)sysInScanner);
                        }
                        filePath = FilenameNormalization.normalize((String)"stdin.as");
                        String fileText = builder.toString();
                        if (!fileText.equals(formattedText = this.formatFileText(filePath, fileText, this.problemQuery.getProblems())) && this.listChangedFiles) {
                            System.out.println(filePath);
                        }
                        if (!this.listChangedFiles) {
                            System.out.println(formattedText);
                        }
                        break block19;
                    }
                    for (File inputFile : this.inputFiles) {
                        String formattedText;
                        filePath = FilenameNormalization.normalize((String)inputFile.getAbsolutePath());
                        FileSpecification fileSpec = new FileSpecification(filePath);
                        String fileText = IOUtils.toString((Reader)fileSpec.createReader());
                        if (!fileText.equals(formattedText = this.formatFileText(filePath, fileText, this.problemQuery.getProblems()))) {
                            if (this.listChangedFiles) {
                                System.out.println(filePath);
                            }
                            if (this.writeBackToInputFiles) {
                                FileUtils.write((File)inputFile, (CharSequence)formattedText, (String)"utf8");
                            }
                        }
                        if (this.listChangedFiles || this.writeBackToInputFiles) continue;
                        System.out.println(formattedText);
                    }
                    break block19;
                }
                exitCode = this.problemQuery.hasFilteredProblems() ? ExitCode.FAILED_WITH_CONFIG_PROBLEMS : ExitCode.PRINT_HELP;
            }
            catch (Exception e) {
                this.problemQuery.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
                System.err.println(e.getMessage());
                exitCode = ExitCode.FAILED_WITH_EXCEPTIONS;
            }
            finally {
                if (this.problemQuery.hasFilteredProblems()) {
                    Workspace workspace = new Workspace();
                    CompilerProblemCategorizer categorizer = new CompilerProblemCategorizer();
                    WorkspaceProblemFormatter formatter = new WorkspaceProblemFormatter(workspace, categorizer);
                    ProblemPrinter printer = new ProblemPrinter((ProblemFormatter)formatter);
                    printer.printProblems(this.problemQuery.getFilteredProblems());
                }
            }
        }
        return exitCode.getCode();
    }

    @Deprecated
    public String formatFile(File file, Collection<ICompilerProblem> problems) throws IOException {
        String filePath = FilenameNormalization.normalize((String)file.getAbsolutePath());
        FileSpecification fileSpec = new FileSpecification(filePath);
        String fileText = IOUtils.toString((Reader)fileSpec.createReader());
        return this.formatFileText(filePath, fileText, problems);
    }

    @Deprecated
    public String formatFile(File file) throws IOException {
        return this.formatFile(file, null);
    }

    @Deprecated
    public String formatFileText(String filePath, String text, Collection<ICompilerProblem> problems) {
        this.settings = this.getLegacyFormatterSettings();
        filePath = FilenameNormalization.normalize((String)filePath);
        String result = null;
        result = filePath.endsWith(".mxml") ? this.formatMXMLTokens(filePath, text, problems) : this.formatASTokens(filePath, text, problems);
        if (this.insertFinalNewLine && result.charAt(result.length() - 1) != '\n') {
            return result + '\n';
        }
        return result;
    }

    @Deprecated
    public String formatFileText(String filePath, String text) {
        return this.formatFileText(filePath, text, null);
    }

    @Deprecated
    public String formatActionScriptText(String text, Collection<ICompilerProblem> problems) {
        this.settings = this.getLegacyFormatterSettings();
        String filePath = FilenameNormalization.normalize((String)"stdin.as");
        return this.formatASTokens(filePath, text, problems);
    }

    @Deprecated
    public String formatActionScriptText(String text) {
        return this.formatActionScriptText(text, null);
    }

    @Deprecated
    public String formatMXMLText(String text, Collection<ICompilerProblem> problems) {
        this.settings = this.getLegacyFormatterSettings();
        String filePath = FilenameNormalization.normalize((String)"stdin.mxml");
        return this.formatMXMLTokens(filePath, text, problems);
    }

    @Deprecated
    public String formatMXMLText(String text) {
        return this.formatMXMLText(text, null);
    }

    private String formatASTokens(String filePath, String text, Collection<ICompilerProblem> problems) {
        ASTokenFormatter asFormatter = new ASTokenFormatter(this.settings);
        return asFormatter.format(filePath, text, problems);
    }

    private String formatMXMLTokens(String filePath, String text, Collection<ICompilerProblem> problems) {
        MXMLTokenFormatter mxmlFormatter = new MXMLTokenFormatter(this.settings);
        return mxmlFormatter.format(filePath, text, problems);
    }

    private FormatterSettings getLegacyFormatterSettings() {
        FormatterSettings result = new FormatterSettings();
        result.tabSize = this.tabSize;
        result.insertSpaces = this.insertSpaces;
        result.insertFinalNewLine = this.insertFinalNewLine;
        result.placeOpenBraceOnNewLine = this.placeOpenBraceOnNewLine;
        result.insertSpaceAfterSemicolonInForStatements = this.insertSpaceAfterSemicolonInForStatements;
        result.insertSpaceAfterKeywordsInControlFlowStatements = this.insertSpaceAfterKeywordsInControlFlowStatements;
        result.insertSpaceAfterFunctionKeywordForAnonymousFunctions = this.insertSpaceAfterFunctionKeywordForAnonymousFunctions;
        result.insertSpaceBeforeAndAfterBinaryOperators = this.insertSpaceBeforeAndAfterBinaryOperators;
        result.insertSpaceAfterCommaDelimiter = this.insertSpaceAfterCommaDelimiter;
        result.insertSpaceBetweenMetadataAttributes = this.insertSpaceBetweenMetadataAttributes;
        result.insertSpaceAtStartOfLineComment = this.insertSpaceAtStartOfLineComment;
        result.maxPreserveNewLines = this.maxPreserveNewLines;
        result.semicolons = this.semicolons;
        result.ignoreProblems = this.ignoreProblems;
        result.collapseEmptyBlocks = this.collapseEmptyBlocks;
        result.mxmlAlignAttributes = this.mxmlAlignAttributes;
        result.mxmlInsertNewLineBetweenAttributes = this.mxmlInsertNewLineBetweenAttributes;
        return result;
    }

    protected String getStartMessage() {
        String message = "Apache Royale ActionScript Formatter (asformat)" + NEWLINE + VersionInfo.buildMessage() + NEWLINE;
        return message;
    }

    protected String getProgramName() {
        return "asformat";
    }

    private void processHelp(List<ConfigurationValue> helpVar) {
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        if (helpVar != null) {
            for (ConfigurationValue val : helpVar) {
                Iterator<String> iterator = val.getArgs().iterator();
                while (iterator.hasNext()) {
                    String element;
                    String keyword = element = iterator.next();
                    while (keyword.startsWith("-")) {
                        keyword = keyword.substring(1);
                    }
                    keywords.add(keyword);
                }
            }
        }
        if (keywords.size() == 0) {
            keywords.add("help");
        }
        String usages = CommandLineConfigurator.usage(this.getProgramName(), DEFAULT_VAR, this.configBuffer, keywords, LocalizationManager.get(), L10N_CONFIG_PREFIX);
        System.out.println(this.getStartMessage());
        System.out.println(usages);
    }

    private boolean configure(String[] args, ProblemQuery problems) {
        try {
            Configurator configurator = new Configurator();
            ConfigurationPathResolver resolver = new ConfigurationPathResolver(System.getProperty("user.dir"));
            configurator.setConfigurationPathResolver((IPathResolver)resolver);
            configurator.setConfiguration(args, DEFAULT_VAR);
            this.configuration = configurator.getConfiguration();
            this.configBuffer = configurator.getConfigurationBuffer();
            problems.addAll(configurator.getConfigurationProblems());
            if (this.configBuffer.getVar("version") != null) {
                System.out.println(VersionInfo.buildMessage());
                return false;
            }
            List<ConfigurationValue> helpVar = this.configBuffer.getVar("help");
            if (helpVar != null || args.length == 0 && this.configuration.getFiles().size() == 0) {
                this.processHelp(helpVar);
                return false;
            }
            if (problems.hasErrors()) {
                return false;
            }
            this.settings = FormatterUtils.configurationToFormatterSettings(this.configuration);
            this.listChangedFiles = this.configuration.getListFiles();
            this.writeBackToInputFiles = this.configuration.getWriteFiles();
            for (String filePath : this.configuration.getFiles()) {
                File inputFile = new File(filePath);
                if (!inputFile.exists()) {
                    throw new ConfigurationException("Input file does not exist: " + filePath, null, -1);
                }
                if (inputFile.isDirectory()) {
                    this.addDirectory(inputFile);
                    continue;
                }
                this.inputFiles.add(inputFile);
            }
            if (this.inputFiles.size() == 0 && this.listChangedFiles) {
                throw new ConfigurationException("Cannot use -list-files with standard input", null, -1);
            }
            if (this.writeBackToInputFiles) {
                if (this.inputFiles.size() == 0) {
                    throw new ConfigurationException("Cannot use -write-files with standard input", null, -1);
                }
                for (File inputFile : this.inputFiles) {
                    if (inputFile.canWrite()) continue;
                    throw new ConfigurationException("File is read-only: " + inputFile.getPath(), null, -1);
                }
            }
            return true;
        }
        catch (ConfigurationException e) {
            ConfigurationProblem problem = new ConfigurationProblem(e);
            problems.add((ICompilerProblem)problem);
            return false;
        }
        catch (Exception e) {
            ConfigurationProblem problem = new ConfigurationProblem(null, -1, -1, -1, -1, e.getMessage());
            problems.add((ICompilerProblem)problem);
            return false;
        }
    }

    private void addDirectory(File inputFile) {
        for (File file : inputFile.listFiles()) {
            String fileName = file.getName();
            if (fileName.startsWith(".")) continue;
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (!fileName.endsWith(".as") && !fileName.endsWith(".mxml")) continue;
            this.inputFiles.add(file);
        }
    }

    static enum ExitCode {
        SUCCESS(0),
        PRINT_HELP(1),
        FAILED_WITH_ERRORS(2),
        FAILED_WITH_EXCEPTIONS(3),
        FAILED_WITH_CONFIG_PROBLEMS(4);

        final int code;

        private ExitCode(int code) {
            this.code = code;
        }

        int getCode() {
            return this.code;
        }
    }
}

