/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.util.Map;
import javax.security.auth.Subject;
import org.apache.qpid.server.model.PermissionedObject;
import org.apache.qpid.server.security.Result;
import org.apache.qpid.server.security.SecurityToken;
import org.apache.qpid.server.security.access.Operation;

public interface AccessControl<T extends SecurityToken> {
    public static final AccessControl ALWAYS_ALLOWED = new FixedResultAccessControl(Result.ALLOWED);
    public static final AccessControl ALWAYS_DENIED = new FixedResultAccessControl(Result.DENIED);

    public Result getDefault();

    public T newToken();

    public T newToken(Subject var1);

    public Result authorise(T var1, Operation var2, PermissionedObject var3);

    public Result authorise(T var1, Operation var2, PermissionedObject var3, Map<String, Object> var4);

    public static final class FixedResultAccessControl
    implements AccessControl<SecurityToken> {
        private final Result _result;

        private FixedResultAccessControl(Result result) {
            this._result = result;
        }

        @Override
        public Result getDefault() {
            return this._result;
        }

        @Override
        public SecurityToken newToken() {
            return null;
        }

        @Override
        public SecurityToken newToken(Subject subject) {
            return null;
        }

        @Override
        public Result authorise(SecurityToken token, Operation operation, PermissionedObject configuredObject) {
            return this._result;
        }

        @Override
        public Result authorise(SecurityToken token, Operation operation, PermissionedObject configuredObject, Map<String, Object> arguments) {
            return this._result;
        }
    }
}

