/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.gems.dojo;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.portals.gems.dojo.DojoPortletHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.portlet.DispatcherPortlet;

public class DojoSpringMVCPortlet
extends DispatcherPortlet {
    private static final Logger log = LoggerFactory.getLogger(DojoSpringMVCPortlet.class);
    protected static final String CRLF = "\r\n";
    protected static final String DOJO_JS_URL_INIT_PARAM = "dojo.js.url";
    protected static final String DOJO_REQUIRES_CORE_INIT_PARAM = "dojo.requires.core";
    protected static final String DOJO_REQUIRES_MODULES_INIT_PARAM = "dojo.requires.modules";
    private String dojoJsUrl;
    private String dojoRequiresCoreList = null;
    private String dojoRequiresAddOnList = null;
    protected String headerPage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFrameworkPortlet() throws PortletException, BeansException {
        super.initFrameworkPortlet();
        DojoSpringMVCPortlet dojoSpringMVCPortlet = this;
        synchronized (dojoSpringMVCPortlet) {
            this.headerPage = this.getInitParameter("HeaderPage");
            this.dojoJsUrl = this.getInitParameter(DOJO_JS_URL_INIT_PARAM);
            this.dojoRequiresCoreList = this.getInitParameter(DOJO_REQUIRES_CORE_INIT_PARAM);
            this.dojoRequiresAddOnList = this.getInitParameter(DOJO_REQUIRES_MODULES_INIT_PARAM);
        }
    }

    protected void doRenderService(RenderRequest request, RenderResponse response) throws Exception {
        super.doRenderService(request, response);
    }

    protected void doHeaders(RenderRequest request, RenderResponse response) {
        DojoPortletHelper.enableDojo(response, this.dojoJsUrl);
        if (this.headerPage != null) {
            try {
                this.getPortletContext().getRequestDispatcher(this.headerPage).include(request, response);
            }
            catch (PortletException e) {
                throw new RuntimeException("Failed to include header page.", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to include header page.", e);
            }
        }
        if (this.dojoRequiresCoreList != null) {
            DojoPortletHelper.contributeDojoRequires(response, this.dojoRequiresCoreList);
        }
        if (this.dojoRequiresAddOnList != null) {
            DojoPortletHelper.contributeDojoRequires(response, this.dojoRequiresAddOnList);
        }
    }

    protected boolean addJavascriptBlock(RenderResponse response, String textContent) {
        return this.addJavascriptElement(response, null, textContent);
    }

    protected boolean addJavascriptInclude(RenderResponse response, String src) {
        return this.addJavascriptElement(response, src, null);
    }

    protected boolean addJavascriptElement(RenderResponse response, String src, String textContent) {
        if (textContent != null && textContent.length() > 0 || src != null && src.length() > 0) {
            DojoPortletHelper.contributeScript(response, "JavaScript", "text/javascript", src, textContent, null, null);
            return true;
        }
        return false;
    }

    protected void dumpAttributes(RenderRequest request) {
        Enumeration attrIter = request.getAttributeNames();
        log.info("request-attributes:");
        while (attrIter.hasMoreElements()) {
            Object attrNm = attrIter.nextElement();
            Object attrVal = request.getAttribute(ObjectUtils.toString(attrNm));
            String attrValDesc = attrVal instanceof String ? (String)attrVal : (attrVal == null ? "null" : attrVal.getClass().getName());
            log.info("   key=" + ObjectUtils.toString(attrNm, (String)"null") + " value=" + attrValDesc);
        }
    }

    protected void dumpSession(RenderRequest request) {
        Enumeration attrIter = request.getPortletSession().getAttributeNames();
        log.info("session-attributes:");
        while (attrIter.hasMoreElements()) {
            Object attrNm = attrIter.nextElement();
            Object attrVal = request.getPortletSession().getAttribute(ObjectUtils.toString(attrNm));
            String attrValDesc = attrVal instanceof String ? (String)attrVal : (attrVal == null ? "null" : attrVal.getClass().getName());
            log.info("   key=" + ObjectUtils.toString(attrNm, (String)"null") + " value=" + attrValDesc);
        }
    }

    protected void dumpNameValue(Map m) {
        if (m == null) {
            log.info("   <null>");
            return;
        }
        if (m.size() == 0) {
            log.info("   <empty>");
            return;
        }
        for (Map.Entry e : m.entrySet()) {
            String eKeyDesc;
            Object eKey = e.getKey();
            Object eVal = e.getValue();
            String string = eKey instanceof String ? (String)eKey : (eKeyDesc = eKey == null ? "null" : eKey.getClass().getName());
            String eValDesc = eVal instanceof String ? (String)eVal : (eVal == null ? "null" : eVal.getClass().getName());
            log.info("   key=" + eKeyDesc + " value=" + eValDesc);
        }
    }
}

