/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.DoWhileLoopTree;
import jpt.sun.source.tree.EnhancedForLoopTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ForLoopTree;
import jpt.sun.source.tree.IfTree;
import jpt.sun.source.tree.StatementTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.WhileLoopTree;
import jpt.sun.source.util.TreePath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Braces {
    static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);
    private static final String BRACES_ID = "Braces_";

    public static ErrorDescription checkFor(HintContext ctx) {
        return Braces.checkStatement(ctx, "LBL_Braces_For", switch (ctx.getPath().getLeaf().getKind()) {
            case Tree.Kind.FOR_LOOP -> ((ForLoopTree)ctx.getPath().getLeaf()).getStatement();
            case Tree.Kind.ENHANCED_FOR_LOOP -> ((EnhancedForLoopTree)ctx.getPath().getLeaf()).getStatement();
            default -> throw new IllegalStateException();
        }, ctx.getPath());
    }

    public static ErrorDescription checkWhile(HintContext ctx) {
        WhileLoopTree wlt = (WhileLoopTree)ctx.getPath().getLeaf();
        return Braces.checkStatement(ctx, "LBL_Braces_While", wlt.getStatement(), ctx.getPath());
    }

    public static ErrorDescription checkDoWhile(HintContext ctx) {
        DoWhileLoopTree dwlt = (DoWhileLoopTree)ctx.getPath().getLeaf();
        return Braces.checkStatement(ctx, "LBL_Braces_DoWhile", dwlt.getStatement(), ctx.getPath());
    }

    public static List<ErrorDescription> checkIf(HintContext ctx) {
        IfTree it = (IfTree)ctx.getPath().getLeaf();
        return Braces.checkifStatements(ctx, "LBL_Braces_If", it.getThenStatement(), it.getElseStatement(), ctx.getPath());
    }

    private static ErrorDescription checkStatement(HintContext ctx, String dnKey, StatementTree statement, TreePath tp) {
        if (statement != null && statement.getKind() != Tree.Kind.EMPTY_STATEMENT && statement.getKind() != Tree.Kind.BLOCK && statement.getKind() != Tree.Kind.TRY && statement.getKind() != Tree.Kind.SYNCHRONIZED && statement.getKind() != Tree.Kind.SWITCH && statement.getKind() != Tree.Kind.ERRONEOUS && !Braces.isErroneousExpression(statement)) {
            return ErrorDescriptionFactory.forTree(ctx, statement, NbBundle.getMessage(Braces.class, dnKey), new BracesFix(ctx.getInfo().getFileObject(), TreePathHandle.create(tp, ctx.getInfo())).toEditorFix());
        }
        return null;
    }

    private static List<ErrorDescription> checkifStatements(HintContext ctx, String dnKey, StatementTree thenSt, StatementTree elseSt, TreePath tp) {
        BracesFix bf;
        boolean fixThen = false;
        boolean fixElse = false;
        if (thenSt != null && thenSt.getKind() != Tree.Kind.EMPTY_STATEMENT && thenSt.getKind() != Tree.Kind.BLOCK && thenSt.getKind() != Tree.Kind.TRY && thenSt.getKind() != Tree.Kind.SYNCHRONIZED && thenSt.getKind() != Tree.Kind.SWITCH && thenSt.getKind() != Tree.Kind.ERRONEOUS && !Braces.isErroneousExpression(thenSt)) {
            fixThen = true;
        }
        if (elseSt != null && elseSt.getKind() != Tree.Kind.EMPTY_STATEMENT && elseSt.getKind() != Tree.Kind.BLOCK && elseSt.getKind() != Tree.Kind.ERRONEOUS && elseSt.getKind() != Tree.Kind.TRY && elseSt.getKind() != Tree.Kind.SYNCHRONIZED && elseSt.getKind() != Tree.Kind.SWITCH && elseSt.getKind() != Tree.Kind.IF && !Braces.isErroneousExpression(elseSt)) {
            fixElse = true;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        if (fixThen) {
            bf = new BracesFix(ctx.getInfo().getFileObject(), TreePathHandle.create(tp, ctx.getInfo()));
            bf.fixThen = fixThen;
            bf.fixElse = fixElse;
            result.add(ErrorDescriptionFactory.forTree(ctx, thenSt, NbBundle.getMessage(Braces.class, dnKey), bf.toEditorFix()));
        }
        if (fixElse) {
            bf = new BracesFix(ctx.getInfo().getFileObject(), TreePathHandle.create(tp, ctx.getInfo()));
            bf.fixThen = fixThen;
            bf.fixElse = fixElse;
            result.add(ErrorDescriptionFactory.forTree(ctx, elseSt, NbBundle.getMessage(Braces.class, dnKey), bf.toEditorFix()));
        }
        return result;
    }

    private static boolean isErroneousExpression(StatementTree statement) {
        return statement instanceof ExpressionStatementTree && ((ExpressionStatementTree)statement).getExpression().getKind() == Tree.Kind.ERRONEOUS;
    }

    private static class BracesFix
    extends JavaFix {
        boolean fixThen;
        boolean fixElse;

        public BracesFix(FileObject file, TreePathHandle tph) {
            super(tph);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(Braces.class, "LBL_Braces_Fix");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy copy = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            if (path != null) {
                TreeMaker make = copy.getTreeMaker();
                Tree oldTree = path.getLeaf();
                oldTree = GeneratorUtilities.get(copy).importComments(oldTree, copy.getCompilationUnit());
                switch (oldTree.getKind()) {
                    case FOR_LOOP: {
                        ForLoopTree oldFor = (ForLoopTree)oldTree;
                        StatementTree oldBlock = oldFor.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite(oldBlock, newBlock);
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree oldEnhancedFor = (EnhancedForLoopTree)oldTree;
                        StatementTree oldBlock = oldEnhancedFor.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite(oldBlock, newBlock);
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree oldWhile = (WhileLoopTree)oldTree;
                        StatementTree oldBlock = oldWhile.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite(oldBlock, newBlock);
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree oldDoWhile = (DoWhileLoopTree)oldTree;
                        StatementTree oldBlock = oldDoWhile.getStatement();
                        BlockTree newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite(oldBlock, newBlock);
                        break;
                    }
                    case IF: {
                        BlockTree newBlock;
                        StatementTree oldBlock;
                        IfTree oldIf = (IfTree)oldTree;
                        if (this.fixThen) {
                            oldBlock = oldIf.getThenStatement();
                            newBlock = make.Block(Collections.singletonList(oldBlock), false);
                            copy.rewrite(oldBlock, newBlock);
                        }
                        if (!this.fixElse) break;
                        oldBlock = oldIf.getElseStatement();
                        newBlock = make.Block(Collections.singletonList(oldBlock), false);
                        copy.rewrite(oldBlock, newBlock);
                    }
                }
            }
        }
    }
}

