/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.BaseUtilities;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Utils {
    public static final String DEFAULT_PROFILE = "NetBeans";
    public static final String TEXT_BASE_MIME_TYPE = "text/base";
    private static final Logger LOG = Logger.getLogger(Utils.class.getName());
    private static final Set<String> ALREADY_LOGGED = Collections.synchronizedSet(new HashSet());

    public static String getLocalizedName(FileObject fo, String defaultValue) {
        try {
            return fo.getFileSystem().getDecorator().annotateName(defaultValue, Collections.singleton(fo));
        }
        catch (FileStateInvalidException ex) {
            if (LOG.isLoggable(Level.FINE)) {
                Utils.logOnce(LOG, Level.FINE, "Can't find localized name of " + fo, ex);
            }
            return defaultValue;
        }
    }

    public static String getLocalizedName(FileObject fo, String key, String defaultValue) {
        return Utils.getLocalizedName(fo, key, defaultValue, false);
    }

    public static String getLocalizedName(FileObject fo, String key, String defaultValue, boolean silent) {
        block4: {
            assert (key != null) : "The key can't be null";
            Object[] bundleInfo = Utils.findResourceBundle(fo, silent);
            if (bundleInfo[1] != null) {
                try {
                    return ((ResourceBundle)bundleInfo[1]).getString(key);
                }
                catch (MissingResourceException ex) {
                    if (silent || !LOG.isLoggable(Level.FINE)) break block4;
                    Utils.logOnce(LOG, Level.FINE, "The bundle '" + bundleInfo[0] + "' is missing key '" + key + "'.", ex);
                }
            }
        }
        return defaultValue;
    }

    private static Object[] findResourceBundle(FileObject fo, boolean silent) {
        assert (fo != null) : "FileObject can't be null";
        Object[] bundleInfo = null;
        String bundleName = null;
        Object attrValue = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (attrValue instanceof String) {
            bundleName = (String)attrValue;
        }
        if (bundleName != null) {
            try {
                bundleInfo = new Object[]{bundleName, NbBundle.getBundle(bundleName)};
            }
            catch (MissingResourceException ex) {
                if (!silent && LOG.isLoggable(Level.FINE)) {
                    Utils.logOnce(LOG, Level.FINE, "Can't find resource bundle for " + fo.getPath(), ex);
                }
            }
        } else if (!silent && LOG.isLoggable(Level.FINE)) {
            Utils.logOnce(LOG, Level.FINE, "The file " + fo.getPath() + " does not specify its resource bundle.", null);
        }
        if (bundleInfo == null) {
            bundleInfo = new Object[]{bundleName, null};
        }
        return bundleInfo;
    }

    public static void logOnce(Logger logger, Level level, String msg, Throwable t) {
        if (!ALREADY_LOGGED.contains(msg)) {
            ALREADY_LOGGED.add(msg);
            if (t != null) {
                logger.log(level, msg, t);
            } else {
                logger.log(level, msg);
            }
            if (ALREADY_LOGGED.size() > 100) {
                ALREADY_LOGGED.clear();
            }
        }
    }

    public static MimePath mimeTypes2mimePath(String[] mimeTypes) {
        MimePath mimePath = MimePath.EMPTY;
        for (int i = 0; i < mimeTypes.length; ++i) {
            mimePath = MimePath.get(mimePath, mimeTypes[i]);
        }
        return mimePath;
    }

    public static <A, B> void diff(Map<A, B> oldMap, Map<A, B> newMap, Map<A, B> addedEntries, Map<A, B> removedEntries) {
        for (A key : oldMap.keySet()) {
            if (!newMap.containsKey(key)) {
                removedEntries.put(key, oldMap.get(key));
                continue;
            }
            if (BaseUtilities.compareObjects(oldMap.get(key), newMap.get(key))) continue;
            addedEntries.put(key, newMap.get(key));
        }
        for (A key : newMap.keySet()) {
            if (oldMap.containsKey(key)) continue;
            addedEntries.put(key, newMap.get(key));
        }
    }

    public static <A, B> boolean quickDiff(Map<A, B> oldMap, Map<A, B> newMap) {
        for (A key : oldMap.keySet()) {
            if (!newMap.containsKey(key)) {
                return true;
            }
            if (BaseUtilities.compareObjects(oldMap.get(key), newMap.get(key))) continue;
            return true;
        }
        for (A key : newMap.keySet()) {
            if (oldMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(FileObject fo, StorageWriter writer) {
        assert (fo != null) : "FileObject can't be null";
        assert (writer != null) : "StorageWriter can't be null";
        try {
            FileLock lock = fo.lock();
            try (OutputStream os = fo.getOutputStream(lock);){
                XMLUtil.write(writer.getDocument(), os, "UTF-8");
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Can't save editor settings to " + fo.getPath(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(FileObject fo, StorageReader handler, boolean validate) {
        assert (fo != null) : "Settings file must not be null";
        assert (handler != null) : "StorageReader can't be null";
        try {
            XMLReader reader = XMLUtil.createXMLReader(validate);
            reader.setEntityResolver(EntityCatalog.getDefault());
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            try (InputStream is = fo.getInputStream();){
                reader.parse(new InputSource(is));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Invalid or corrupted file: " + fo.getPath(), ex);
        }
    }
}

