/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.util.URLEncoder;
import org.apache.myfaces.trinidad.util.URLEncoderFactory;
import org.apache.myfaces.trinidad.util.URLUtils;

public class URLEncoderExternalContext
extends ExternalContextDecorator {
    private ExternalContext _ec;

    public URLEncoderExternalContext(ExternalContext ec) {
        this._ec = ec;
    }

    protected ExternalContext getExternalContext() {
        return this._ec;
    }

    public String encodeBookmarkableURL(String string, Map<String, List<String>> map) {
        URLEncoder encoder = this.getURLEncoder();
        try {
            return encoder.encodeBookmarkableURL(string, map);
        }
        catch (UnsupportedOperationException e) {
            Object response = this._ec.getResponse();
            if (!(response instanceof HttpServletResponse)) {
                throw new UnsupportedOperationException("Only valid for HttpServlet requests");
            }
            String url = URLUtils.encodeURL((String)string, map, (String)this._ec.getResponseCharacterEncoding());
            return url;
        }
    }

    public String encodeNamespace(String string) {
        return super.encodeNamespace(string);
    }

    public String encodePartialActionURL(String string) {
        return super.encodePartialActionURL(string);
    }

    public String encodeRedirectURL(String string, Map<String, List<String>> map) {
        URLEncoder encoder = this.getURLEncoder();
        try {
            return encoder.encodeRedirectURL(string, map);
        }
        catch (UnsupportedOperationException e) {
            Object response = this._ec.getResponse();
            if (!(response instanceof HttpServletResponse)) {
                throw new UnsupportedOperationException("Only valid for HttpServlet requests");
            }
            String url = URLUtils.encodeURL((String)string, map, (String)this._ec.getResponseCharacterEncoding());
            return encoder.encodeRedirectURL(url);
        }
    }

    public String encodeResourceURL(String url) {
        return this.getURLEncoder().encodeResourceURL(url);
    }

    public String encodeActionURL(String url) {
        return this.getURLEncoder().encodeActionURL(url);
    }

    protected URLEncoder getURLEncoder() {
        return URLEncoderFactory.getFactory().getURLEncoder(this._ec);
    }
}

