/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputLabel;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ValueRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.util.MessageUtils;

public class OutputLabelRenderer
extends ValueRenderer {
    private PropertyKey _accessKeyKey;
    private PropertyKey _forKey;
    private PropertyKey _messageTypeKey;
    private PropertyKey _showRequiredKey;

    public OutputLabelRenderer() {
        this(CoreOutputLabel.TYPE);
    }

    protected OutputLabelRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._accessKeyKey = type.findKey("accessKey");
        this._forKey = type.findKey("for");
        this._messageTypeKey = type.findKey("messageType");
        this._showRequiredKey = type.findKey("showRequired");
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        boolean noSpanNeeded;
        ResponseWriter rw = context.getResponseWriter();
        String value = this.getConvertedString(context, component, bean);
        String forId = this.getForId(context, component, bean);
        FormData fd = rc.getFormData();
        if (fd != null) {
            fd.addLabel(forId, value);
        }
        String messageType = this._getMessageType(context, component, bean, forId);
        boolean bl = noSpanNeeded = value == null && (messageType == null || "none".equals(messageType));
        if (!noSpanNeeded) {
            rw.startElement("span", (UIComponent)(this.needComponentInStartElement() ? component : null));
            this.renderId(context, component);
            this.renderAllAttributes(context, rc, component, bean);
        }
        boolean encodedIcons = this.encodeIcons(context, rc, component, bean, messageType, forId);
        if (value != null) {
            char accessKey;
            int accessKeyIndex;
            boolean needsLabel;
            if (encodedIcons) {
                rw.writeText((Object)XhtmlConstants.NBSP_STRING, null);
            }
            if (needsLabel = this.isLabelTagNeeded(rc, component, bean, forId, accessKeyIndex = AccessKeyUtils.getAccessKeyIndex(value, accessKey = OutputLabelRenderer.supportsAccessKeys(rc) ? (char)this.getAccessKey(component, bean) : (char)'\uffff'))) {
                rw.startElement("label", (UIComponent)(this.needComponentInStartElement() ? component : null));
                if (forId != null) {
                    rw.writeAttribute("for", (Object)forId, "for");
                    HiddenLabelUtils.rememberLabel(rc, forId);
                }
                if (accessKey != '\uffff') {
                    rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
                    Agent agent = rc.getAgent();
                    if (accessKeyIndex == 0 && "blackberry".equals(agent.getAgentName())) {
                        rw.startElement("span", null);
                        rw.writeAttribute("style", (Object)"display:inline", null);
                        rw.endElement("span");
                    }
                }
            }
            AccessKeyUtils.renderAccessKeyText(context, (Object)value, accessKey, "AFAccessKeyStyle");
            if (needsLabel) {
                rw.endElement("label");
            }
        }
        if (!noSpanNeeded) {
            rw.endElement("span");
        }
    }

    protected boolean needComponentInStartElement() {
        return true;
    }

    protected boolean encodeIcons(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, String messageType, String forId) throws IOException {
        boolean isInline;
        boolean encodedIcons = false;
        boolean bl = isInline = RequestContext.getCurrentInstance().getClientValidation() == RequestContext.ClientValidation.INLINE;
        if (this._shouldRenderMessageSymbol(rc, messageType, isInline, forId)) {
            String vAlign = this.getDefaultValign(component, bean);
            String destination = this.getMessageDescUrl(component, bean);
            String targetFrame = this.getMessageTargetFrame(component, bean);
            String anchor = MessageUtils.getAnchor(forId);
            ResponseWriter rw = context.getResponseWriter();
            if (isInline) {
                rw.startElement("span", component);
                rw.writeAttribute("id", (Object)(forId + "::icon"), null);
                if (null == messageType || "none".equals(messageType)) {
                    messageType = "error";
                    rw.writeAttribute("style", (Object)"display:none;", null);
                }
            }
            encodedIcons = this.renderMessageSymbol(context, rc, messageType, destination, anchor, targetFrame, vAlign);
            if (isInline) {
                rw.endElement("span");
            }
        }
        if (this.getShowRequired(component, bean)) {
            Icon icon = rc.getIcon("AFRequiredIcon");
            if (icon != null) {
                String vAlign = this.getDefaultValign(component, bean);
                this._renderIcon(context, rc, icon, null, null, null, "REQUIRED_TIP", vAlign);
            }
            encodedIcons = true;
        }
        return encodedIcons;
    }

    protected boolean isLabelTagNeeded(RenderingContext rc, UIComponent component, FacesBean bean, String forId, int accessKeyIndex) {
        return forId != null && !OutputLabelRenderer.isInaccessibleMode((RenderingContext)rc) || accessKeyIndex >= 0;
    }

    protected boolean renderMessageSymbol(FacesContext context, RenderingContext rc, Object type, Object destination, Object anchor, Object targetFrame, Object vAlign) throws IOException {
        Icon icon;
        String iconName = null;
        String altTextKey = null;
        if ("error".equals(type)) {
            iconName = destination == null ? "AFErrorIcon" : "AFErrorAnchorIcon";
            altTextKey = "ERROR_TIP";
        } else if ("info".equals(type)) {
            iconName = destination == null ? "AFInfoIcon" : "AFInfoAnchorIcon";
            altTextKey = "INFO_TIP";
        } else if ("warning".equals(type)) {
            iconName = destination == null ? "AFWarningIcon" : "AFWarningAnchorIcon";
            altTextKey = "WARNING_TIP";
        }
        if (iconName != null && (icon = rc.getIcon(iconName)) != null) {
            this._renderIcon(context, rc, icon, destination, anchor, targetFrame, altTextKey, vAlign);
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|outputLabel";
    }

    private void _renderIcon(FacesContext context, RenderingContext rc, Icon icon, Object destination, Object anchor, Object targetFrame, String altTextKey, Object vAlign) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean renderedAnchor = false;
        if ((destination != null || anchor != null) && OutputLabelRenderer.supportsNavigation(rc)) {
            writer.startElement("a", null);
            this.renderEncodedActionURI(context, "href", destination);
            writer.writeAttribute("target", targetFrame, null);
            writer.writeAttribute("name", anchor, null);
            renderedAnchor = true;
        }
        String altText = rc.getTranslatedString(altTextKey);
        if (vAlign == null) {
            vAlign = OutputUtils.getMiddleIconAlignment(rc);
        }
        OutputUtils.renderIcon(context, rc, icon, altText, vAlign, renderedAnchor);
        if (renderedAnchor) {
            writer.endElement("a");
        }
    }

    private String _getMessageType(FacesContext context, UIComponent component, FacesBean bean, String forId) throws IOException {
        FacesMessage message;
        String messageType = this.getMessageType(component, bean);
        if (null == messageType && (message = MessageUtils.getFacesMessage(context, forId)) != null) {
            messageType = MessageUtils.getMessageTypeFromSeverity(message.getSeverity());
        }
        return messageType;
    }

    protected boolean getShowRequired(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._showRequiredKey);
        if (o == null) {
            o = this._showRequiredKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getDefaultValign(UIComponent component, FacesBean bean) {
        return null;
    }

    protected char getAccessKey(UIComponent component, FacesBean bean) {
        return OutputLabelRenderer.toChar((Object)bean.getProperty(this._accessKeyKey));
    }

    protected String getFor(UIComponent component, FacesBean bean) {
        return OutputLabelRenderer.toString((Object)bean.getProperty(this._forKey));
    }

    protected String getForId(FacesContext context, UIComponent component, FacesBean bean) {
        String forValue = this.getFor(component, bean);
        if (forValue == null) {
            return null;
        }
        return MessageUtils.getClientIdFor(context, component, forValue);
    }

    protected String getMessageType(UIComponent component, FacesBean bean) {
        if (this._messageTypeKey == null) {
            return null;
        }
        return OutputLabelRenderer.toString((Object)bean.getProperty(this._messageTypeKey));
    }

    protected String getMessageDescUrl(UIComponent component, FacesBean bean) {
        return null;
    }

    protected String getMessageTargetFrame(UIComponent component, FacesBean bean) {
        return null;
    }

    private boolean _shouldRenderMessageSymbol(RenderingContext rc, String messageType, boolean isInline, String forId) {
        if (null != messageType && !"none".equals(messageType) || forId != null && isInline) {
            Agent agent = rc.getAgent();
            return agent == null || !"blackberry".equals(agent.getAgentName()) && !"genericpda".equals(agent.getAgentName()) || null != messageType && !"none".equals(messageType);
        }
        return false;
    }
}

