/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datascroller;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.component.html.ext.HtmlCommandLink;
import org.apache.myfaces.custom.datascroller.HtmlDataScroller;
import org.apache.myfaces.custom.datascroller.ScrollerActionEvent;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class HtmlDataScrollerRenderer
extends HtmlRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.DataScroller";
    protected static final String PAGE_NAVIGATION = "idx".intern();

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        RendererUtils.checkParamValidity(context, component, HtmlDataScroller.class);
        Map parameter = context.getExternalContext().getRequestParameterMap();
        String param = (String)parameter.get(component.getClientId(context));
        if (param != null && param.length() > 0) {
            if (param.startsWith(PAGE_NAVIGATION)) {
                component.queueEvent((FacesEvent)new ScrollerActionEvent(component, Integer.parseInt(param.substring(PAGE_NAVIGATION.length(), param.length()))));
            } else {
                component.queueEvent((FacesEvent)new ScrollerActionEvent(component, param));
            }
        }
    }

    protected void setVariables(FacesContext facescontext, HtmlDataScroller scroller) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            int pageCount = scroller.getPageCount();
            requestMap.put(pageCountVar, new Integer(pageCount));
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            int pageIndex = scroller.getRowCount() > 0 ? scroller.getPageIndex() : 0;
            requestMap.put(pageIndexVar, new Integer(pageIndex));
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            int rowsCount = scroller.getRowCount();
            requestMap.put(rowsCountVar, new Integer(rowsCount));
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            int max;
            int displayedRowsCount = scroller.getRows();
            if (displayedRowsCount > (max = scroller.getRowCount() - scroller.getFirstRow())) {
                displayedRowsCount = max;
            }
            requestMap.put(displayedRowsCountVar, new Integer(displayedRowsCount));
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            int firstRowIndex = scroller.getRowCount() > 0 ? scroller.getFirstRow() + 1 : 0;
            requestMap.put(firstRowIndexVar, new Integer(firstRowIndex));
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            int count;
            int lastRowIndex = scroller.getFirstRow() + scroller.getRows();
            if (lastRowIndex > (count = scroller.getRowCount())) {
                lastRowIndex = count;
            }
            requestMap.put(lastRowIndexVar, new Integer(lastRowIndex));
        }
    }

    public void removeVariables(FacesContext facescontext, HtmlDataScroller scroller) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            requestMap.remove(pageCountVar);
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            requestMap.remove(pageIndexVar);
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            requestMap.remove(rowsCountVar);
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            requestMap.remove(displayedRowsCountVar);
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            requestMap.remove(firstRowIndexVar);
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            requestMap.remove(lastRowIndexVar);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeBegin(facesContext, uiComponent);
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlDataScroller.class);
        HtmlDataScroller scroller = (HtmlDataScroller)uiComponent;
        this.setVariables(facesContext, scroller);
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
        RendererUtils.checkParamValidity(facescontext, uicomponent, HtmlDataScroller.class);
        if (uicomponent.getChildCount() > 0) {
            HtmlDataScroller scroller = (HtmlDataScroller)uicomponent;
            String scrollerIdPagePrefix = scroller.getId() + PAGE_NAVIGATION;
            for (UIComponent child : uicomponent.getChildren()) {
                String childId = child.getId();
                if (childId == null || childId.startsWith(scrollerIdPagePrefix)) continue;
                RendererUtils.renderChild(facescontext, child);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, HtmlDataScroller.class);
        HtmlDataScroller scroller = (HtmlDataScroller)uiComponent;
        if (scroller.getUIData() == null) {
            return;
        }
        this.renderScroller(facesContext, scroller);
        this.removeVariables(facesContext, scroller);
    }

    protected void renderScroller(FacesContext facesContext, HtmlDataScroller scroller) throws IOException {
        String style;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!scroller.isRenderFacetsIfSinglePage() && scroller.getPageCount() <= 1) {
            return;
        }
        if (scroller.getFirst() == null && scroller.getFastRewind() == null && scroller.getPrevious() == null && !scroller.isPaginator() && scroller.getNext() == null && scroller.getFastForward() == null && scroller.getLast() == null) {
            return;
        }
        this.writeScrollerStart(writer, scroller);
        String styleClass = scroller.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if ((style = scroller.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.writeScrollerRowStart(writer, scroller);
        boolean startActive = scroller.getPageIndex() != 1;
        boolean endActive = scroller.getPageIndex() != scroller.getPageCount();
        UIComponent facetComp = scroller.getFirst();
        if (facetComp != null) {
            this.writeScrollerElementStart(writer, scroller);
            this.writeStyleClass("firstStyleClass", scroller.getFirstStyleClass(), writer);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_FIRST, startActive, scroller.isRenderFacetLinksIfFirstPage(), scroller.isDisableFacetLinksIfFirstPage());
            this.writeScrollerElementEnd(writer, scroller);
        }
        if ((facetComp = scroller.getFastRewind()) != null) {
            this.writeScrollerElementStart(writer, scroller);
            this.writeStyleClass("fastrStyleClass", scroller.getFastrStyleClass(), writer);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_FAST_REWIND, startActive, scroller.isRenderFacetLinksIfFirstPage(), scroller.isDisableFacetLinksIfFirstPage());
            this.writeScrollerElementEnd(writer, scroller);
        }
        if ((facetComp = scroller.getPrevious()) != null) {
            this.writeScrollerElementStart(writer, scroller);
            this.writeStyleClass("previous", scroller.getPreviousStyleClass(), writer);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_PREVIOUS, startActive, scroller.isRenderFacetLinksIfFirstPage(), scroller.isDisableFacetLinksIfFirstPage());
            this.writeScrollerElementEnd(writer, scroller);
        }
        if (scroller.isPaginator()) {
            if (!scroller.isSingleElementLayout()) {
                this.writeScrollerElementStart(writer, scroller);
            }
            this.renderPaginator(facesContext, scroller);
            if (!scroller.isSingleElementLayout()) {
                this.writeScrollerElementEnd(writer, scroller);
            }
        }
        if ((facetComp = scroller.getNext()) != null) {
            this.writeScrollerElementStart(writer, scroller);
            this.writeStyleClass("next", scroller.getNextStyleClass(), writer);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_NEXT, endActive, scroller.isRenderFacetLinksIfLastPage(), scroller.isDisableFacetLinksIfLastPage());
            this.writeScrollerElementEnd(writer, scroller);
        }
        if ((facetComp = scroller.getFastForward()) != null) {
            this.writeScrollerElementStart(writer, scroller);
            this.writeStyleClass("fastf", scroller.getFastfStyleClass(), writer);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_FAST_FORWARD, endActive, scroller.isRenderFacetLinksIfLastPage(), scroller.isDisableFacetLinksIfLastPage());
            this.writeScrollerElementEnd(writer, scroller);
        }
        if ((facetComp = scroller.getLast()) != null) {
            this.writeScrollerElementStart(writer, scroller);
            this.writeStyleClass("last", scroller.getLastStyleClass(), writer);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_LAST, endActive, scroller.isRenderFacetLinksIfLastPage(), scroller.isDisableFacetLinksIfLastPage());
            this.writeScrollerElementEnd(writer, scroller);
        }
        this.writeScrollerRowEnd(writer, scroller);
        this.writeScrollerEnd(writer, scroller);
    }

    private void writeStyleClass(String jsfAttrName, String styleClass, ResponseWriter writer) throws IOException {
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, jsfAttrName);
        }
    }

    private boolean isListLayout(HtmlDataScroller scroller) {
        return scroller.isListLayout();
    }

    protected void writeScrollerEnd(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.endElement(this.isListLayout(scroller) ? "ul" : "table");
    }

    protected void writeScrollerRowEnd(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        if (!this.isListLayout(scroller)) {
            writer.endElement("tr");
        }
    }

    protected void writeScrollerElementEnd(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.endElement(this.isListLayout(scroller) ? "li" : "td");
    }

    protected void writeScrollerElementStart(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.startElement(this.isListLayout(scroller) ? "li" : "td", (UIComponent)scroller);
    }

    protected void writeScrollerRowStart(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        if (!this.isListLayout(scroller)) {
            writer.startElement("tr", (UIComponent)scroller);
        }
    }

    protected void writeScrollerStart(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.startElement(this.isListLayout(scroller) ? "ul" : "table", (UIComponent)scroller);
    }

    protected void renderFacet(FacesContext facesContext, HtmlDataScroller scroller, UIComponent facetComp, String facetName, boolean active, boolean renderLinks, boolean disableLinks) throws IOException {
        String onclick = scroller.getOnclick();
        String ondblclick = scroller.getOndblclick();
        HtmlCommandLink link = this.getLink(facesContext, scroller, facetName);
        if (onclick != null) {
            link.setOnclick(onclick);
        }
        if (ondblclick != null) {
            link.setOndblclick(ondblclick);
        }
        if (active) {
            if (disableLinks && link.isDisabled()) {
                link.setDisabled(false);
            }
            link.encodeBegin(facesContext);
        } else if (renderLinks) {
            if (disableLinks && !link.isDisabled()) {
                link.setDisabled(true);
            }
            link.encodeBegin(facesContext);
        }
        facetComp.encodeBegin(facesContext);
        if (!facetComp.getRendersChildren()) {
            facetComp.encodeChildren(facesContext);
        }
        facetComp.encodeEnd(facesContext);
        if (active || renderLinks) {
            link.encodeEnd(facesContext);
        }
    }

    protected void renderPaginator(FacesContext facesContext, HtmlDataScroller scroller) throws IOException {
        int start;
        int pages;
        int pageCount;
        ResponseWriter writer = facesContext.getResponseWriter();
        int maxPages = scroller.getPaginatorMaxPages();
        if (maxPages <= 1) {
            maxPages = 2;
        }
        if ((pageCount = scroller.getPageCount()) <= 1) {
            return;
        }
        int pageIndex = scroller.getPageIndex();
        int delta = maxPages / 2;
        if (pageCount > maxPages && pageIndex > delta) {
            pages = maxPages;
            start = pageIndex - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        if (!scroller.isSingleElementLayout()) {
            String style;
            this.writePaginatorStart(writer, scroller);
            String styleClass = scroller.getPaginatorTableClass();
            if (styleClass != null) {
                writer.writeAttribute("class", (Object)styleClass, "paginatorTableClass");
            }
            if ((style = scroller.getPaginatorTableStyle()) != null) {
                writer.writeAttribute("style", (Object)style, "paginatorTableStyle");
            }
            this.writePaginatorRowStart(writer, scroller);
        }
        String onclick = scroller.getOnclick();
        String ondblclick = scroller.getOndblclick();
        if (scroller.getChildCount() != 0) {
            String scrollerIdPagePrefix = scroller.getId() + PAGE_NAVIGATION;
            Iterator it = scroller.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                String childId = child.getId();
                if (childId == null || !childId.startsWith(scrollerIdPagePrefix)) continue;
                try {
                    int p = Integer.parseInt(childId.substring(scrollerIdPagePrefix.length()));
                    if (p >= start || p < start + pages) continue;
                    it.remove();
                }
                catch (NumberFormatException e) {}
            }
        }
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            String cStyle;
            String cStyleClass;
            int idx = i + 1;
            this.writePaginatorElementStart(writer, scroller);
            if (idx == pageIndex) {
                cStyleClass = scroller.getPaginatorActiveColumnClass();
                cStyle = scroller.getPaginatorActiveColumnStyle();
            } else {
                cStyleClass = scroller.getPaginatorColumnClass();
                cStyle = scroller.getPaginatorColumnStyle();
            }
            if (cStyleClass != null) {
                writer.writeAttribute("class", (Object)cStyleClass, idx == pageIndex ? "paginatorActiveColumnClass" : "paginatorColumnClass");
            }
            if (cStyle != null) {
                writer.writeAttribute("style", (Object)cStyle, idx == pageIndex ? "paginatorActiveColumnStyle" : "paginatorColumnStyle");
            }
            if (idx == pageIndex && !scroller.isPaginatorRenderLinkForActive()) {
                writer.write(Integer.toString(idx));
            } else {
                HtmlCommandLink link = this.getLink(facesContext, scroller, Integer.toString(idx), idx);
                if (onclick != null) {
                    link.setOnclick(onclick);
                }
                if (ondblclick != null) {
                    link.setOndblclick(ondblclick);
                }
                link.encodeBegin(facesContext);
                link.encodeChildren(facesContext);
                link.encodeEnd(facesContext);
            }
            this.writePaginatorElementEnd(writer, scroller);
        }
        if (!scroller.isSingleElementLayout()) {
            this.writePaginatorRowEnd(writer, scroller);
            this.writePaginatorEnd(writer, scroller);
        }
    }

    protected void writePaginatorEnd(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.endElement(this.isListLayout(scroller) ? "ul" : "table");
    }

    protected void writePaginatorRowEnd(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        if (!this.isListLayout(scroller)) {
            writer.endElement("tr");
        }
    }

    protected void writePaginatorElementEnd(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.endElement(this.isListLayout(scroller) ? "li" : "td");
    }

    protected void writePaginatorElementStart(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.startElement(this.isListLayout(scroller) ? "li" : "td", (UIComponent)scroller);
    }

    protected void writePaginatorRowStart(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        if (!this.isListLayout(scroller)) {
            writer.startElement("tr", (UIComponent)scroller);
        }
    }

    protected void writePaginatorStart(ResponseWriter writer, HtmlDataScroller scroller) throws IOException {
        writer.startElement(this.isListLayout(scroller) ? "ul" : "table", (UIComponent)scroller);
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, HtmlDataScroller scroller, String text, int pageIndex) {
        String id = PAGE_NAVIGATION + Integer.toString(pageIndex);
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)scroller.findComponent(scroller.getId() + id);
        if (link == null) {
            link = new HtmlCommandLink();
            link.setId(scroller.getId() + id);
            link.setTransient(true);
            UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
            parameter.setId(scroller.getId() + id + "_param");
            parameter.setTransient(true);
            parameter.setName(scroller.getClientId(facesContext));
            parameter.setValue((Object)id);
            List children = link.getChildren();
            children.add(parameter);
            if (text != null) {
                HtmlOutputText uiText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
                uiText.setId(scroller.getId() + id + "_text");
                uiText.setTransient(true);
                uiText.setValue((Object)text);
                children.add(uiText);
            }
            scroller.getChildren().add(link);
        } else {
            UIOutput uiText = (UIOutput)link.findComponent(scroller.getId() + id + "_text");
            if (uiText != null) {
                uiText.setValue((Object)text);
            }
        }
        return link;
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, HtmlDataScroller scroller, String facetName) {
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)scroller.findComponent(scroller.getId() + facetName);
        if (link == null) {
            link = new HtmlCommandLink();
            link.setId(scroller.getId() + facetName);
            link.setTransient(true);
            UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
            parameter.setId(scroller.getId() + facetName + "_param");
            parameter.setTransient(true);
            parameter.setName(scroller.getClientId(facesContext));
            parameter.setValue((Object)facetName);
            List children = link.getChildren();
            children.add(parameter);
            scroller.getChildren().add(link);
        }
        return link;
    }
}

